/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.OntologyDto;
import fr.gouv.vitamui.referential.service.OntologyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"ontology"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/ontology"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class OntologyController
extends AbstractUiRestController {
    protected final OntologyService service;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OntologyController.class);

    @Autowired
    public OntologyController(OntologyService service) {
        this.service = service;
    }

    @ApiOperation(value="Get entity")
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<OntologyDto> getAll(Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.service.getAll(this.buildUiHttpContext(), criteria);
    }

    @ApiOperation(value="Get entities paginated")
    @GetMapping(params={"page", "size"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedValuesDto<OntologyDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam Optional<String> criteria, @RequestParam Optional<String> orderBy, @RequestParam Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("Get all with criteria={}", criteria);
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.service.getAllPaginated(page, size, criteria, orderBy, direction, this.buildUiHttpContext());
    }

    @ApiOperation(value="Get ingest contract by ID")
    @GetMapping(path={"/{identifier:.+}"})
    @ResponseStatus(value=HttpStatus.OK)
    public OntologyDto getById(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("getById {} / {}", (Object)identifier, (Object)URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        return (OntologyDto)this.service.getOne(this.buildUiHttpContext(), URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @ApiOperation(value="Check ability to create ontology")
    @PostMapping(path={"/check"})
    public ResponseEntity<Void> check(@RequestBody OntologyDto ontologyDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)ontologyDto);
        LOGGER.debug("check ability to create ontology={}", (Object)ontologyDto);
        boolean exist = this.service.check(this.buildUiHttpContext(), ontologyDto);
        LOGGER.debug("response value={}" + exist);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @ApiOperation(value="Create ontology")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public OntologyDto create(@Valid @RequestBody OntologyDto ontologyDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)ontologyDto);
        LOGGER.debug("create ontology={}", (Object)ontologyDto);
        return (OntologyDto)this.service.create(this.buildUiHttpContext(), (IdDto)ontologyDto);
    }

    @ApiOperation(value="get history by ontology's id")
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for ontology with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        return this.service.findHistoryById(this.buildUiHttpContext(), id);
    }

    @ApiOperation(value="Patch entity")
    @PatchMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public OntologyDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(partialDto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch Ontology {} with {}", (Object)id, partialDto);
        ParameterChecker.checkParameter((String)"The Identifier, the OntologyEntity are mandatory parameters: ", (Object[])new Object[]{id, partialDto});
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch ontology: the DTO id must match the path id.");
        return (OntologyDto)this.service.patch(this.buildUiHttpContext(), partialDto, id);
    }

    @ApiOperation(value="delete ontology")
    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("delete ontology with id :{}", (Object)id);
        this.service.delete(this.buildUiHttpContext(), id);
    }

    @ApiOperation(value="import an ontology file")
    @PostMapping(value={"/import"})
    public JsonNode importOntologies(@Context HttpServletRequest request, MultipartFile file) throws InvalidParseOperationException, PreconditionFailedException {
        if (file != null) {
            SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        }
        LOGGER.debug("Import ontology file {}", (Object)(file != null ? file.getOriginalFilename() : null));
        return this.service.importOntologies(this.buildUiHttpContext(), file);
    }
}

