/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.AbstractUiRestController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.service.ContextService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"context"})
@RestController
@RequestMapping(value={"${ui-referential.prefix}/context"})
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ContextController
extends AbstractUiRestController {
    protected final ContextService service;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ContextController.class);

    @Autowired
    public ContextController(ContextService service) {
        this.service = service;
    }

    @ApiOperation(value="Get entity")
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<ContextDto> getAll(Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("Get all with criteria={}", criteria);
        return this.service.getAll(this.buildUiHttpContext(), criteria);
    }

    @ApiOperation(value="Get entities paginated")
    @GetMapping(params={"page", "size"})
    @ResponseStatus(value=HttpStatus.OK)
    public PaginatedValuesDto<ContextDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam Optional<String> criteria, @RequestParam Optional<String> orderBy, @RequestParam Optional<DirectionDto> direction) throws PreconditionFailedException, InvalidParseOperationException {
        SanityChecker.sanitizeCriteria(criteria);
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.service.getAllPaginated(page, size, criteria, orderBy, direction, this.buildUiHttpContext());
    }

    @ApiOperation(value="Get context by ID")
    @GetMapping(path={"/{identifier:.+}"})
    @ResponseStatus(value=HttpStatus.OK)
    public ContextDto getById(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{identifier});
        LOGGER.debug("getById {} / {}", (Object)identifier, (Object)URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
        return (ContextDto)this.service.getOne(this.buildUiHttpContext(), URLEncoder.encode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @ApiOperation(value="Check ability to create context")
    @PostMapping(path={"/check"})
    public ResponseEntity<Void> check(@RequestBody ContextDto contextDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)contextDto);
        LOGGER.debug("check ability to create context={}", (Object)contextDto);
        boolean exist = this.service.check(this.buildUiHttpContext(), contextDto);
        LOGGER.debug("response value={}" + exist);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @ApiOperation(value="Create context")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public ContextDto create(@Valid @RequestBody ContextDto contextDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)contextDto);
        LOGGER.debug("create context={}", (Object)contextDto);
        return (ContextDto)this.service.create(this.buildUiHttpContext(), (IdDto)contextDto);
    }

    @ApiOperation(value="Patch entity")
    @PatchMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public ContextDto patch(@PathVariable(value="id") String id, @RequestBody ContextDto partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)partialDto.getId()), (String)"Unable to patch context : the DTO id must match the path id.");
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Patch User {} with {}", (Object)id, (Object)partialDto);
        return (ContextDto)this.service.patchWithDto(this.buildUiHttpContext(), (IdDto)partialDto, id);
    }

    @ApiOperation(value="get history by context's id")
    @GetMapping(value={"/{id}/history"})
    public LogbookOperationsResponseDto findHistoryById(@PathVariable String id) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for context with id :{}", (Object)id);
        return this.service.findHistoryById(this.buildUiHttpContext(), id);
    }
}

