/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.server.service;

import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.internal.client.CollectTransactionInternalRestClient;
import fr.gouv.vitamui.collect.internal.client.UpdateUnitsMetadataInternalRestClient;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.security.client.AbstractResourceClientService;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.io.InputStream;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransactionExternalService
extends AbstractResourceClientService<CollectTransactionDto, CollectTransactionDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TransactionExternalService.class);
    private final CollectTransactionInternalRestClient collectTransactionInternalRestClient;
    private final UpdateUnitsMetadataInternalRestClient updateUnitsMetadataInternalRestClient;

    @Autowired
    public TransactionExternalService(ExternalSecurityService externalSecurityService, CollectTransactionInternalRestClient collectTransactionInternalRestClient, UpdateUnitsMetadataInternalRestClient updateUnitsMetadataInternalRestClient) {
        super(externalSecurityService);
        this.collectTransactionInternalRestClient = collectTransactionInternalRestClient;
        this.updateUnitsMetadataInternalRestClient = updateUnitsMetadataInternalRestClient;
    }

    public void sendTransaction(String projectId) {
        this.collectTransactionInternalRestClient.sendTransaction(this.getInternalHttpContext(), projectId);
    }

    public void validateTransaction(String projectId) {
        this.collectTransactionInternalRestClient.validateTransaction(this.getInternalHttpContext(), projectId);
    }

    public void reopenTransaction(String projectId) {
        this.collectTransactionInternalRestClient.reopenTransaction(this.getInternalHttpContext(), projectId);
    }

    public void abortTransaction(String projectId) {
        this.collectTransactionInternalRestClient.abortTransaction(this.getInternalHttpContext(), projectId);
    }

    protected CollectTransactionInternalRestClient getClient() {
        return this.collectTransactionInternalRestClient;
    }

    public CollectTransactionDto getTransactionById(String transactionId) {
        return this.collectTransactionInternalRestClient.getTransactionById(this.getInternalHttpContext(), transactionId);
    }

    public CollectTransactionDto updateTransaction(CollectTransactionDto collectTransactionDto) {
        return this.collectTransactionInternalRestClient.updateTransaction(this.getInternalHttpContext(), collectTransactionDto);
    }

    public String updateArchiveUnitsFromFile(String transactionId, InputStream inputStream, String fileName) {
        LOGGER.debug(" [External] start updating archive units from csv file for transactionId {}", (Object)transactionId);
        return this.updateUnitsMetadataInternalRestClient.updateArchiveUnitsMetadataFromFile(this.getInternalHttpContext(), fileName, transactionId, inputStream);
    }

    @Generated
    public CollectTransactionInternalRestClient getCollectTransactionInternalRestClient() {
        return this.collectTransactionInternalRestClient;
    }

    @Generated
    public UpdateUnitsMetadataInternalRestClient getUpdateUnitsMetadataInternalRestClient() {
        return this.updateUnitsMetadataInternalRestClient;
    }
}

