/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.server.service;

import fr.gouv.vitamui.collect.common.dto.OperationIdDto;
import fr.gouv.vitamui.collect.common.dto.UpdateArchiveUnitDto;
import fr.gouv.vitamui.collect.common.rest.ArchiveUnitClient;
import fr.gouv.vitamui.collect.common.service.ArchiveUnitService;
import fr.gouv.vitamui.commons.api.dtos.JsonPatchDto;
import fr.gouv.vitamui.commons.api.dtos.MultiJsonPatchDto;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.security.service.ExternalSecurityService;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArchiveUnitServiceImpl
implements ArchiveUnitService {
    private final ExternalSecurityService externalSecurityService;
    private final ArchiveUnitClient client;

    @Autowired
    public ArchiveUnitServiceImpl(ExternalSecurityService externalSecurityService, ArchiveUnitClient client) {
        this.externalSecurityService = externalSecurityService;
        this.client = client;
    }

    public OperationIdDto update(String transactionId, Set<UpdateArchiveUnitDto> updateArchiveUnitDtoSet) {
        return this.client.update(this.getContext(), transactionId, updateArchiveUnitDtoSet);
    }

    public OperationIdDto update(String transactionId, JsonPatchDto jsonPatchDto) {
        return this.client.update(this.getContext(), transactionId, jsonPatchDto);
    }

    public OperationIdDto update(String transactionId, MultiJsonPatchDto multiJsonPatchDto) {
        return this.client.update(this.getContext(), transactionId, multiJsonPatchDto);
    }

    private InternalHttpContext toInternalHttpContext(ExternalHttpContext externalHttpContext) {
        AuthUserDto user = this.externalSecurityService.getUser();
        String userLevel = user.getLevel();
        if (userLevel == null) {
            throw new ApplicationServerException("Level is null for user " + user.getEmail());
        }
        String customerId = user.getCustomerId();
        return InternalHttpContext.buildFromExternalHttpContext((ExternalHttpContext)externalHttpContext, (String)customerId, (String)userLevel);
    }

    private AbstractHttpContext getContext() {
        return this.toInternalHttpContext(this.externalSecurityService.getHttpContext());
    }
}

