/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.external.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.external.server.service.ProjectExternalService;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Collect"})
@RequestMapping(value={"/collect-api/v1/projects"})
@RestController
@ResponseBody
public class ProjectExternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProjectExternalController.class);
    private final ProjectExternalService projectExternalService;
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";

    @Autowired
    public ProjectExternalController(ProjectExternalService projectExternalService) {
        this.projectExternalService = projectExternalService;
    }

    @Secured(value={"ROLE_GET_PROJECTS"})
    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<CollectProjectDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws PreconditionFailedException {
        direction.ifPresent(directionDto -> SanityChecker.sanitizeCriteria((Object)directionDto));
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.projectExternalService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @ApiOperation(value="Get transactions by project paginated")
    @GetMapping(params={"page", "size"}, value={"/{id}/transactions"})
    public PaginatedValuesDto<CollectTransactionDto> getTransactionsByProjectPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @PathVariable(value="id") String projectId) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{projectId});
        SanityChecker.checkSecureParameter((String[])new String[]{projectId});
        SanityChecker.sanitizeCriteria(direction);
        SanityChecker.sanitizeCriteria(criteria);
        if (orderBy.isPresent()) {
            SanityChecker.checkSecureParameter((String[])new String[]{orderBy.get()});
        }
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.projectExternalService.getTransactionsByProjectPaginated(page, size, criteria, orderBy, direction, projectId);
    }

    @Secured(value={"ROLE_CREATE_PROJECTS"})
    @PostMapping
    public CollectProjectDto createProject(@RequestBody CollectProjectDto collectProjectDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)collectProjectDto);
        LOGGER.debug("Project to create : {}", (Object)collectProjectDto);
        return this.projectExternalService.createProject(collectProjectDto);
    }

    @Secured(value={"ROLE_CREATE_TRANSACTIONS"})
    @PostMapping(value={"/{id}/transactions"})
    public CollectTransactionDto createTransactionForProject(@PathVariable(value="id") String id, @RequestBody CollectTransactionDto collectTransactionDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)collectTransactionDto);
        LOGGER.debug("Transaction to create : {}", (Object)collectTransactionDto);
        return this.projectExternalService.createTransactionForProject(collectTransactionDto, id);
    }

    @Secured(value={"ROLE_CREATE_PROJECTS"})
    @ApiOperation(value="Upload and stream collect zip file", consumes="application/octet-stream")
    @PostMapping(value={"/upload"}, consumes={"application/octet-stream"})
    public ResponseEntity<Void> streamingUpload(InputStream inputStream, @RequestHeader(value="X-Transaction-Id") String transactionId, @RequestHeader(value="X-Original-Filename") String originalFileName, @RequestHeader Map<String, String> headers) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The transaction ID is a mandatory parameter: ", (String[])new String[]{transactionId});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        SanityChecker.isValidFileName((String)originalFileName);
        SafeFileChecker.checkSafeFilePath((String)originalFileName);
        LOGGER.debug("[External] upload collect zip file : {}", (Object)originalFileName);
        return this.projectExternalService.streamingUpload(inputStream, transactionId, originalFileName);
    }

    @Secured(value={"ROLE_UPDATE_PROJECTS"})
    @PutMapping(value={"/{id}"})
    public CollectProjectDto updateProject(@PathVariable(value="id") String id, @RequestBody CollectProjectDto collectProjectDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)collectProjectDto);
        LOGGER.debug("[External] Project to update : {}", (Object)collectProjectDto);
        return this.projectExternalService.updateProject(collectProjectDto);
    }

    @Secured(value={"ROLE_GET_PROJECTS"})
    @GetMapping(value={"/{id}"})
    public CollectProjectDto findProjectById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("The project id {} ", (Object)id);
        return this.projectExternalService.findProjectById(id);
    }

    @Secured(value={"ROLE_GET_PROJECTS"})
    @DeleteMapping(value={"/{id}"})
    public void deleteProjectById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("The project id {} ", (Object)id);
        this.projectExternalService.deleteProjectById(id);
    }

    @Secured(value={"ROLE_GET_TRANSACTIONS"})
    @GetMapping(value={"/{id}/last-transaction"})
    public CollectTransactionDto findLastTransactionByProjectId(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find the transaction by project with ID {}", (Object)id);
        return this.projectExternalService.getLastTransactionForProjectId(id);
    }
}

