/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.client;

import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import java.io.InputStream;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class UpdateUnitsMetadataInternalRestClient
extends BasePaginatingAndSortingRestClient<CollectTransactionDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UpdateUnitsMetadataInternalRestClient.class);

    public UpdateUnitsMetadataInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected Class<CollectTransactionDto> getDtoClass() {
        return CollectTransactionDto.class;
    }

    protected ParameterizedTypeReference<List<CollectTransactionDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<CollectTransactionDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CollectTransactionDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CollectTransactionDto>>(){};
    }

    public String getPathUrl() {
        return "/collect-api/v1/transactions";
    }

    public String updateArchiveUnitsMetadataFromFile(InternalHttpContext context, String originalFileName, String transactionId, InputStream inputStream) {
        LOGGER.debug("[Internal] Calling upload metadata csv file using streaming process");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/{transactionId}/update-units-metadata"));
        HttpHeaders headersList = new HttpHeaders();
        headersList.addAll(this.buildHeaders((AbstractHttpContext)context));
        headersList.add((Object)"X-Original-Filename", (Object)originalFileName);
        HttpHeaders headersParams = new HttpHeaders();
        headersParams.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headersParams.addAll((MultiValueMap)headersList);
        HttpEntity request = new HttpEntity((Object)new InputStreamResource(inputStream), (MultiValueMap)headersParams);
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.build(new Object[]{transactionId}), HttpMethod.PUT, request, String.class);
        LOGGER.debug("[Internal] The units metadata update response is : {} ", (Object)response.toString());
        return (String)response.getBody();
    }
}

