/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.CollectProjectUploadDto;
import java.io.InputStream;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CollectStreamingInternalRestClient
extends BasePaginatingAndSortingRestClient<CollectProjectUploadDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CollectStreamingInternalRestClient.class);

    public CollectStreamingInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/collect-api/v1/projects";
    }

    protected Class<CollectProjectUploadDto> getDtoClass() {
        return CollectProjectUploadDto.class;
    }

    protected ParameterizedTypeReference<List<CollectProjectUploadDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<CollectProjectUploadDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CollectProjectUploadDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CollectProjectUploadDto>>(){};
    }

    public ResponseEntity<Void> streamingUpload(InternalHttpContext context, InputStream inputStream, String transactionId, String originalFileName) {
        LOGGER.debug("Calling upload using streaming process");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/upload"));
        HttpHeaders headersList = new HttpHeaders();
        headersList.addAll(this.buildHeaders((AbstractHttpContext)context));
        headersList.add((Object)"X-Transaction-Id", (Object)transactionId);
        headersList.add((Object)"X-Original-Filename", (Object)originalFileName);
        HttpHeaders headersParams = new HttpHeaders();
        headersParams.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headersParams.addAll((MultiValueMap)headersList);
        HttpEntity request = new HttpEntity((Object)new InputStreamResource(inputStream), (MultiValueMap)headersParams);
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.POST, request, Void.class, new Object[0]);
        LOGGER.debug("The response on collect upload is {} ", (Object)response.toString());
        return response;
    }
}

