/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.archive.internal.client;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.archives.search.common.dto.ExportDipCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.ReclassificationCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.RuleSearchCriteriaDto;
import fr.gouv.vitamui.archives.search.common.dto.TransferRequestDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.commons.vitam.api.dto.PersistentIdentifierResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ArchiveInternalRestClient
extends BasePaginatingAndSortingRestClient<ArchiveUnitsDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ArchiveInternalRestClient.class);

    protected Class<JsonNode> getJsonNodeClass() {
        return JsonNode.class;
    }

    public ArchiveInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    protected Class<ArchiveUnitsDto> getDtoClass() {
        return ArchiveUnitsDto.class;
    }

    protected ParameterizedTypeReference<List<ArchiveUnitsDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<ArchiveUnitsDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<ArchiveUnitsDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<ArchiveUnitsDto>>(){};
    }

    public String getPathUrl() {
        return "/archives-search";
    }

    public ArchiveUnitsDto searchArchiveUnitsByCriteria(InternalHttpContext context, SearchCriteriaDto query) {
        LOGGER.debug("Calling searchArchiveUnitsByCriteria with query {} ", (Object)query);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/search", HttpMethod.POST, request, ArchiveUnitsDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (ArchiveUnitsDto)response.getBody();
    }

    public VitamUISearchResponseDto getFilingHoldingScheme(InternalHttpContext context) {
        LOGGER.debug("Calling get filing holding scheme");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/filling-holding-schema", HttpMethod.GET, request, VitamUISearchResponseDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (VitamUISearchResponseDto)response.getBody();
    }

    public ResponseEntity<ResultsDto> findUnitById(String id, InternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/archiveunit/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, ResultsDto.class);
    }

    public ResponseEntity<ResultsDto> findObjectById(String id, InternalHttpContext context) {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/object/{id}"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return this.restTemplate.exchange(uriBuilder.build(new Object[]{id}), HttpMethod.GET, request, ResultsDto.class);
    }

    public Resource exportCsvArchiveUnitsByCriteria(SearchCriteriaDto query, InternalHttpContext context) {
        LOGGER.debug("Calling exportCsvArchiveUnitsByCriteria with query {} ", (Object)query);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/export-csv-search", HttpMethod.POST, request, Resource.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (Resource)response.getBody();
    }

    public String exportDIPByCriteria(ExportDipCriteriaDto exportDipCriteriaDto, InternalHttpContext context) {
        LOGGER.debug("Calling exportDIPByCriteria with query {} ", (Object)exportDipCriteriaDto);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)exportDipCriteriaDto, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/export-dip", HttpMethod.POST, request, String.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (String)response.getBody();
    }

    public String transferRequest(TransferRequestDto transferRequestDto, InternalHttpContext context) {
        LOGGER.debug("Calling transfer request with query {} ", (Object)transferRequestDto);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)transferRequestDto, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/transfer-request", HttpMethod.POST, request, String.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (String)response.getBody();
    }

    public ResponseEntity<JsonNode> startEliminationAnalysis(InternalHttpContext context, SearchCriteriaDto query) {
        LOGGER.debug("Calling elimination analysis with query {} ", (Object)query);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/elimination/analysis", HttpMethod.POST, request, JsonNode.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return response;
    }

    public ResponseEntity<JsonNode> startEliminationAction(InternalHttpContext context, SearchCriteriaDto query) {
        LOGGER.debug("Calling elimination action with query {} ", (Object)query);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/elimination/action", HttpMethod.POST, request, JsonNode.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return response;
    }

    public String updateArchiveUnitsRules(RuleSearchCriteriaDto ruleSearchCriteriaDto, InternalHttpContext context) {
        LOGGER.debug("Calling Update Archive Units Rules  with query {} ", (Object)ruleSearchCriteriaDto);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)ruleSearchCriteriaDto, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/units/rules", HttpMethod.POST, request, String.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (String)response.getBody();
    }

    public String computedInheritedRules(SearchCriteriaDto searchCriteriaDto, InternalHttpContext context) {
        LOGGER.debug("Calling computedInheritedRules with query {} ", (Object)searchCriteriaDto);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)searchCriteriaDto, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/computed-inherited-rules", HttpMethod.POST, request, String.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (String)response.getBody();
    }

    public ResultsDto selectUnitWithInheritedRules(InternalHttpContext context, SearchCriteriaDto query) {
        LOGGER.debug("Calling select Unit With Inherited Rules with query {} ", (Object)query);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)query, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/unit-with-inherited-rules", HttpMethod.POST, request, ResultsDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (ResultsDto)response.getBody();
    }

    public String reclassification(ReclassificationCriteriaDto reclassificationCriteriaDto, InternalHttpContext context) {
        LOGGER.debug("Calling reclassification with query {} ", (Object)reclassificationCriteriaDto);
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        HttpEntity request = new HttpEntity((Object)reclassificationCriteriaDto, headers);
        ResponseEntity response = this.restTemplate.exchange(this.getUrl() + "/reclassification", HttpMethod.POST, request, String.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (String)response.getBody();
    }

    public List<VitamUiOntologyDto> getExternalOntologiesList(InternalHttpContext context) {
        LOGGER.debug("[INTERNAL] : Calling Get External ontologies list");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/external-ontologies"));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        return (List)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, request, ArrayList.class).getBody();
    }

    public PersistentIdentifierResponseDto findUnitsByPersistentIdentifier(String identifier, InternalHttpContext context) {
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/units-by-persistent-identifier")).queryParam("id", new Object[]{identifier});
        return (PersistentIdentifierResponseDto)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, request, PersistentIdentifierResponseDto.class).getBody();
    }

    public PersistentIdentifierResponseDto findObjectsByPersistentIdentifier(String identifier, InternalHttpContext context) {
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/objects-by-persistent-identifier")).queryParam("id", new Object[]{identifier});
        return (PersistentIdentifierResponseDto)this.restTemplate.exchange(uriBuilder.build().toUri(), HttpMethod.GET, request, PersistentIdentifierResponseDto.class).getBody();
    }
}

