/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.service.converters;

import fr.gouv.vitam.collect.common.dto.MetadataUnitUp;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitamui.collect.common.dto.CollectMetadataUnitUpDto;
import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public final class ProjectConverter {
    public static List<CollectProjectDto> toVitamuiCollectProjectDtos(List<ProjectDto> projectDtos) {
        return projectDtos.stream().map(ProjectConverter::toVitamuiCollectProjectDto).collect(Collectors.toList());
    }

    public static CollectProjectDto toVitamuiCollectProjectDto(ProjectDto projectDto) {
        return CollectProjectDto.builder().tenant(Optional.of(projectDto.getTenant()).orElseThrow()).archivalAgencyIdentifier(projectDto.getArchivalAgencyIdentifier()).archivalAgreement(projectDto.getArchivalAgreement()).archiveProfile(projectDto.getArchivalProfile()).comment(projectDto.getComment()).id(projectDto.getId()).messageIdentifier(projectDto.getMessageIdentifier()).unitUp(projectDto.getUnitUp()).unitUps(ProjectConverter.toVitamuiCollectMetadataUnitUpDtos(projectDto.getUnitUps())).originatingAgencyIdentifier(projectDto.getOriginatingAgencyIdentifier()).submissionAgencyIdentifier(projectDto.getSubmissionAgencyIdentifier()).transferringAgencyIdentifier(projectDto.getTransferringAgencyIdentifier()).legalStatus(projectDto.getLegalStatus()).acquisitionInformation(projectDto.getAcquisitionInformation()).createdOn(projectDto.getCreationDate()).lastModifyOn(projectDto.getLastUpdate()).status(projectDto.getStatus()).name(projectDto.getName()).automaticIngest(projectDto.getAutomaticIngest()).build();
    }

    public static List<CollectMetadataUnitUpDto> toVitamuiCollectMetadataUnitUpDtos(List<MetadataUnitUp> metadataUnitUps) {
        if (Objects.isNull(metadataUnitUps)) {
            return null;
        }
        return metadataUnitUps.stream().map(ProjectConverter::toVitamuiCollectMetadataUnitUpDto).collect(Collectors.toList());
    }

    public static CollectMetadataUnitUpDto toVitamuiCollectMetadataUnitUpDto(MetadataUnitUp metadataUnitUp) {
        return CollectMetadataUnitUpDto.builder().metadataKey(metadataUnitUp.getMetadataKey()).metadataValue(metadataUnitUp.getMetadataValue()).unitUp(metadataUnitUp.getUnitUp()).build();
    }

    public static ProjectDto toVitamProjectDto(CollectProjectDto collectProjectDto) {
        ProjectDto externalDto = new ProjectDto();
        externalDto.setArchivalAgencyIdentifier(collectProjectDto.getArchivalAgencyIdentifier());
        externalDto.setArchivalAgreement(collectProjectDto.getArchivalAgreement());
        externalDto.setComment(collectProjectDto.getComment());
        externalDto.setArchivalProfile(collectProjectDto.getArchiveProfile());
        externalDto.setId(collectProjectDto.getId());
        externalDto.setMessageIdentifier(collectProjectDto.getMessageIdentifier());
        externalDto.setOriginatingAgencyIdentifier(collectProjectDto.getOriginatingAgencyIdentifier());
        externalDto.setSubmissionAgencyIdentifier(collectProjectDto.getSubmissionAgencyIdentifier());
        externalDto.setTransferringAgencyIdentifier(collectProjectDto.getTransferringAgencyIdentifier());
        externalDto.setUnitUp(collectProjectDto.getUnitUp());
        externalDto.setUnitUps(ProjectConverter.toVitamMetadataUnitUps(collectProjectDto.getUnitUps()));
        externalDto.setAcquisitionInformation(collectProjectDto.getAcquisitionInformation());
        externalDto.setLegalStatus(collectProjectDto.getLegalStatus());
        externalDto.setStatus(collectProjectDto.getStatus());
        externalDto.setCreationDate(collectProjectDto.getCreatedOn());
        externalDto.setLastUpdate(collectProjectDto.getLastModifyOn());
        externalDto.setName(collectProjectDto.getName());
        externalDto.setAutomaticIngest(collectProjectDto.getAutomaticIngest());
        return externalDto;
    }

    public static List<MetadataUnitUp> toVitamMetadataUnitUps(List<CollectMetadataUnitUpDto> collectMetadataUnitUpDtos) {
        if (Objects.isNull(collectMetadataUnitUpDtos)) {
            return null;
        }
        return collectMetadataUnitUpDtos.stream().map(ProjectConverter::toVitamMetadataUnitUp).collect(Collectors.toList());
    }

    public static MetadataUnitUp toVitamMetadataUnitUp(CollectMetadataUnitUpDto collectMetadataUnitUpDto) {
        MetadataUnitUp metadataUnitUp = new MetadataUnitUp();
        metadataUnitUp.setMetadataKey(collectMetadataUnitUpDto.getMetadataKey());
        metadataUnitUp.setMetadataValue(collectMetadataUnitUpDto.getMetadataValue());
        metadataUnitUp.setUnitUp(collectMetadataUnitUpDto.getUnitUp());
        return metadataUnitUp;
    }

    @Generated
    private ProjectConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

