/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.collect.CollectService;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public class ProjectObjectGroupInternalService {
    private final CollectService collectService;
    private final ObjectMapper objectMapper;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProjectObjectGroupInternalService.class);
    private static final String RESULTS = "$results";

    public ProjectObjectGroupInternalService(CollectService collectService, ObjectMapper objectMapper) {
        this.collectService = collectService;
        this.objectMapper = objectMapper;
    }

    public Response downloadObjectFromUnit(String id, String usage, Integer version, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Download Archive Unit Object with id {} , usage {} and version {}  ", new Object[]{id, usage, version});
        return this.collectService.getObjectStreamByUnitId(id, usage, version.intValue(), vitamContext);
    }

    public ResultsDto findObjectById(String id, VitamContext vitamContext) throws VitamClientException {
        try {
            LOGGER.debug("Get Object Group");
            String resultStringValue = StringUtils.chop((String)this.collectService.getObjectById(vitamContext, id).toJsonNode().get(RESULTS).toString().substring(1));
            return (ResultsDto)this.objectMapper.readValue(resultStringValue, ResultsDto.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Can not get the object group {} ", (Throwable)e);
            throw new InternalServerException("Unable to find the ObjectGroup", (Throwable)e);
        }
    }
}

