/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.collect.common.dto.CriteriaProjectDto;
import fr.gouv.vitam.collect.common.dto.ProjectDto;
import fr.gouv.vitam.collect.common.dto.TransactionDto;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.internal.server.service.converters.ProjectConverter;
import fr.gouv.vitamui.collect.internal.server.service.converters.TransactionConverter;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.collect.CollectService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;

public class ProjectInternalService {
    public static final int MAX_RESULTS = 10000;
    public static final String UNABLE_TO_CREATE_PROJECT = "Unable to create project";
    public static final String UNABLE_TO_CREATE_TRANSACTION = "Unable to create transaction";
    public static final String UNABLE_TO_PROCESS_RESPONSE = "Unable to process response";
    public static final String UNABLE_TO_UPDATE_PROJECT = "Unable to update project";
    public static final String UNABLE_TO_UPLOAD_PROJECT_ZIP_FILE = "Unable to upload project zip file";
    public static final String UNABLE_TO_RETRIEVE_PROJECT = "Unable to retrieve project";
    private final CollectService collectService;
    private final ObjectMapper objectMapper;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProjectInternalService.class);

    public ProjectInternalService(CollectService collectService, ObjectMapper objectMapper) {
        this.collectService = collectService;
        this.objectMapper = objectMapper;
    }

    public CollectProjectDto createProject(CollectProjectDto collectProjectDto, VitamContext vitamContext) {
        LOGGER.debug("CollectProjectDto: {}", (Object)collectProjectDto);
        try {
            ProjectDto projectDto = ProjectConverter.toVitamProjectDto(collectProjectDto);
            RequestResponse requestResponse = this.collectService.initProject(vitamContext, projectDto);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when retrieving projects!");
            }
            return ProjectConverter.toVitamuiCollectProjectDto((ProjectDto)JsonHandler.getFromString((String)((RequestResponseOK)requestResponse).getFirstResult().toString(), ProjectDto.class));
        }
        catch (VitamClientException e) {
            LOGGER.debug("Unable to create project: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_CREATE_PROJECT, (Throwable)e);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.debug("Unable to process response: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_PROCESS_RESPONSE, (Throwable)e);
        }
    }

    public CollectTransactionDto createTransactionForProject(CollectTransactionDto collectTransactionDto, String projectId, VitamContext vitamContext) {
        LOGGER.debug("CollectTransactionDto: ", (Object)collectTransactionDto);
        try {
            SanityChecker.checkSecureParameter((String[])new String[]{projectId});
            TransactionDto transactionDto = TransactionConverter.toVitamDto(collectTransactionDto);
            RequestResponse requestResponse = this.collectService.initTransaction(vitamContext, transactionDto, projectId);
            if (!requestResponse.isOk()) {
                LOGGER.error("Error occurs when creating transaction");
                throw new VitamClientException("Error occurs when creating transaction");
            }
            return TransactionConverter.toVitamUiDto((TransactionDto)JsonHandler.getFromString((String)((RequestResponseOK)requestResponse).getFirstResult().toString(), TransactionDto.class));
        }
        catch (VitamClientException e) {
            LOGGER.debug("Unable to create transaction: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_CREATE_TRANSACTION, (Throwable)e);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.debug("Unable to process response: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_PROCESS_RESPONSE, (Throwable)e);
        }
    }

    public PaginatedValuesDto<CollectProjectDto> getAllProjectsPaginated(Integer page, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, Optional<String> criteria, VitamContext vitamContext) {
        LOGGER.debug("Page: ", (Object)page);
        LOGGER.debug("Size: ", (Object)size);
        LOGGER.debug("OrderBy: ", orderBy.orElse(null));
        LOGGER.debug("Direction: ", direction.orElse(null));
        LOGGER.debug("Criteria: ", criteria.orElse(null));
        try {
            RequestResponse requestResponse;
            if (criteria.isPresent()) {
                HashMap vitamCriteria = (HashMap)this.objectMapper.readValue(criteria.get(), (TypeReference)new TypeReference<HashMap<String, String>>(){});
                CriteriaProjectDto criteriaProjectDto = new CriteriaProjectDto();
                criteriaProjectDto.setQuery((String)vitamCriteria.get("query"));
                requestResponse = this.collectService.searchProject(vitamContext, criteriaProjectDto);
            } else {
                requestResponse = this.collectService.getProjects(vitamContext);
            }
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when retrieving projects!");
            }
            List results = ((RequestResponseOK)requestResponse).getResults();
            ArrayList<ProjectDto> projectDtos = new ArrayList<ProjectDto>();
            for (JsonNode result : results) {
                projectDtos.add((ProjectDto)this.objectMapper.treeToValue((TreeNode)result, ProjectDto.class));
            }
            List<CollectProjectDto> collectProjectDtos = ProjectConverter.toVitamuiCollectProjectDtos(projectDtos);
            return new PaginatedValuesDto(collectProjectDtos, 1, 10000, false);
        }
        catch (VitamClientException e) {
            LOGGER.debug("Unable to retrieve project: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_RETRIEVE_PROJECT, (Throwable)e);
        }
        catch (JsonProcessingException e) {
            LOGGER.debug("Unable to process response: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_PROCESS_RESPONSE, (Throwable)e);
        }
    }

    public void streamingUpload(InputStream inputStream, String transactionId, String originalFileName, VitamContext vitamContext) {
        LOGGER.debug("TransactionId: ", (Object)transactionId);
        LOGGER.debug("OriginalFileName: ", (Object)originalFileName);
        try {
            this.collectService.uploadProjectZip(vitamContext, transactionId, inputStream);
        }
        catch (VitamClientException e) {
            LOGGER.debug("Unable to upload project zip file: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_UPLOAD_PROJECT_ZIP_FILE, (Throwable)e);
        }
    }

    public CollectProjectDto update(String id, CollectProjectDto collectProjectDto, VitamContext vitamContext) {
        LOGGER.debug("Id: ", (Object)id);
        LOGGER.debug("CollectProjectDto: ", (Object)collectProjectDto);
        try {
            ProjectDto projectDto = ProjectConverter.toVitamProjectDto(collectProjectDto);
            RequestResponse requestResponse = this.collectService.updateProject(vitamContext, projectDto);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when updating project!");
            }
            ProjectDto responseProjectDto = (ProjectDto)JsonHandler.getFromString((String)((RequestResponseOK)requestResponse).getFirstResult().toString(), ProjectDto.class);
            return ProjectConverter.toVitamuiCollectProjectDto(responseProjectDto);
        }
        catch (VitamClientException e) {
            LOGGER.debug("Unable to update project: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_UPDATE_PROJECT, (Throwable)e);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.debug("Unable to process response: {}", (Throwable)e);
            throw new InternalServerException(UNABLE_TO_PROCESS_RESPONSE, (Throwable)e);
        }
    }

    public CollectProjectDto getProjectById(String id, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.getProjectById(vitamContext, id);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when getting project!");
            }
            return ProjectConverter.toVitamuiCollectProjectDto((ProjectDto)JsonHandler.getFromString((String)((RequestResponseOK)requestResponse).getFirstResult().toString(), ProjectDto.class));
        }
        catch (InvalidParseOperationException | VitamClientException e) {
            throw new VitamClientException("Unable to find project : ", e);
        }
    }

    public void deleteProjectById(String id, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.deleteProjectById(vitamContext, id);
            if (requestResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new VitamClientException("Error occurs when deleteing project!");
            }
        }
        catch (VitamClientException e) {
            throw new VitamClientException("Unable to delete project : ", (Throwable)e);
        }
    }

    public PaginatedValuesDto<CollectTransactionDto> getTransactionsByProjectPaginated(String projectId, Integer page, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext) throws VitamClientException {
        LOGGER.debug("Page: ", (Object)page);
        LOGGER.debug("Size: ", (Object)size);
        LOGGER.debug("OrderBy: ", orderBy.orElse(null));
        LOGGER.debug("Direction: ", direction.orElse(null));
        try {
            RequestResponse requestResponse = this.collectService.getTransactionsByProject(projectId, vitamContext);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when getting transaction!");
            }
            List results = ((RequestResponseOK)requestResponse).getResults();
            ArrayList<TransactionDto> transactionDtos = new ArrayList<TransactionDto>();
            for (JsonNode result : results) {
                TransactionDto transactionDto = (TransactionDto)JsonHandler.getFromString((String)result.toString(), TransactionDto.class);
                transactionDtos.add(transactionDto);
            }
            List<CollectTransactionDto> collectTransactionDtos = TransactionConverter.toVitamuiDtos(transactionDtos);
            return new PaginatedValuesDto(collectTransactionDtos, 1, 10000, false);
        }
        catch (InvalidParseOperationException | VitamClientException e) {
            throw new VitamClientException("Unable to find transaction : ", e);
        }
    }

    public CollectTransactionDto getLastTransactionForProjectId(String projectId, VitamContext vitamContext) throws VitamClientException {
        try {
            RequestResponse requestResponse = this.collectService.getLastTransactionForProjectId(vitamContext, projectId);
            if (!requestResponse.isOk()) {
                throw new VitamClientException("Error occurs when getting last transaction by project!");
            }
            List transactionDtos = (List)this.objectMapper.readValue(((RequestResponseOK)requestResponse).getResults().toString(), (TypeReference)new TypeReference<List<TransactionDto>>(){});
            List<CollectTransactionDto> collectTransactionDtos = TransactionConverter.toVitamuiDtos(transactionDtos);
            if (collectTransactionDtos.isEmpty()) {
                return null;
            }
            return collectTransactionDtos.get(collectTransactionDtos.size() - 1);
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new VitamClientException("Unable to find transactions by project : ", e);
        }
    }
}

