/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.internal.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.internal.server.service.TransactionInternalService;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.exception.RequestTimeOutException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import io.swagger.annotations.Api;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/collect-api/v1/transactions"})
@Api(tags={"collect"}, value="Pr\u00e9paration de versements")
public class TransactionInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TransactionInternalController.class);
    private final TransactionInternalService transactionInternalService;
    private final ExternalParametersService externalParametersService;
    private static final String IDENTIFIER_MANDATORY_MESSAGE = "The Identifier is a mandatory parameter: ";

    @Autowired
    public TransactionInternalController(TransactionInternalService transactionInternalService, ExternalParametersService externalParametersService) {
        this.transactionInternalService = transactionInternalService;
        this.externalParametersService = externalParametersService;
    }

    @PutMapping(value={"/{id}/send"})
    public void sendTransaction(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Transaction to send  {}", (Object)id);
        this.transactionInternalService.sendTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PutMapping(value={"/{id}/validate"})
    public void validateTransaction(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Transaction to close  {}", (Object)id);
        this.transactionInternalService.validateTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PutMapping(value={"/{id}/reopen"})
    public void reopenTransaction(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Transaction to reopen  {}", (Object)id);
        this.transactionInternalService.reopenTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PutMapping(value={"/{id}/abort"})
    public void abortTransaction(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Transaction to abort  {}", (Object)id);
        this.transactionInternalService.abortTransaction(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/{id}"})
    public CollectTransactionDto getTransactionById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Project Id  {}", (Object)id);
        return this.transactionInternalService.getTransactionById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PutMapping(value={"/{transactionId}/update-units-metadata"}, consumes={"application/octet-stream"})
    public String updateArchiveUnitsMetadataFromFile(@PathVariable(value="transactionId") String transactionId, InputStream inputStream, @RequestHeader(value="X-Original-Filename") String originalFileName) throws InvalidParseOperationException, PreconditionFailedException, RequestTimeOutException {
        ParameterChecker.checkParameter((String)"The transaction Id is a mandatory parameter: ", (String[])new String[]{transactionId});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        LOGGER.debug("[Internal] update archiveUnits metadata from file for transaction  {}", (Object)transactionId);
        SanityChecker.isValidFileName((String)originalFileName);
        SafeFileChecker.checkSafeFilePath((String)originalFileName);
        LOGGER.debug("[Internal] csv FileName  {}", (Object)originalFileName);
        return this.transactionInternalService.updateArchiveUnitsFromFile(inputStream, transactionId, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PutMapping
    public CollectTransactionDto updateTransaction(@RequestBody CollectTransactionDto transactionDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY_MESSAGE, (Object[])new Object[]{transactionDto});
        SanityChecker.sanitizeCriteria((Object)transactionDto);
        LOGGER.debug("[Internal] Transaction to update : {}", (Object)transactionDto);
        return this.transactionInternalService.updateTransaction(transactionDto, this.externalParametersService.buildVitamContextFromExternalParam());
    }
}

