/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.rest;

import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.archives.search.common.dto.ArchiveUnitsDto;
import fr.gouv.vitamui.collect.internal.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.internal.server.service.TransactionArchiveUnitInternalService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.dtos.SearchCriteriaDto;
import fr.gouv.vitamui.commons.api.dtos.VitamUiOntologyDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/collect-api/v1/transactions"})
@Api(tags={"collect"}, value="Unit\u00e9s archivistiques d'un projet")
public class TransactionArchiveUnitInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TransactionArchiveUnitInternalController.class);
    private final InternalSecurityService securityService;
    private final TransactionArchiveUnitInternalService transactionArchiveUnitInternalService;
    private final ExternalParametersService externalParametersService;
    private static final String MANDATORY_PARAMETERS = "The tenant Id, the SearchCriteria are mandatory parameters: ";
    private static final String IDENTIFIER_ACCESS_CONTRACT_MANDATORY = "The identifier is mandatory parameter: ";

    public TransactionArchiveUnitInternalController(InternalSecurityService securityService, TransactionArchiveUnitInternalService transactionArchiveUnitInternalService, ExternalParametersService externalParametersService) {
        this.securityService = securityService;
        this.transactionArchiveUnitInternalService = transactionArchiveUnitInternalService;
        this.externalParametersService = externalParametersService;
    }

    @PostMapping(value={"/{transactionId}/archive-units"})
    public ArchiveUnitsDto searchArchiveUnitsByCriteria(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto searchQuery) throws VitamClientException, IOException, InvalidParseOperationException, PreconditionFailedException, InvalidCreateOperationException {
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        ParameterChecker.checkParameter((String)"The tenant Id and the SearchCriteria are mandatory parameters: ", (Object[])new Object[]{tenantId, searchQuery});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        LOGGER.debug("Calling service searchArchiveUnits for tenantId {} by Criteria {} ", (Object)tenantId, (Object)searchQuery);
        return this.transactionArchiveUnitInternalService.searchArchiveUnitsByCriteria(transactionId, searchQuery, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PostMapping(value={"/{transactionId}/archive-units/export-csv-search"})
    public ResponseEntity<Resource> exportCsvArchiveUnitsByCriteria(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @PathVariable(value="transactionId") String transactionId, @RequestBody SearchCriteriaDto searchQuery) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        LOGGER.debug("Export to CSV file Archive Units by criteria {}", (Object)searchQuery);
        Resource exportedResult = this.transactionArchiveUnitInternalService.exportToCsvSearchArchiveUnitsByCriteria(transactionId, searchQuery, this.externalParametersService.buildVitamContextFromExternalParam());
        return new ResponseEntity((Object)exportedResult, HttpStatus.OK);
    }

    @GetMapping(value={"/archiveunit/{id}"})
    public ResultsDto findUnitById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The  Id is mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("UA Details  {}", (Object)id);
        return this.transactionArchiveUnitInternalService.findArchiveUnitById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/objects/{id}"})
    public ResultsDto findObjectGroupById(@PathVariable(value="id") String id) throws InvalidParseOperationException, VitamClientException {
        ParameterChecker.checkParameter((String)IDENTIFIER_ACCESS_CONTRACT_MANDATORY, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("[INTERNAL] : Get ObjectGroup By id : {}", (Object)id);
        return this.transactionArchiveUnitInternalService.findObjectGroupById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/external-ontologies"})
    public List<VitamUiOntologyDto> getExternalOntologiesList() throws IOException {
        LOGGER.debug("[INTERNAL] : Get All ontologies values for tenant {}", (Object)this.securityService.getTenantIdentifier());
        Integer tenantId = this.securityService.getTenantIdentifier();
        return this.transactionArchiveUnitInternalService.readExternalOntologiesFromFile(tenantId);
    }

    @PostMapping(value={"/{transactionId}/unit-with-inherited-rules"})
    public ResultsDto selectUnitsWithInheritedRules(@PathVariable(value="transactionId") String transactionId, @RequestHeader(value="X-Tenant-Id") Integer tenantId, @RequestBody SearchCriteriaDto searchQuery) throws VitamClientException, IOException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)searchQuery);
        ParameterChecker.checkParameter((String)MANDATORY_PARAMETERS, (Object[])new Object[]{tenantId, searchQuery});
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        LOGGER.debug("Calling service select Unit With Inherited Rules for tenantId {}, By Criteria {} ", (Object)tenantId, (Object)searchQuery);
        return this.transactionArchiveUnitInternalService.selectUnitWithInheritedRules(searchQuery, transactionId, this.externalParametersService.buildVitamContextFromExternalParam());
    }
}

