/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.rest;

import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.collect.internal.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.internal.server.service.ProjectObjectGroupInternalService;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.ResultsDto;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import io.swagger.annotations.Api;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@RestController
@RequestMapping(value={"/collect-api/v1/projects/object-groups"})
@Api(tags={"collect"}, value="Groupe d'object d'un projet")
public class ProjectObjectGroupInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProjectObjectGroupInternalController.class);
    private final ProjectObjectGroupInternalService projectObjectGroupInternalService;
    private final ExternalParametersService externalParametersService;
    private final InternalSecurityService securityService;
    private static final String IDENTIFIER_MANDATORY = "The identifier is mandatory parameter: ";

    public ProjectObjectGroupInternalController(ProjectObjectGroupInternalService projectObjectGroupInternalService, ExternalParametersService externalParametersService, InternalSecurityService securityService) {
        this.projectObjectGroupInternalService = projectObjectGroupInternalService;
        this.externalParametersService = externalParametersService;
        this.securityService = securityService;
    }

    @GetMapping(value={"/downloadobjectfromunit/{id}"}, produces={"application/octet-stream"})
    public Mono<ResponseEntity<Resource>> downloadObjectFromUnit(@PathVariable(value="id") String id, @RequestParam(value="usage") String usage, @RequestParam(value="version") Integer version) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, usage});
        LOGGER.debug("Download Archive Unit Object with id {}", (Object)id);
        VitamContext vitamContext = new VitamContext(this.securityService.getTenantIdentifier()).setAccessContract(this.externalParametersService.retrieveAccessContractFromExternalParam()).setApplicationSessionId(this.securityService.getApplicationId());
        return Mono.fromCallable(() -> {
            Response response = this.projectObjectGroupInternalService.downloadObjectFromUnit(id, usage, version, vitamContext);
            return new InputStreamResource((InputStream)response.getEntity());
        }).subscribeOn(Schedulers.boundedElastic()).flatMap(resource -> Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noCache())).body(resource)));
    }

    @GetMapping(value={"/{id}"})
    public ResultsDto findObjectById(@PathVariable(value="id") String id) throws InvalidParseOperationException, VitamClientException {
        ParameterChecker.checkParameter((String)IDENTIFIER_MANDATORY, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get ObjectGroup By id : {}", (Object)id);
        return this.projectObjectGroupInternalService.findObjectById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }
}

