/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.collect.internal.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.collect.common.dto.CollectProjectDto;
import fr.gouv.vitamui.collect.common.dto.CollectTransactionDto;
import fr.gouv.vitamui.collect.internal.server.service.ExternalParametersService;
import fr.gouv.vitamui.collect.internal.server.service.ProjectInternalService;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/collect-api/v1/projects"})
@Api(tags={"collect"}, value="Pr\u00e9paration de versements")
public class ProjectInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProjectInternalController.class);
    private final ProjectInternalService projectInternalService;
    private final ExternalParametersService externalParametersService;

    @Autowired
    public ProjectInternalController(ProjectInternalService projectInternalService, ExternalParametersService externalParametersService) {
        this.projectInternalService = projectInternalService;
        this.externalParametersService = externalParametersService;
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<CollectProjectDto> getAllProjectsPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        SanityChecker.sanitizeCriteria(criteria);
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        return this.projectInternalService.getAllProjectsPaginated(page, size, orderBy, direction, criteria, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PostMapping
    public CollectProjectDto createProject(@RequestBody CollectProjectDto collectProjectDto) throws InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"the project is mandatory : ", (Object[])new Object[]{collectProjectDto});
        SanityChecker.sanitizeCriteria((Object)collectProjectDto);
        LOGGER.debug("Project to create {}", (Object)collectProjectDto);
        return this.projectInternalService.createProject(collectProjectDto, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PostMapping(value={"/{id}/transactions"})
    public CollectTransactionDto createTransactionForProject(@PathVariable(value="id") String id, @RequestBody CollectTransactionDto collectTransactionDto) throws InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        ParameterChecker.checkParameter((String)"The transaction is a mandatory parameter: ", (Object[])new Object[]{collectTransactionDto});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)collectTransactionDto);
        LOGGER.debug("Transaction to create {}", (Object)collectTransactionDto);
        return this.projectInternalService.createTransactionForProject(collectTransactionDto, id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @ApiOperation(value="Upload and stream collect zip file", consumes="application/octet-stream")
    @PostMapping(value={"/upload"}, consumes={"application/octet-stream"})
    public void streamingUpload(InputStream inputStream, @RequestHeader(value="X-Transaction-Id") String transactionId, @RequestHeader(value="X-Original-Filename") String originalFileName) throws InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The transaction ID is a mandatory parameter: ", (String[])new String[]{transactionId});
        SanityChecker.isValidFileName((String)originalFileName);
        SafeFileChecker.checkSafeFilePath((String)originalFileName);
        SanityChecker.checkSecureParameter((String[])new String[]{transactionId});
        LOGGER.debug("[Internal] upload collect zip file : {}", (Object)originalFileName);
        this.projectInternalService.streamingUpload(inputStream, transactionId, originalFileName, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @PutMapping(value={"/{id}"})
    public CollectProjectDto updateProject(@PathVariable(value="id") String id, @RequestBody CollectProjectDto collectProjectDto) throws InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        ParameterChecker.checkParameter((String)"the project is mandatory : ", (Object[])new Object[]{collectProjectDto});
        SanityChecker.sanitizeCriteria((Object)collectProjectDto);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("[Internal] Project to update : {}", (Object)collectProjectDto);
        return this.projectInternalService.update(id, collectProjectDto, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/{id}"})
    public CollectProjectDto findProjectById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Project to get  {}", (Object)id);
        return this.projectInternalService.getProjectById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteProjectById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Project to delete  {}", (Object)id);
        this.projectInternalService.deleteProjectById(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @GetMapping(value={"/{id}/last-transaction"})
    public CollectTransactionDto findLastTransactionByProjectId(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException, VitamClientException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Find the transaction by project with ID {}", (Object)id);
        return this.projectInternalService.getLastTransactionForProjectId(id, this.externalParametersService.buildVitamContextFromExternalParam());
    }

    @ApiOperation(value="Get transactions by project paginated")
    @GetMapping(params={"page", "size"}, value={"/{id}/transactions"})
    public PaginatedValuesDto<CollectTransactionDto> getTransactionsByProjectPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @PathVariable(value="id") String projectId) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{projectId});
        SanityChecker.checkSecureParameter((String[])new String[]{projectId});
        LOGGER.debug("getPaginateEntities page={}, size={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        return this.projectInternalService.getTransactionsByProjectPaginated(projectId, page, size, orderBy, direction, this.externalParametersService.buildVitamContextFromExternalParam());
    }
}

