/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.user.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.domain.TenantInformationDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.logbook.common.EventType;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.security.client.config.password.PasswordConfiguration;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.security.client.dto.BasicCustomerDto;
import fr.gouv.vitamui.commons.security.client.dto.GraphicIdentityDto;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookEventDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.iam.common.enums.OtpEnum;
import fr.gouv.vitamui.iam.internal.server.application.service.ApplicationInternalService;
import fr.gouv.vitamui.iam.internal.server.common.domain.Address;
import fr.gouv.vitamui.iam.internal.server.common.service.AddressService;
import fr.gouv.vitamui.iam.internal.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.internal.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.internal.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupInternalService;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.profile.dao.ProfileRepository;
import fr.gouv.vitamui.iam.internal.server.profile.service.ProfileInternalService;
import fr.gouv.vitamui.iam.internal.server.tenant.dao.TenantRepository;
import fr.gouv.vitamui.iam.internal.server.tenant.domain.Tenant;
import fr.gouv.vitamui.iam.internal.server.user.converter.UserConverter;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.internal.server.user.domain.AlertAnalytics;
import fr.gouv.vitamui.iam.internal.server.user.domain.User;
import fr.gouv.vitamui.iam.internal.server.user.service.ConnectionHistoryService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserEmailInternalService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserExportService;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInfoInternalService;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;

public class UserInternalService
extends VitamUICrudService<UserDto, User> {
    public static final int MAX_OLD_PASSWORDS = 12;
    private static final List<EventType> USER_OPERATIONS_EVENT_TYPES = List.of(EventType.EXT_VITAMUI_CREATE_USER, EventType.EXT_VITAMUI_UPDATE_USER, EventType.EXT_VITAMUI_BLOCK_USER, EventType.EXT_VITAMUI_PASSWORD_REVOCATION, EventType.EXT_VITAMUI_PASSWORD_INIT, EventType.EXT_VITAMUI_PASSWORD_CHANGE, EventType.EXT_VITAMUI_CREATE_USER_INFO, EventType.EXT_VITAMUI_UPDATE_USER_INFO);
    private UserRepository userRepository;
    private GroupInternalService groupInternalService;
    private ProfileInternalService profileInternalService;
    private UserEmailInternalService userEmailInternalService;
    private TenantRepository tenantRepository;
    private InternalSecurityService internalSecurityService;
    private CustomerRepository customerRepository;
    private ProfileRepository profilRepository;
    private GroupRepository groupRepository;
    private final IamLogbookService iamLogbookService;
    private final UserConverter userConverter;
    private final String ADMIN_EMAIL_PATTERN = "admin@";
    private final String PORTAL_APP_IDENTIFIER = "PORTAL_APP";
    private MongoTransactionManager mongoTransactionManager;
    private LogbookService logbookService;
    private AddressService addressService;
    private final ApplicationInternalService applicationInternalService;
    private final PasswordConfiguration passwordConfiguration;
    private final Integer maxOldPassword;
    private final UserExportService userExportService;
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserInternalService.class);
    private UserInfoInternalService userInfoInternalService;
    private ConnectionHistoryService connectionHistoryService;

    @Autowired
    public UserInternalService(SequenceGeneratorService sequenceGeneratorService, UserRepository userRepository, GroupInternalService groupInternalService, ProfileInternalService profileInternalService, UserEmailInternalService userEmailInternalService, TenantRepository tenantRepository, InternalSecurityService internalSecurityService, CustomerRepository customerRepository, ProfileRepository profilRepository, GroupRepository groupRepository, IamLogbookService iamLogbookService, UserConverter userConverter, MongoTransactionManager mongoTransactionManager, LogbookService logbookService, AddressService addressService, ApplicationInternalService applicationInternalService, PasswordConfiguration passwordConfiguration, UserExportService userExportService, UserInfoInternalService userInfoInternalService, ConnectionHistoryService connectionHistoryService) {
        super(sequenceGeneratorService);
        this.userRepository = userRepository;
        this.groupInternalService = groupInternalService;
        this.profileInternalService = profileInternalService;
        this.userEmailInternalService = userEmailInternalService;
        this.tenantRepository = tenantRepository;
        this.internalSecurityService = internalSecurityService;
        this.customerRepository = customerRepository;
        this.profilRepository = profilRepository;
        this.groupRepository = groupRepository;
        this.iamLogbookService = iamLogbookService;
        this.userConverter = userConverter;
        this.mongoTransactionManager = mongoTransactionManager;
        this.logbookService = logbookService;
        this.addressService = addressService;
        this.applicationInternalService = applicationInternalService;
        this.passwordConfiguration = passwordConfiguration;
        this.maxOldPassword = passwordConfiguration != null && passwordConfiguration.getMaxOldPassword() != null ? passwordConfiguration.getMaxOldPassword() : 12;
        this.userExportService = userExportService;
        this.userInfoInternalService = userInfoInternalService;
        this.connectionHistoryService = connectionHistoryService;
    }

    public UserDto findUserById(String id) {
        return (UserDto)super.getOneByPassSecurity(id, Optional.empty());
    }

    public UserDto findUserByEmailAndCustomerId(String email, String customerId) {
        User user = this.getRepository().findByEmailIgnoreCaseAndCustomerId(email, customerId);
        if (user == null) {
            throw new NotFoundException("User not found for email: " + email);
        }
        return (UserDto)this.convertFromEntityToDto((BaseIdDocument)user);
    }

    public List<UserDto> findUsersByEmail(String email) {
        List users = this.getRepository().findAllByEmailIgnoreCase(email);
        return users.stream().map(arg_0 -> ((UserInternalService)this).convertFromEntityToDto(arg_0)).collect(Collectors.toList());
    }

    public AuthUserDto getMe() {
        return this.internalSecurityService.getUser();
    }

    protected void beforeCreate(UserDto dto) {
        String message = "Unable to create user " + dto.getEmail() + " (" + dto.getCustomerId() + ")";
        this.checkSetReadonly(dto.isReadonly(), message);
        this.checkCustomer(dto.getCustomerId(), message);
        this.checkEmail(dto.getEmail(), dto.getCustomerId(), message);
        this.checkGroupId(dto.getGroupId(), message);
        super.checkIdentifier(dto.getIdentifier(), message);
        GroupDto groupDto = this.getGroupDtoById(dto.getGroupId(), message);
        this.checkGroup(groupDto, dto.getCustomerId(), message);
        this.checkLevel(groupDto.getLevel(), message);
        this.checkOtp(dto);
        if (dto.getPhone() != null) {
            this.checkPhoneNumber(dto.getPhone());
        }
        if (dto.getMobile() != null) {
            this.checkPhoneNumber(dto.getMobile());
        }
        dto.setLevel(groupDto.getLevel());
        dto.setIdentifier(this.getNextSequenceId("userIdentifier"));
        dto.setPasswordExpirationDate(this.getPasswordExpirationDate(dto.getCustomerId()));
    }

    public Resource exportUsers(Optional<String> criteria) {
        ByteArrayResource byteArrayResource;
        ByteArrayOutputStream xlsOutputStream = new ByteArrayOutputStream();
        try {
            List usersDto = this.getAll(criteria);
            List userIds = usersDto.stream().map(UserDto::getIdentifier).collect(Collectors.toList());
            List userInfoIds = usersDto.stream().map(UserDto::getUserInfoId).collect(Collectors.toList());
            List userGroupIds = usersDto.stream().map(UserDto::getGroupId).collect(Collectors.toList());
            LogbookOperationsResponseDto userOperations = this.getUserOperations(this.getIdentifiers(usersDto));
            LogbookOperationsResponseDto userInfoOperations = this.getUserInfoOperations(this.getIdentifiers(usersDto));
            List userEvents = this.mapToEvents(userOperations, userInfoOperations);
            List filteredUserEvents = this.filterUserEvents(userEvents, userIds);
            this.userExportService.createXlsxFile(usersDto, filteredUserEvents, this.buildUsersInfoLangMap(userInfoIds), this.buildUsersGroupNamesMap(userGroupIds), (OutputStream)xlsOutputStream);
            byteArrayResource = new ByteArrayResource(xlsOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    xlsOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                throw new InternalServerException("An error occurred while creating the xls users list export", (Throwable)exception);
            }
        }
        xlsOutputStream.close();
        return byteArrayResource;
    }

    private List<LogbookEventDto> filterUserEvents(List<LogbookEventDto> userEvents, List<String> userIds) {
        return userEvents.stream().filter(logbookEventDto -> USER_OPERATIONS_EVENT_TYPES.contains(EventType.valueOf((String)logbookEventDto.getEvType()))).filter(logbookEventDto -> userIds.contains(logbookEventDto.getObId())).collect(Collectors.toList());
    }

    private List<String> getIdentifiers(List<UserDto> usersDto) {
        return usersDto.stream().map(UserDto::getIdentifier).collect(Collectors.toList());
    }

    private List<LogbookEventDto> mapToEvents(LogbookOperationsResponseDto userOperations, LogbookOperationsResponseDto userInfoOperations) {
        Stream mergedOperations = Stream.concat(userOperations.getResults().stream(), userInfoOperations.getResults().stream());
        return mergedOperations.map(operation -> {
            operation.getEvents().forEach(logbookEventDto -> logbookEventDto.setEvIdAppSession(operation.getEvIdAppSession()));
            return operation.getEvents();
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private LogbookOperationsResponseDto getUserOperations(List<String> userIdentifiers) {
        VitamContext vitamContext = this.internalSecurityService.buildVitamContext(this.internalSecurityService.getTenantIdentifier());
        ObjectNode usersQuery = this.logbookService.buildQuery(userIdentifiers, "users");
        try {
            RequestResponse usersLogbookOperations = this.logbookService.selectOperations((JsonNode)usersQuery, vitamContext);
            return (LogbookOperationsResponseDto)VitamRestUtils.responseMapping((JsonNode)usersLogbookOperations.toJsonNode(), LogbookOperationsResponseDto.class);
        }
        catch (VitamClientException exception) {
            throw new InternalServerException("An error occurred while fetching user operations", (Throwable)exception);
        }
    }

    private LogbookOperationsResponseDto getUserInfoOperations(List<String> userIdentifiers) {
        VitamContext vitamContext = this.internalSecurityService.buildVitamContext(this.internalSecurityService.getTenantIdentifier());
        ObjectNode userInfoQuery = this.logbookService.buildQuery(userIdentifiers, "userInfos");
        try {
            RequestResponse userInfoLogbookOperations = this.logbookService.selectOperations((JsonNode)userInfoQuery, vitamContext);
            return (LogbookOperationsResponseDto)VitamRestUtils.responseMapping((JsonNode)userInfoLogbookOperations.toJsonNode(), LogbookOperationsResponseDto.class);
        }
        catch (VitamClientException exception) {
            throw new InternalServerException("An error occurred while fetching user operations", (Throwable)exception);
        }
    }

    public UserDto create(UserDto userDto) {
        UserDto createdUserDto = null;
        TransactionStatus status = null;
        if (this.mongoTransactionManager != null) {
            DefaultTransactionDefinition definition = new DefaultTransactionDefinition(0);
            status = this.mongoTransactionManager.getTransaction((TransactionDefinition)definition);
        }
        try {
            createdUserDto = (UserDto)super.create((IdDto)userDto);
            this.iamLogbookService.createUserEvent(createdUserDto);
            if (this.mongoTransactionManager != null) {
                this.mongoTransactionManager.commit(status);
            }
        }
        catch (Exception e) {
            if (this.mongoTransactionManager != null) {
                this.mongoTransactionManager.rollback(status);
            }
            throw e;
        }
        this.userEmailInternalService.sendCreationEmail(createdUserDto);
        return createdUserDto;
    }

    protected OffsetDateTime getPasswordExpirationDate(String customerId) {
        Optional customer = this.customerRepository.findById((Object)customerId);
        Assert.isTrue((boolean)customer.isPresent(), (String)"Customer does not exist");
        return OffsetDateTime.now().plusMonths(((Customer)customer.get()).getPasswordRevocationDelay().intValue());
    }

    protected void beforeUpdate(UserDto dto) {
        String message = "Unable to update user " + dto.getId();
        User user = this.find(dto.getId(), dto.getCustomerId(), message);
        this.checkIsReadonly(user.isReadonly(), message);
        this.checkCustomer(user.getCustomerId(), message);
        this.checkLevel(user.getLevel(), message);
        this.checkSetReadonly(dto.isReadonly(), message);
        if (!StringUtils.equalsIgnoreCase((CharSequence)user.getEmail(), (CharSequence)dto.getEmail())) {
            this.checkEmail(dto.getEmail(), user.getCustomerId(), message);
        }
        this.checkSetReadonly(dto.isReadonly(), message);
        GroupDto groupDto = this.getGroupDtoById(dto.getGroupId(), message);
        this.checkGroup(groupDto, user.getCustomerId(), message);
        this.checkLevel(groupDto.getLevel(), message);
        this.checkOtp(dto);
        if (dto.getPhone() != null && !StringUtils.equalsIgnoreCase((CharSequence)user.getPhone(), (CharSequence)dto.getPhone())) {
            this.checkPhoneNumber(dto.getPhone());
        }
        if (dto.getMobile() != null && !StringUtils.equalsIgnoreCase((CharSequence)user.getMobile(), (CharSequence)dto.getMobile())) {
            this.checkPhoneNumber(dto.getMobile());
        }
        dto.setLevel(groupDto.getLevel());
        dto.setIdentifier(user.getIdentifier());
        dto.setPasswordExpirationDate(user.getPasswordExpirationDate());
    }

    public UserDto update(UserDto dto) {
        boolean sendMail = false;
        UserDto updatedUser = null;
        TransactionStatus status = null;
        if (this.mongoTransactionManager != null) {
            DefaultTransactionDefinition definition = new DefaultTransactionDefinition(0);
            status = this.mongoTransactionManager.getTransaction((TransactionDefinition)definition);
        }
        try {
            VitamContext vitamContext = this.internalSecurityService.buildVitamContext(this.internalSecurityService.getTenantIdentifier());
            if (vitamContext != null) {
                LOGGER.debug("Update User EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            }
            LOGGER.debug("Update {} {}", (Object)this.getObjectName(), (Object)dto);
            this.beforeUpdate(dto);
            User entity = (User)this.convertFromDtoToEntity((IdDto)dto);
            String entityId = entity.getId();
            Optional optExistingUser = this.getRepository().findById((Object)entityId);
            Assert.isTrue((boolean)optExistingUser.isPresent(), (String)("Unable to update " + this.getObjectName() + ": no entity found with id: " + entityId));
            User existingUser = (User)optExistingUser.get();
            entity.setPassword(existingUser.getPassword());
            entity.setOldPasswords(existingUser.getOldPasswords());
            UserStatusEnum existingStatus = existingUser.getStatus();
            UserStatusEnum newStatus = dto.getStatus();
            if (this.statusEquals(newStatus, UserStatusEnum.ENABLED) && this.statusEquals(existingStatus, UserStatusEnum.DISABLED)) {
                this.saveCurrentPasswordInOldPasswords(entity, entity.getPassword(), this.maxOldPassword);
                entity.setPassword(null);
                entity.setPasswordExpirationDate(OffsetDateTime.now());
                entity.setNbFailedAttempts(0);
                sendMail = true;
                AuthUserDto authUserDto = this.internalSecurityService.getUser();
                this.iamLogbookService.revokePasswordEvent(dto, authUserDto.getSuperUserIdentifier());
            }
            User savedEntity = (User)this.getRepository().save((Object)entity);
            updatedUser = (UserDto)this.convertFromEntityToDto((BaseIdDocument)savedEntity);
            if (this.mongoTransactionManager != null) {
                this.mongoTransactionManager.commit(status);
            }
        }
        catch (Exception e) {
            if (this.mongoTransactionManager != null) {
                this.mongoTransactionManager.rollback(status);
            }
            throw e;
        }
        if (sendMail) {
            this.userEmailInternalService.sendCreationEmail(updatedUser);
        }
        return updatedUser;
    }

    public void saveCurrentPasswordInOldPasswords(User user, String newPassword, Integer maxOldPassword) {
        if (StringUtils.isNotBlank((CharSequence)newPassword)) {
            List<String> oldPasswords = user.getOldPasswords();
            if (oldPasswords == null) {
                oldPasswords = new ArrayList<String>();
            }
            oldPasswords.add(0, newPassword);
            if (oldPasswords.size() > maxOldPassword) {
                oldPasswords = oldPasswords.subList(0, maxOldPassword);
            }
            user.setOldPasswords(oldPasswords);
        }
    }

    private boolean statusEquals(UserStatusEnum status, UserStatusEnum expectedStatus) {
        return status != null && status.equals((Object)expectedStatus);
    }

    public UserDto patch(Map<String, Object> partialDto) {
        boolean sendMail = false;
        UserDto dto = null;
        TransactionStatus status = null;
        if (this.mongoTransactionManager != null) {
            DefaultTransactionDefinition definition = new DefaultTransactionDefinition(0);
            status = this.mongoTransactionManager.getTransaction((TransactionDefinition)definition);
        }
        try {
            LOGGER.debug("Patch {} with {}", (Object)this.getObjectName(), partialDto);
            String email = CastUtils.toString((Object)partialDto.get("email"));
            if (email != null) {
                partialDto.put("email", email.toLowerCase());
            }
            User entity = this.beforePatch(partialDto);
            UserStatusEnum existingStatus = entity.getStatus();
            this.processPatch(entity, partialDto);
            Assert.isTrue((boolean)this.getRepository().existsById((Object)entity.getId()), (String)("Unable to patch " + this.getObjectName() + ": no entity found with id: " + entity.getId()));
            UserStatusEnum newStatus = entity.getStatus();
            if (this.statusEquals(existingStatus, UserStatusEnum.DISABLED) && this.statusEquals(newStatus, UserStatusEnum.ENABLED)) {
                entity.setPassword(null);
                entity.setPasswordExpirationDate(OffsetDateTime.now());
                entity.setNbFailedAttempts(0);
                sendMail = true;
                AuthUserDto authUserDto = this.internalSecurityService.getUser();
                this.iamLogbookService.revokePasswordEvent(entity, authUserDto.getSuperUserIdentifier());
            }
            User savedEntity = (User)this.getRepository().save((Object)entity);
            dto = (UserDto)this.convertFromEntityToDto((BaseIdDocument)savedEntity);
            if (this.mongoTransactionManager != null) {
                this.mongoTransactionManager.commit(status);
            }
        }
        catch (Exception e) {
            if (this.mongoTransactionManager != null) {
                this.mongoTransactionManager.rollback(status);
            }
            throw e;
        }
        if (sendMail) {
            this.userEmailInternalService.sendCreationEmail(dto);
        }
        return dto;
    }

    protected User beforePatch(Map<String, Object> partialDto) {
        String groupId;
        String email;
        String id = CastUtils.toString((Object)partialDto.get("id"));
        String message = "Unable to patch user " + id;
        String customerId = CastUtils.toString((Object)partialDto.get("customerId"));
        User user = this.find(id, customerId, message);
        Assert.isTrue((!partialDto.containsKey("password") ? 1 : 0) != 0, (String)(message + user.getId() + " : cannot patch password"));
        Assert.isTrue((!partialDto.containsKey("identifier") ? 1 : 0) != 0, (String)(message + user.getId() + " cannot patch identifier"));
        Assert.isTrue((!partialDto.containsKey("readonly") ? 1 : 0) != 0, (String)(message + user.getId() + " cannot patch readonly"));
        Assert.isTrue((!partialDto.containsKey("level") ? 1 : 0) != 0, (String)(message + user.getId() + " cannot patch level"));
        Assert.isTrue((!UserStatusEnum.BLOCKED.toString().equals(partialDto.get("status")) ? 1 : 0) != 0, (String)"User can't be blocked by API, this action need a special workflow for be realised");
        Assert.isTrue((!this.checkMapContainsOnlyFieldsUnmodifiable(partialDto, Arrays.asList("id", "customerId")) ? 1 : 0) != 0, (String)message);
        this.checkLevel(user.getLevel(), message);
        this.checkIsReadonly(user.isReadonly(), message);
        Boolean userHasOtp = CastUtils.toBoolean((Object)partialDto.get("otp"));
        if (userHasOtp != null) {
            this.checkOtp(user, userHasOtp);
        }
        if ((email = CastUtils.toString((Object)partialDto.get("email"))) != null) {
            this.checkEmail(email, user.getCustomerId(), message);
        }
        if (!StringUtils.isEmpty((CharSequence)(groupId = CastUtils.toString((Object)partialDto.get("groupId"))))) {
            GroupDto groupDto = this.getGroupDtoById(groupId, message);
            this.checkGroup(groupDto, customerId, message);
            if (!StringUtils.equals((CharSequence)user.getLevel(), (CharSequence)groupDto.getLevel())) {
                this.checkLevel(groupDto.getLevel(), message);
                partialDto.put("level", groupDto.getLevel());
            }
        }
        String phone = CastUtils.toString((Object)partialDto.get("phone"));
        String mobile = CastUtils.toString((Object)partialDto.get("mobile"));
        if (phone != null && !StringUtils.equalsIgnoreCase((CharSequence)user.getPhone(), (CharSequence)phone)) {
            this.checkPhoneNumber(phone);
        }
        if (mobile != null && !StringUtils.equalsIgnoreCase((CharSequence)user.getMobile(), (CharSequence)mobile)) {
            this.checkPhoneNumber(mobile);
        }
        return user;
    }

    protected void processPatch(User user, Map<String, Object> partialDto) {
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        block41: for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "customerId": {
                    continue block41;
                }
                case "email": {
                    logbooks.add(new EventDiffDto("Email", (Object)"-", (Object)"-"));
                    user.setEmail(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "firstname": {
                    logbooks.add(new EventDiffDto("Pr\u00e9nom", (Object)"-", (Object)"-"));
                    user.setFirstname(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "lastname": {
                    logbooks.add(new EventDiffDto("Nom", (Object)"-", (Object)"-"));
                    user.setLastname(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "language": {
                    logbooks.add(new EventDiffDto("Langue", (Object)user.getLanguage(), entry.getValue()));
                    user.setLanguage(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "type": {
                    String typeAsString = CastUtils.toString((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Type", (Object)user.getType(), (Object)typeAsString));
                    user.setType((UserTypeEnum)EnumUtils.stringToEnum(UserTypeEnum.class, (String)typeAsString));
                    continue block41;
                }
                case "level": {
                    logbooks.add(new EventDiffDto("Niveau", (Object)user.getLevel(), entry.getValue()));
                    user.setLevel(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "mobile": {
                    logbooks.add(new EventDiffDto("Num\u00e9ro mobile", (Object)"-", (Object)"-"));
                    user.setMobile(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "phone": {
                    logbooks.add(new EventDiffDto("Num\u00e9ro fixe", (Object)"-", (Object)"-"));
                    user.setPhone(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "groupId": {
                    GroupDto oldGroup = this.groupInternalService.getOne(user.getGroupId(), Optional.empty(), Optional.empty());
                    if (CastUtils.toString((Object)entry.getValue()).isEmpty()) {
                        logbooks.add(new EventDiffDto("Groupe de profils", (Object)oldGroup.getIdentifier(), Optional.empty()));
                        user.setGroupId(CastUtils.toString((Object)entry.getValue()));
                        continue block41;
                    }
                    GroupDto newGroup = this.groupInternalService.getOne(CastUtils.toString((Object)entry.getValue()), Optional.empty(), Optional.empty());
                    logbooks.add(new EventDiffDto("Groupe de profils", (Object)oldGroup.getIdentifier(), (Object)newGroup.getIdentifier()));
                    user.setGroupId(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "status": {
                    String status = CastUtils.toString((Object)entry.getValue());
                    logbooks.add(new EventDiffDto("Statut", (Object)user.getStatus(), (Object)status));
                    user.setStatus((UserStatusEnum)EnumUtils.stringToEnum(UserStatusEnum.class, (String)status));
                    if (user.getStatus() == UserStatusEnum.DISABLED) {
                        logbooks.add(new EventDiffDto("Date de d\u00e9sactivation", (Object)user.getDisablingDate(), (Object)OffsetDateTime.now()));
                        user.setDisablingDate(OffsetDateTime.now());
                    }
                    if (user.getStatus() == UserStatusEnum.REMOVED) {
                        logbooks.add(new EventDiffDto("Date de suppression", (Object)user.getRemovingDate(), (Object)OffsetDateTime.now()));
                        user.setRemovingDate(OffsetDateTime.now());
                        user.setDisablingDate(null);
                        this.connectionHistoryService.deleteByUserId(user.getId());
                    }
                    if (user.getStatus() != UserStatusEnum.ENABLED) continue block41;
                    user.setDisablingDate(null);
                    user.setRemovingDate(null);
                    user.setNbFailedAttempts(0);
                    continue block41;
                }
                case "subrogeable": {
                    logbooks.add(new EventDiffDto("Subrogeable", (Object)user.isSubrogeable(), entry.getValue()));
                    user.setSubrogeable(CastUtils.toBoolean((Object)entry.getValue()).booleanValue());
                    continue block41;
                }
                case "otp": {
                    logbooks.add(new EventDiffDto("OTP", (Object)user.isOtp(), entry.getValue()));
                    user.setOtp(CastUtils.toBoolean((Object)entry.getValue()).booleanValue());
                    continue block41;
                }
                case "address": {
                    Address address = user.getAddress();
                    if (address == null) {
                        user.setAddress(new Address());
                    }
                    this.addressService.processPatch(user.getAddress(), CastUtils.toMap((Object)entry.getValue()), logbooks, true);
                    continue block41;
                }
                case "internalCode": {
                    logbooks.add(new EventDiffDto("Code interne", (Object)user.getInternalCode(), entry.getValue()));
                    user.setInternalCode(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "siteCode": {
                    logbooks.add(new EventDiffDto("Code du site", (Object)user.getSiteCode(), entry.getValue()));
                    user.setSiteCode(CastUtils.toString((Object)entry.getValue()));
                    continue block41;
                }
                case "centerCodes": {
                    logbooks.add(new EventDiffDto("Code des centres", (Object)user.getCenterCodes(), entry.getValue()));
                    user.setCenterCodes(CastUtils.toList((Object)entry.getValue()));
                    continue block41;
                }
                case "autoProvisioningEnabled": {
                    logbooks.add(new EventDiffDto("Mise \u00e0 jour automatique", (Object)user.isAutoProvisioningEnabled(), entry.getValue()));
                    user.setAutoProvisioningEnabled(CastUtils.toBoolean((Object)entry.getValue()).booleanValue());
                    continue block41;
                }
            }
            throw new IllegalArgumentException("Unable to patch group " + user.getId() + ": key " + entry.getKey() + " is not allowed");
        }
        this.iamLogbookService.updateUserEvent(user, logbooks);
    }

    public void updateOtpForUsersByCustomerId(boolean otp, String id) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"customerId").is((Object)id));
        List users = this.userRepository.findAll(query);
        for (User u : users) {
            EventDiffDto evData = new EventDiffDto("OTP", (Object)u.isOtp(), (Object)otp);
            u.setOtp(otp);
            this.userRepository.save((Object)u);
            this.iamLogbookService.updateUserEvent(u, Arrays.asList(evData));
        }
        Update update = Update.update((String)"otp", (Object)otp);
        this.userRepository.updateMulti(query, update);
    }

    private User find(String id, String customerId, String message) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)(message + ": no id"));
        if (!this.internalSecurityService.hasRole("ROLE_PROVISIONING_USER")) {
            Assert.isTrue((boolean)StringUtils.equals((CharSequence)customerId, (CharSequence)this.getInternalSecurityService().getCustomerId()), (String)(message + ": customerId " + customerId + " is not allowed"));
        }
        return (User)this.getRepository().findByIdAndCustomerId(id, customerId).orElseThrow(() -> new IllegalArgumentException(message + ": no user found for id " + id + " - customerId " + customerId));
    }

    private void checkIsReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly user "));
    }

    private void checkGroup(GroupDto groupDto, String customerId, String message) {
        Assert.isTrue((groupDto != null ? 1 : 0) != 0, (String)(message + ": group does not exist"));
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)groupDto.getCustomerId(), (CharSequence)customerId), (String)(message + ": group and user customerId must be equals"));
        Assert.isTrue((boolean)groupDto.isEnabled(), (String)(message + ": group must be enabled"));
    }

    private void checkSetReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly must be set to false"));
    }

    private void checkEmail(String email, String customerId, String message) {
        Assert.notNull((Object)email, (String)("email : " + email + " format is not allowed"));
        Assert.isTrue((boolean)Pattern.matches("^[_A-Za-z0-9]+(((\\.|-)[_A-Za-z0-9]+))*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$", email), (String)("email : " + email + " format is not allowed"));
        Assert.isNull((Object)this.getRepository().findByEmailIgnoreCaseAndCustomerId(email, customerId), (String)(message + ": mail already exists"));
        if (email.matches("admin@.*")) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"email").regex("^admin@"));
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"customerId").is((Object)customerId));
            Optional adminUser = this.getRepository().findOne(query);
            Assert.isTrue((!adminUser.isPresent() ? 1 : 0) != 0, (String)(message + ": admin user already exists"));
        }
    }

    private void checkPhoneNumber(String phoneNumber) {
        Assert.isTrue((boolean)Pattern.matches("^[+]{1}[0-9]{11,12}$", phoneNumber), (String)("Phone Number : " + phoneNumber + " format is not allowed"));
    }

    private void checkLevel(String level, String message) {
        Assert.isTrue((boolean)Pattern.matches("(^[A-Z0-9]+(.[A-Z0-9]+)*$)|^$", level), (String)("level : " + level + " format is not allowed"));
        Assert.isTrue((boolean)this.internalSecurityService.isLevelAllowed(level), (String)(message + ": level " + level + " is not allowed"));
    }

    private void checkGroupId(String groupId, String message) {
        Assert.isTrue((groupId != null ? 1 : 0) != 0, (String)(message + ": groupId must not be null"));
    }

    private void checkCustomer(String customerId, String message) {
        Optional customer = this.customerRepository.findById((Object)customerId);
        Assert.isTrue((boolean)customer.isPresent(), (String)(message + ": customer does not exist"));
        Assert.isTrue((boolean)((Customer)customer.get()).isEnabled(), (String)(message + ": customer must be enabled"));
    }

    private void checkOtp(UserDto userDto) {
        if (UserTypeEnum.GENERIC == userDto.getType() && !userDto.isOtp()) {
            return;
        }
        this.checkOtp(userDto.isOtp(), userDto.getEmail(), userDto.getMobile(), userDto.getCustomerId());
    }

    private void checkOtp(User user, Boolean userHasOtp) {
        this.checkOtp(userHasOtp.booleanValue(), user.getEmail(), user.getMobile(), user.getCustomerId());
    }

    private void checkOtp(boolean userHasOtp, String userEmail, String userMobile, String customerId) {
        Customer customer = (Customer)this.customerRepository.findById((Object)customerId).orElseThrow(() -> new ApplicationServerException("Unable to check opt for user " + userEmail + " - Customer  not found: " + customerId));
        if (OtpEnum.MANDATORY.equals((Object)customer.getOtp()) && !userHasOtp) {
            throw new IllegalArgumentException("Unable to disable otp for user:" + userEmail + " . Otp is mandatory this customer");
        }
        if (OtpEnum.DISABLED.equals((Object)customer.getOtp()) && userHasOtp) {
            throw new IllegalArgumentException("Unable to enable otp for user:" + userEmail + " . Otp is mandatory this customer");
        }
        if (userHasOtp && StringUtils.isEmpty((CharSequence)userMobile)) {
            throw new IllegalArgumentException("Unable to enable otp for user:" + userEmail + " without a mobile phone");
        }
    }

    private GroupDto getGroupDtoByIdByPassSecurity(String groupId, String message) {
        try {
            return (GroupDto)this.groupInternalService.getOneByPassSecurity(groupId, Optional.empty());
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException(message + ": group does not exist");
        }
    }

    private GroupDto getGroupDtoById(String groupId, String message) {
        try {
            return this.groupInternalService.getOne(groupId, Optional.empty(), Optional.empty());
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException(message + ": group does not exist");
        }
    }

    protected User internalConvertFromDtoToEntity(UserDto dto) {
        return (User)super.internalConvertFromDtoToEntity((IdDto)dto);
    }

    public UserDto internalConvertFromEntityToDto(User user) {
        return (UserDto)super.internalConvertFromEntityToDto((BaseIdDocument)user);
    }

    public UserDto getDefaultAdminUser(String customerId) {
        Optional customer = this.customerRepository.findById((Object)customerId);
        if (!customer.isPresent()) {
            throw new NotFoundException("No customer found for: " + customerId);
        }
        String email = "admin@" + ((Customer)customer.get()).getDefaultEmailDomain().replace(".*", "");
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        criteria.add(Criteria.where((String)"customerId").in(new Object[]{customerId}));
        criteria.add(Criteria.where((String)"email").is((Object)email));
        List users = this.getRepository().findAll(criteria);
        if (users.isEmpty()) {
            throw new NotFoundException("No admin user found for email: " + email);
        }
        return (UserDto)this.convertFromEntityToDto((BaseIdDocument)((User)users.get(0)));
    }

    public long countByGroupId(String profileGroupId) {
        return this.getRepository().countByGroupId(profileGroupId);
    }

    public void addBasicCustomerAndProofTenantIdentifierInformation(AuthUserDto userDto) {
        String id = userDto.getId();
        Customer customer = (Customer)this.customerRepository.findById((Object)userDto.getCustomerId()).orElseThrow(() -> new NotFoundException("Cannot find customer : " + userDto.getCustomerId() + " of the user: " + id));
        userDto.setCustomerIdentifier(customer.getIdentifier());
        BasicCustomerDto basicCustomerDto = new BasicCustomerDto();
        basicCustomerDto.setId(customer.getId());
        basicCustomerDto.setIdentifier(customer.getIdentifier());
        basicCustomerDto.setName(customer.getName());
        basicCustomerDto.setCode(customer.getCode());
        basicCustomerDto.setCompanyName(customer.getCompanyName());
        basicCustomerDto.setPortalMessages(customer.getPortalMessages());
        basicCustomerDto.setPortalTitles(customer.getPortalTitles());
        if (customer.getGraphicIdentity() != null) {
            GraphicIdentityDto graphicIdentity = new GraphicIdentityDto();
            graphicIdentity.setHasCustomGraphicIdentity(customer.getGraphicIdentity().isHasCustomGraphicIdentity());
            graphicIdentity.setHeaderDataBase64(customer.getGraphicIdentity().getLogoHeaderBase64());
            graphicIdentity.setFooterDataBase64(customer.getGraphicIdentity().getLogoFooterBase64());
            graphicIdentity.setPortalDataBase64(customer.getGraphicIdentity().getLogoPortalBase64());
            graphicIdentity.setThemeColors(customer.getGraphicIdentity().getThemeColors());
            basicCustomerDto.setGraphicIdentity(graphicIdentity);
        }
        userDto.setBasicCustomer(basicCustomerDto);
        userDto.setProofTenantIdentifier(this.findTenantByCustomerId(customer.getId(), userDto.getId()).getIdentifier());
    }

    private Tenant findTenantByCustomerId(String customerId, String userId) {
        Optional<Tenant> proofTenant = this.tenantRepository.findByCustomerId(customerId).stream().filter(Tenant::isProof).findFirst();
        if (!proofTenant.isPresent()) {
            throw new NotFoundException("Cannot find any proof tenant attached for customer : " + customerId + " of the user: " + userId);
        }
        return proofTenant.get();
    }

    public AuthUserDto loadGroupAndProfiles(UserDto userDto) {
        AuthUserDto authUserDto = new AuthUserDto(userDto);
        String groupId = userDto.getGroupId();
        GroupDto groupDto = this.getGroupDtoByIdByPassSecurity(groupId, "Unable to embed group");
        authUserDto.setProfileGroup(groupDto);
        List profileIds = groupDto.getProfileIds();
        List profiles = this.profileInternalService.getMany(profileIds.toArray(new String[0]));
        if (profiles.size() != profileIds.size()) {
            List profilesNotFound = profileIds.stream().filter(profileId -> profiles.stream().filter(profile -> profile.getId().equals(profileId)).count() == 0L).collect(Collectors.toList());
            LOGGER.info("profile non trouv\u00e9 {} ", profilesNotFound);
            LOGGER.info("profile touv\u00e9 {}", (Object)profileIds);
            throw new ApplicationServerException("Unable to embed group " + groupId + " for user " + userDto.getId() + " : one of the profiles does not exist");
        }
        groupDto.setProfiles(profiles);
        profiles.forEach(p -> {
            Tenant tenant = this.tenantRepository.findByIdentifier(p.getTenantIdentifier());
            p.setTenantName(tenant.getName());
        });
        return authUserDto;
    }

    public void addDataAccessRestrictions(Collection<CriteriaDefinition> criteria) {
        super.addDataAccessRestrictions(criteria);
    }

    public void addTenantsByAppInformation(AuthUserDto authUserDto) {
        HashMap tenantsByApp = new HashMap();
        if (authUserDto.getProfileGroup().getProfiles() != null) {
            authUserDto.getProfileGroup().getProfiles().stream().filter(profile -> profile.getTenantName() != null).forEach(profile -> {
                if (!tenantsByApp.containsKey(profile.getApplicationName())) {
                    tenantsByApp.put(profile.getApplicationName(), new HashSet());
                }
                TenantDto tenant = (TenantDto)VitamUIUtils.copyProperties((Object)this.tenantRepository.findByIdentifier(profile.getTenantIdentifier()), (Object)new TenantDto());
                ((Set)tenantsByApp.get(profile.getApplicationName())).add(tenant);
            });
        }
        ArrayList tenantsData = new ArrayList();
        tenantsByApp.entrySet().stream().forEach(entry -> {
            TenantInformationDto appInformations = new TenantInformationDto();
            appInformations.setName((String)entry.getKey());
            appInformations.setTenants((Set)entry.getValue());
            tenantsData.add(appInformations);
        });
        authUserDto.setTenantsByApp(tenantsData);
    }

    public boolean checkExist(String criteriaJsonString) {
        return super.checkExist(criteriaJsonString);
    }

    protected Class<User> getEntityClass() {
        return User.class;
    }

    protected UserRepository getRepository() {
        return this.userRepository;
    }

    protected Converter<UserDto, User> getConverter() {
        return this.userConverter;
    }

    public JsonNode findHistoryById(String id) throws VitamClientException {
        LOGGER.debug("findHistoryById for id " + id);
        Integer tenantIdentifier = this.internalSecurityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.internalSecurityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.internalSecurityService.getApplicationId());
        Optional user = this.getRepository().findById((Object)id);
        user.orElseThrow(() -> new NotFoundException(String.format("No user found with id : %s", id)));
        return this.logbookService.findEventsByIdentifierAndCollectionNames(((User)user.get()).getIdentifier(), "users", vitamContext).toJsonNode();
    }

    public List<String> getLevels(Optional<String> criteriaJsonString) {
        Document document = this.groupFields(criteriaJsonString, new String[]{"level"});
        LOGGER.debug("getLevels : {}", (Object)document);
        if (document == null) {
            return new ArrayList<String>();
        }
        return (List)document.get((Object)"level");
    }

    public UserDto patchAnalytics(Map<String, Object> partialDto) {
        String userId;
        this.checkAnalyticsAllowedFields(partialDto);
        if (partialDto.containsKey("id")) {
            userId = partialDto.get("id").toString();
        } else {
            AuthUserDto loggedUser = this.getMe();
            userId = loggedUser.getId();
        }
        User user = this.getUserById(userId);
        partialDto.forEach((key, value) -> {
            switch (key) {
                case "id": {
                    break;
                }
                case "applicationId": {
                    this.patchApplicationAnalytics(user, CastUtils.toString((Object)value));
                    break;
                }
                case "lastTenantIdentifier": {
                    this.patchLastTenantIdentifier(user, CastUtils.toInteger((Object)value));
                    break;
                }
                case "alerts": {
                    ObjectMapper objectMapper = new ObjectMapper();
                    List alertAnalytics = (List)objectMapper.convertValue((Object)CastUtils.toList((Object)value), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    this.patchAlertsAnalytics(user, alertAnalytics);
                }
            }
        });
        return this.userConverter.convertEntityToDto((User)this.getRepository().save((Object)user));
    }

    private User getUserById(String id) {
        return (User)this.getRepository().findById((Object)id).orElseThrow(() -> new NotFoundException(String.format("No user found with id : %s", id)));
    }

    private void checkAnalyticsAllowedFields(Map<String, Object> partialDto) {
        Set<String> analyticsPatchAllowedFields = Set.of("applicationId", "lastTenantIdentifier", "alerts", "id");
        if (MapUtils.isEmpty(partialDto)) {
            throw new IllegalArgumentException("Unable to patch user analytics : payload is empty");
        }
        partialDto.keySet().forEach(key -> {
            if (!analyticsPatchAllowedFields.contains(key)) {
                throw new IllegalArgumentException(String.format("Unable to patch user analytics key : %s is not allowed", key));
            }
        });
    }

    private void patchApplicationAnalytics(User user, String applicationId) {
        this.checkApplicationAccessPermission(applicationId);
        user.getAnalytics().tagApplicationAsLastUsed(applicationId);
    }

    private void patchLastTenantIdentifier(User user, Integer tenantIdentifier) {
        user.getAnalytics().setLastTenantIdentifier(tenantIdentifier);
    }

    private void patchAlertsAnalytics(User user, List<AlertAnalytics> alerts) {
        user.getAnalytics().setAlerts(alerts);
    }

    private void checkApplicationAccessPermission(String applicationId) {
        List loggedUserApplications = this.applicationInternalService.getAll(Optional.empty(), Optional.empty());
        boolean userHasPermission = loggedUserApplications.stream().anyMatch(application -> Objects.equals(application.getIdentifier(), applicationId));
        if (!userHasPermission && !applicationId.equals("PORTAL_APP")) {
            throw new IllegalArgumentException(String.format("User has no permission to access to the application : %s", applicationId));
        }
    }

    private Map<String, String> buildUsersInfoLangMap(List<String> userInfoIds) {
        return this.userInfoInternalService.getMany(userInfoIds).stream().collect(Collectors.toMap(IdDto::getId, UserInfoDto::getLanguage));
    }

    private Map<String, String> buildUsersGroupNamesMap(List<String> userGroupIds) {
        return this.groupInternalService.getMany(userGroupIds).stream().collect(Collectors.toMap(IdDto::getId, GroupDto::getName));
    }

    protected Document groupFields(Optional<String> criteriaJsonString, String ... fields) {
        return super.groupFields(criteriaJsonString, fields);
    }

    public List<User> findByCustomerId(String customerId) {
        return this.userRepository.findByCustomerId(customerId);
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Generated
    public GroupInternalService getGroupInternalService() {
        return this.groupInternalService;
    }

    @Generated
    public ProfileInternalService getProfileInternalService() {
        return this.profileInternalService;
    }

    @Generated
    public UserEmailInternalService getUserEmailInternalService() {
        return this.userEmailInternalService;
    }

    @Generated
    public TenantRepository getTenantRepository() {
        return this.tenantRepository;
    }

    @Generated
    public InternalSecurityService getInternalSecurityService() {
        return this.internalSecurityService;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public ProfileRepository getProfilRepository() {
        return this.profilRepository;
    }

    @Generated
    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public UserConverter getUserConverter() {
        return this.userConverter;
    }

    @Generated
    public String getADMIN_EMAIL_PATTERN() {
        Objects.requireNonNull(this);
        return "admin@";
    }

    @Generated
    public String getPORTAL_APP_IDENTIFIER() {
        Objects.requireNonNull(this);
        return "PORTAL_APP";
    }

    @Generated
    public MongoTransactionManager getMongoTransactionManager() {
        return this.mongoTransactionManager;
    }

    @Generated
    public LogbookService getLogbookService() {
        return this.logbookService;
    }

    @Generated
    public AddressService getAddressService() {
        return this.addressService;
    }

    @Generated
    public ApplicationInternalService getApplicationInternalService() {
        return this.applicationInternalService;
    }

    @Generated
    public PasswordConfiguration getPasswordConfiguration() {
        return this.passwordConfiguration;
    }

    @Generated
    public Integer getMaxOldPassword() {
        return this.maxOldPassword;
    }

    @Generated
    public UserExportService getUserExportService() {
        return this.userExportService;
    }

    @Generated
    public UserInfoInternalService getUserInfoInternalService() {
        return this.userInfoInternalService;
    }

    @Generated
    public ConnectionHistoryService getConnectionHistoryService() {
        return this.connectionHistoryService;
    }

    @Generated
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Generated
    public void setGroupInternalService(GroupInternalService groupInternalService) {
        this.groupInternalService = groupInternalService;
    }

    @Generated
    public void setProfileInternalService(ProfileInternalService profileInternalService) {
        this.profileInternalService = profileInternalService;
    }

    @Generated
    public void setUserEmailInternalService(UserEmailInternalService userEmailInternalService) {
        this.userEmailInternalService = userEmailInternalService;
    }

    @Generated
    public void setTenantRepository(TenantRepository tenantRepository) {
        this.tenantRepository = tenantRepository;
    }

    @Generated
    public void setInternalSecurityService(InternalSecurityService internalSecurityService) {
        this.internalSecurityService = internalSecurityService;
    }

    @Generated
    public void setCustomerRepository(CustomerRepository customerRepository) {
        this.customerRepository = customerRepository;
    }

    @Generated
    public void setProfilRepository(ProfileRepository profilRepository) {
        this.profilRepository = profilRepository;
    }

    @Generated
    public void setGroupRepository(GroupRepository groupRepository) {
        this.groupRepository = groupRepository;
    }

    @Generated
    public void setMongoTransactionManager(MongoTransactionManager mongoTransactionManager) {
        this.mongoTransactionManager = mongoTransactionManager;
    }

    @Generated
    public void setLogbookService(LogbookService logbookService) {
        this.logbookService = logbookService;
    }

    @Generated
    public void setAddressService(AddressService addressService) {
        this.addressService = addressService;
    }

    @Generated
    public void setUserInfoInternalService(UserInfoInternalService userInfoInternalService) {
        this.userInfoInternalService = userInfoInternalService;
    }

    @Generated
    public void setConnectionHistoryService(ConnectionHistoryService connectionHistoryService) {
        this.connectionHistoryService = connectionHistoryService;
    }
}

