/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.subrogation.service;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.enums.UserTypeEnum;
import fr.gouv.vitamui.commons.api.exception.ApplicationServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.logbook.common.EventType;
import fr.gouv.vitamui.commons.mongo.repository.VitamUIRepository;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.enums.SubrogationStatusEnum;
import fr.gouv.vitamui.iam.internal.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.internal.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.internal.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.internal.server.group.service.GroupInternalService;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.profile.dao.ProfileRepository;
import fr.gouv.vitamui.iam.internal.server.subrogation.converter.SubrogationConverter;
import fr.gouv.vitamui.iam.internal.server.subrogation.dao.SubrogationRepository;
import fr.gouv.vitamui.iam.internal.server.subrogation.domain.Subrogation;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.internal.server.user.domain.User;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInternalService;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class SubrogationInternalService
extends VitamUICrudService<SubrogationDto, Subrogation> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(SubrogationInternalService.class);
    private SubrogationRepository subrogationRepository;
    private UserRepository userRepository;
    private UserInternalService userInternalService;
    private GroupInternalService groupInternalService;
    private GroupRepository groupRepository;
    private ProfileRepository profilRepository;
    private InternalSecurityService internalSecurityService;
    private CustomerRepository customerRepository;
    private final SubrogationConverter subrogationConverter;
    private final IamLogbookService iamLogbookService;
    @Value(value="${subrogation.ttl}")
    @NotNull
    private Integer subrogationTtl;
    @Value(value="${generic.users.subrogation.ttl}")
    @NotNull
    private Integer genericUsersSubrogationTtl;

    @Autowired
    public SubrogationInternalService(SequenceGeneratorService sequenceGeneratorService, SubrogationRepository subrogationRepository, UserRepository userRepository, UserInternalService userInternalService, GroupInternalService groupInternalService, GroupRepository groupRepository, ProfileRepository profilRepository, InternalSecurityService internalSecurityService, CustomerRepository customerRepository, SubrogationConverter subrogationConverter, IamLogbookService iamLogbookService) {
        super(sequenceGeneratorService);
        this.subrogationRepository = subrogationRepository;
        this.userRepository = userRepository;
        this.userInternalService = userInternalService;
        this.groupInternalService = groupInternalService;
        this.groupRepository = groupRepository;
        this.profilRepository = profilRepository;
        this.internalSecurityService = internalSecurityService;
        this.customerRepository = customerRepository;
        this.subrogationConverter = subrogationConverter;
        this.iamLogbookService = iamLogbookService;
    }

    public SubrogationDto getMySubrogationAsSuperuser() {
        AuthUserDto user = this.internalSecurityService.getUser();
        return this.internalConvertFromEntityToDto(this.subrogationRepository.findOneBySuperUserAndSuperUserCustomerId(user.getEmail(), user.getCustomerId()));
    }

    public SubrogationDto getMySubrogationAsSurrogate() {
        AuthUserDto user = this.internalSecurityService.getUser();
        Optional optionalCustomer = this.customerRepository.findById((Object)user.getCustomerId());
        Assert.isTrue((boolean)optionalCustomer.isPresent(), (String)(" No customer found with id " + user.getCustomerId()));
        SubrogationDto subrogationDto = (SubrogationDto)this.convertFromEntityToDto((BaseIdDocument)this.subrogationRepository.findOneBySurrogateAndSurrogateCustomerId(user.getEmail(), user.getCustomerId()));
        if (subrogationDto != null) {
            subrogationDto.setSurrogateCustomerCode(((Customer)optionalCustomer.get()).getCode());
            subrogationDto.setSurrogateCustomerName(((Customer)optionalCustomer.get()).getName());
        }
        return subrogationDto;
    }

    protected Subrogation internalConvertFromDtoToEntity(SubrogationDto dto) {
        return (Subrogation)super.internalConvertFromDtoToEntity((IdDto)dto);
    }

    public SubrogationDto internalConvertFromEntityToDto(Subrogation entity) {
        return (SubrogationDto)super.internalConvertFromEntityToDto((BaseIdDocument)entity);
    }

    protected void beforeCreate(SubrogationDto dto) {
        super.beforeCreate((IdDto)dto);
        Assert.isTrue((boolean)dto.getStatus().equals((Object)SubrogationStatusEnum.CREATED), (String)"the subrogation must have the status CREATED at the creation");
        this.checkUsers(dto);
        int ttlInMinutes = dto.getStatus().equals((Object)SubrogationStatusEnum.ACCEPTED) ? this.genericUsersSubrogationTtl.intValue() : this.subrogationTtl.intValue();
        Instant nowPlusXMinutes = Instant.now().plus((long)ttlInMinutes, ChronoUnit.MINUTES);
        dto.setDate(nowPlusXMinutes);
        this.checkSubrogationAlreadyExist(dto.getSurrogate(), dto.getSurrogateCustomerId());
        this.checkSubrogationWithSuperUserAlreadyExist(dto.getSuperUser(), dto.getSuperUserCustomerId());
    }

    private void checkSubrogationWithSuperUserAlreadyExist(String superUser, String customerId) {
        Subrogation subro = this.subrogationRepository.findOneBySuperUserAndSuperUserCustomerId(superUser, customerId);
        if (subro != null) {
            throw new IllegalArgumentException(subro.getSuperUser() + "(" + subro.getSuperUserCustomerId() + ") is already subrogating " + subro.getSurrogate() + "(" + subro.getSurrogateCustomerId() + ")");
        }
    }

    private void checkSubrogationAlreadyExist(String email, String customerId) {
        Subrogation subro = this.subrogationRepository.findOneBySurrogateAndSurrogateCustomerId(email, customerId);
        if (subro != null) {
            throw new IllegalArgumentException(subro.getSurrogate() + "(" + subro.getSurrogateCustomerId() + ") is already subrogated by " + subro.getSuperUser() + "(" + subro.getSuperUserCustomerId() + ")");
        }
    }

    protected void beforeUpdate(SubrogationDto dto) {
        this.checkUsers(dto);
    }

    private void checkUsers(SubrogationDto dto) {
        String emailSurrogate = dto.getSurrogate();
        String emailSuperUser = dto.getSuperUser();
        User surrogate = this.userRepository.findByEmailIgnoreCaseAndCustomerId(emailSurrogate, dto.getSurrogateCustomerId());
        User superUser = this.userRepository.findByEmailIgnoreCaseAndCustomerId(emailSuperUser, dto.getSuperUserCustomerId());
        Assert.isTrue((surrogate != null ? 1 : 0) != 0, (String)("No surrogate found with email : " + emailSurrogate));
        dto.setSurrogateCustomerId(surrogate.getCustomerId());
        Optional optCustomer = this.customerRepository.findById((Object)surrogate.getCustomerId());
        Customer surrogateCustomer = (Customer)optCustomer.orElseThrow(() -> new ApplicationServerException("Unable to check users : customer not found"));
        Assert.isTrue((boolean)surrogate.isSubrogeable(), (String)" User is not subrogeable");
        Assert.isTrue((boolean)surrogateCustomer.isSubrogeable(), (String)" Customer is not subrogeable");
        Assert.isTrue((boolean)surrogate.getStatus().equals((Object)UserStatusEnum.ENABLED), (String)"User status is not enabled");
        Assert.isTrue((superUser != null ? 1 : 0) != 0, (String)("No superUser found with email : " + emailSuperUser));
        dto.setSuperUserCustomerId(superUser.getCustomerId());
        Assert.isTrue((!surrogate.getId().equals(superUser.getId()) ? 1 : 0) != 0, (String)("Users cannot subrogate itself, email : " + emailSuperUser));
        AuthUserDto currentUser = this.internalSecurityService.getUser();
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)emailSuperUser, (CharSequence)currentUser.getEmail()), (String)"Only super user can create subrogation");
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)dto.getSuperUserCustomerId(), (CharSequence)currentUser.getCustomerId()), (String)"Only super user can create subrogation");
        dto.setStatus(UserTypeEnum.GENERIC.equals((Object)surrogate.getType()) ? SubrogationStatusEnum.ACCEPTED : SubrogationStatusEnum.CREATED);
    }

    protected String getObjectName() {
        return "subrogation";
    }

    protected VitamUIRepository<Subrogation, String> getRepository() {
        return this.subrogationRepository;
    }

    protected void beforeDelete(String id) {
        Optional subrogation = this.subrogationRepository.findById((Object)id);
        if (subrogation.isPresent()) {
            String emailSuperUser = ((Subrogation)subrogation.get()).getSuperUser();
            String emailCurrentUser = this.internalSecurityService.getUser().getEmail();
            Assert.isTrue((boolean)emailSuperUser.equals(emailCurrentUser), (String)"Only super user can stop subrogation");
        }
    }

    public SubrogationDto accept(String id) {
        Optional optSubrogation = this.subrogationRepository.findById((Object)id);
        Subrogation subro = (Subrogation)optSubrogation.orElseThrow(() -> new IllegalArgumentException("Unable to accept subrogation: no subrogation found with id=" + id));
        AuthUserDto currentUser = this.internalSecurityService.getUser();
        Assert.isTrue((boolean)subro.getSurrogate().equals(currentUser.getEmail()), (String)("Users " + currentUser.getEmail() + " can't accept subrogation of " + subro.getSurrogate()));
        Assert.isTrue((boolean)subro.getSurrogateCustomerId().equals(currentUser.getCustomerId()), (String)("Users " + currentUser.getCustomerId() + " can't accept subrogation of " + subro.getSurrogate()));
        subro.setStatus(SubrogationStatusEnum.ACCEPTED);
        Date nowPlusXMinutes = DateUtils.addMinutes((Date)new Date(), (int)this.subrogationTtl);
        subro.setDate(nowPlusXMinutes);
        Subrogation createdSubro = (Subrogation)this.subrogationRepository.save((Object)subro);
        return (SubrogationDto)this.convertFromEntityToDto((BaseIdDocument)createdSubro);
    }

    @Transactional
    public void decline(String id) {
        Optional optSubrogation = this.subrogationRepository.findById((Object)id);
        Subrogation subro = (Subrogation)optSubrogation.orElseThrow(() -> new IllegalArgumentException("Unable to decline subrogation: no subrogation found with id=" + id));
        if (subro.getStatus().equals((Object)SubrogationStatusEnum.ACCEPTED)) {
            this.iamLogbookService.subrogation(subro, EventType.EXT_VITAMUI_STOP_SURROGATE);
        } else {
            this.iamLogbookService.subrogation(subro, EventType.EXT_VITAMUI_DECLINE_SURROGATE);
        }
        String emailCurrentUser = this.internalSecurityService.getUser().getEmail();
        Assert.isTrue((boolean)subro.getSurrogate().equals(emailCurrentUser), (String)("Users " + emailCurrentUser + " can't decline subrogation of " + subro.getSurrogate()));
        this.subrogationRepository.deleteById((Object)id);
    }

    protected Class<Subrogation> getEntityClass() {
        return Subrogation.class;
    }

    protected Converter<SubrogationDto, Subrogation> getConverter() {
        return this.subrogationConverter;
    }

    public PaginatedValuesDto<UserDto> getUsers(Integer page, Integer size, Optional<String> criteria, Optional<String> orderBy, Optional<DirectionDto> direction) {
        return this.userInternalService.getAllPaginatedByPassSecurity(page, size, criteria, orderBy, direction);
    }

    public GroupDto getGroupById(String id, Optional<String> embedded) {
        return (GroupDto)this.groupInternalService.getOneByPassSecurity(id, embedded);
    }

    @Generated
    public SubrogationRepository getSubrogationRepository() {
        return this.subrogationRepository;
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Generated
    public UserInternalService getUserInternalService() {
        return this.userInternalService;
    }

    @Generated
    public GroupInternalService getGroupInternalService() {
        return this.groupInternalService;
    }

    @Generated
    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    @Generated
    public ProfileRepository getProfilRepository() {
        return this.profilRepository;
    }

    @Generated
    public InternalSecurityService getInternalSecurityService() {
        return this.internalSecurityService;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public SubrogationConverter getSubrogationConverter() {
        return this.subrogationConverter;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public Integer getSubrogationTtl() {
        return this.subrogationTtl;
    }

    @Generated
    public Integer getGenericUsersSubrogationTtl() {
        return this.genericUsersSubrogationTtl;
    }

    @Generated
    public void setSubrogationRepository(SubrogationRepository subrogationRepository) {
        this.subrogationRepository = subrogationRepository;
    }

    @Generated
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Generated
    public void setUserInternalService(UserInternalService userInternalService) {
        this.userInternalService = userInternalService;
    }

    @Generated
    public void setGroupInternalService(GroupInternalService groupInternalService) {
        this.groupInternalService = groupInternalService;
    }

    @Generated
    public void setGroupRepository(GroupRepository groupRepository) {
        this.groupRepository = groupRepository;
    }

    @Generated
    public void setProfilRepository(ProfileRepository profilRepository) {
        this.profilRepository = profilRepository;
    }

    @Generated
    public void setInternalSecurityService(InternalSecurityService internalSecurityService) {
        this.internalSecurityService = internalSecurityService;
    }

    @Generated
    public void setCustomerRepository(CustomerRepository customerRepository) {
        this.customerRepository = customerRepository;
    }

    @Generated
    public void setSubrogationTtl(Integer subrogationTtl) {
        this.subrogationTtl = subrogationTtl;
    }

    @Generated
    public void setGenericUsersSubrogationTtl(Integer genericUsersSubrogationTtl) {
        this.genericUsersSubrogationTtl = genericUsersSubrogationTtl;
    }
}

