/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.subrogation.domain;

import fr.gouv.vitamui.commons.mongo.IdDocument;
import fr.gouv.vitamui.iam.common.enums.SubrogationStatusEnum;
import java.util.Date;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="subrogations")
@TypeAlias(value="subrogations")
public class Subrogation
extends IdDocument {
    @NotNull
    private SubrogationStatusEnum status;
    @NotNull
    @Indexed(name="idx_subrogation_date", background=true, expireAfterSeconds=0)
    private Date date;
    @NotNull
    @Length(min=4, max=100)
    @Email
    private @NotNull @Length(min=4, max=100) @Email String surrogate;
    @NotNull
    @Length(min=4, max=100)
    @Email
    @Indexed(name="idx_subrogation_superuser", background=true)
    private @NotNull @Length(min=4, max=100) @Email String superUser;
    @NotNull
    private String surrogateCustomerId;
    @NotNull
    private String superUserCustomerId;

    @Generated
    public SubrogationStatusEnum getStatus() {
        return this.status;
    }

    @Generated
    public Date getDate() {
        return this.date;
    }

    @Generated
    public String getSurrogate() {
        return this.surrogate;
    }

    @Generated
    public String getSuperUser() {
        return this.superUser;
    }

    @Generated
    public String getSurrogateCustomerId() {
        return this.surrogateCustomerId;
    }

    @Generated
    public String getSuperUserCustomerId() {
        return this.superUserCustomerId;
    }

    @Generated
    public void setStatus(SubrogationStatusEnum status) {
        this.status = status;
    }

    @Generated
    public void setDate(Date date) {
        this.date = date;
    }

    @Generated
    public void setSurrogate(String surrogate) {
        this.surrogate = surrogate;
    }

    @Generated
    public void setSuperUser(String superUser) {
        this.superUser = superUser;
    }

    @Generated
    public void setSurrogateCustomerId(String surrogateCustomerId) {
        this.surrogateCustomerId = surrogateCustomerId;
    }

    @Generated
    public void setSuperUserCustomerId(String superUserCustomerId) {
        this.superUserCustomerId = superUserCustomerId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Subrogation)) {
            return false;
        }
        Subrogation other = (Subrogation)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubrogationStatusEnum this$status = this.getStatus();
        SubrogationStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Date this$date = this.getDate();
        Date other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$surrogate = this.getSurrogate();
        String other$surrogate = other.getSurrogate();
        if (this$surrogate == null ? other$surrogate != null : !this$surrogate.equals(other$surrogate)) {
            return false;
        }
        String this$superUser = this.getSuperUser();
        String other$superUser = other.getSuperUser();
        if (this$superUser == null ? other$superUser != null : !this$superUser.equals(other$superUser)) {
            return false;
        }
        String this$surrogateCustomerId = this.getSurrogateCustomerId();
        String other$surrogateCustomerId = other.getSurrogateCustomerId();
        if (this$surrogateCustomerId == null ? other$surrogateCustomerId != null : !this$surrogateCustomerId.equals(other$surrogateCustomerId)) {
            return false;
        }
        String this$superUserCustomerId = this.getSuperUserCustomerId();
        String other$superUserCustomerId = other.getSuperUserCustomerId();
        return !(this$superUserCustomerId == null ? other$superUserCustomerId != null : !this$superUserCustomerId.equals(other$superUserCustomerId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Subrogation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SubrogationStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Date $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $surrogate = this.getSurrogate();
        result = result * 59 + ($surrogate == null ? 43 : $surrogate.hashCode());
        String $superUser = this.getSuperUser();
        result = result * 59 + ($superUser == null ? 43 : $superUser.hashCode());
        String $surrogateCustomerId = this.getSurrogateCustomerId();
        result = result * 59 + ($surrogateCustomerId == null ? 43 : $surrogateCustomerId.hashCode());
        String $superUserCustomerId = this.getSuperUserCustomerId();
        result = result * 59 + ($superUserCustomerId == null ? 43 : $superUserCustomerId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Subrogation(super=" + super.toString() + ", status=" + this.getStatus() + ", date=" + this.getDate() + ", surrogate=" + this.getSurrogate() + ", superUser=" + this.getSuperUser() + ", surrogateCustomerId=" + this.getSurrogateCustomerId() + ", superUserCustomerId=" + this.getSuperUserCustomerId() + ")";
    }
}

