/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.subrogation.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.internal.server.subrogation.domain.Subrogation;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.internal.server.user.domain.User;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;

public class SubrogationConverter
implements Converter<SubrogationDto, Subrogation> {
    public static final String SURROGATE_KEY = "surrogate";
    public static final String SUPER_USER_KEY = "superUser";
    private final UserRepository userRepository;

    public SubrogationConverter(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public String convertToLogbook(SubrogationDto dto) {
        HashMap<String, String> logbookData = new HashMap<String, String>();
        logbookData.put(SURROGATE_KEY, this.getUserId(dto.getSurrogate(), dto.getSurrogateCustomerId()));
        logbookData.put(SUPER_USER_KEY, this.getUserId(dto.getSuperUser(), dto.getSuperUserCustomerId()));
        return ApiUtils.toJson(logbookData);
    }

    private String getUserId(String email, String customerId) {
        User u = this.userRepository.findByEmailIgnoreCaseAndCustomerId(email, customerId);
        return u.getIdentifier();
    }

    public Subrogation convertDtoToEntity(SubrogationDto dto) {
        Subrogation entity = new Subrogation();
        VitamUIUtils.copyProperties((Object)dto, (Object)entity);
        Optional.ofNullable(dto).map(SubrogationDto::getDate).map(Date::from).ifPresent(arg_0 -> ((Subrogation)entity).setDate(arg_0));
        return entity;
    }

    public SubrogationDto convertEntityToDto(Subrogation entity) {
        SubrogationDto dto = new SubrogationDto();
        VitamUIUtils.copyProperties((Object)entity, (Object)dto);
        Optional.ofNullable(entity).map(Subrogation::getDate).map(Date::toInstant).ifPresent(arg_0 -> ((SubrogationDto)dto).setDate(arg_0));
        return dto;
    }
}

