/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.exception.NotImplementedException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInfoInternalService;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/userinfos"})
public class UserInfoInternalController
implements CrudController<UserInfoDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserInfoInternalController.class);
    private UserInfoInternalService userInfoInternalService;

    @Autowired
    public UserInfoInternalController(UserInfoInternalService userInfoInternalService) {
        this.userInfoInternalService = userInfoInternalService;
    }

    public ResponseEntity<Void> checkExist(String criteria) {
        throw new NotImplementedException("checkExist not supported");
    }

    @PostMapping
    public UserInfoDto create(@Valid @RequestBody UserInfoDto userInfoDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)userInfoDto);
        LOGGER.debug("Create {}", (Object)userInfoDto);
        return this.userInfoInternalService.create(userInfoDto);
    }

    public UserInfoDto update(String id, UserInfoDto dto) {
        throw new NotImplementedException("update not supported");
    }

    @GetMapping(value={"/{id}"})
    public UserInfoDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get {} criteria={}", (Object)id, criteria);
        return (UserInfoDto)this.userInfoInternalService.getOne(id, Optional.empty());
    }

    @GetMapping(value={"/me"})
    public UserInfoDto getMe() {
        LOGGER.debug("getMe {}");
        return this.userInfoInternalService.getMe();
    }

    @PatchMapping(value={"/{id}"})
    public UserInfoDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.userInfoInternalService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for user info with id :{}", (Object)id);
        return this.userInfoInternalService.findHistoryById(id);
    }

    @Generated
    public UserInfoInternalService getUserInfoInternalService() {
        return this.userInfoInternalService;
    }

    @Generated
    public void setUserInfoInternalService(UserInfoInternalService userInfoInternalService) {
        this.userInfoInternalService = userInfoInternalService;
    }
}

