/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.internal.server.tenant.service.TenantInternalService;
import io.swagger.annotations.Api;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/tenants"})
@Api(tags={"tenants"}, value="Tenants Management", description="Tenants Management")
public class TenantInternalController
implements CrudController<TenantDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(TenantInternalController.class);
    private TenantInternalService internalTenantService;

    @Autowired
    public TenantInternalController(TenantInternalService internalTenantService) {
        this.internalTenantService = internalTenantService;
    }

    @GetMapping
    public Collection<TenantDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("Get all criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.internalTenantService.getAll(criteria);
    }

    @GetMapping(value={"/{id}"})
    public TenantDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Get {}, criteria={}", (Object)id, criteria);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return (TenantDto)this.internalTenantService.getOne(id, criteria);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("checkExist criteria={}", (Object)criteria);
        boolean exist = this.internalTenantService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    public TenantDto create(@Valid @RequestBody TenantDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Create {}", (Object)dto);
        SanityChecker.sanitizeCriteria((Object)dto);
        return this.internalTenantService.create(dto);
    }

    @PutMapping(value={"/{id}"})
    public TenantDto update(@PathVariable(value="id") String id, @Valid @RequestBody TenantDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        return (TenantDto)this.internalTenantService.update((IdDto)dto);
    }

    @PatchMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    public TenantDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Patch tenant {} with {}", (Object)id, partialDto);
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"Unable to patch tenant : the DTO id must match the path id");
        return this.internalTenantService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        LOGGER.debug("get logbook for tenant with id :{}", (Object)id);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        return this.internalTenantService.findHistoryById(id);
    }

    @Generated
    public TenantInternalService getInternalTenantService() {
        return this.internalTenantService;
    }

    @Generated
    public void setInternalTenantService(TenantInternalService internalTenantService) {
        this.internalTenantService = internalTenantService;
    }
}

