/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.OwnerDto;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.internal.server.owner.service.OwnerInternalService;
import io.swagger.annotations.Api;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/owners"})
@Api(tags={"owners"}, value="Owners Management", description="Owners Management")
public class OwnerInternalController
implements CrudController<OwnerDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OwnerInternalController.class);
    @Autowired
    private OwnerInternalService internalOwnerService;

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        LOGGER.debug("Check exists by criteria {}", (Object)criteria);
        boolean exist = this.internalOwnerService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @GetMapping(value={"/{id}"})
    public OwnerDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Get one {} criteria={}", (Object)id, criteria);
        return (OwnerDto)this.internalOwnerService.getOne(id, criteria);
    }

    @PostMapping
    public OwnerDto create(@Valid @RequestBody OwnerDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Create {}", (Object)dto);
        return this.internalOwnerService.create(dto);
    }

    @PutMapping(value={"/{id}"})
    public OwnerDto update(@PathVariable(value="id") String id, @Valid @RequestBody OwnerDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        return (OwnerDto)this.internalOwnerService.update((IdDto)dto);
    }

    @PatchMapping(value={"/{id}"})
    public OwnerDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.internalOwnerService.patch(partialDto);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for owner with id :{}", (Object)id);
        return this.internalOwnerService.findHistoryById(id);
    }

    @Generated
    public OwnerInternalService getInternalOwnerService() {
        return this.internalOwnerService;
    }

    @Generated
    public void setInternalOwnerService(OwnerInternalService internalOwnerService) {
        this.internalOwnerService = internalOwnerService;
    }
}

