/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.TenantDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookLifeCycleResponseDto;
import fr.gouv.vitamui.commons.vitam.api.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.commons.vitam.api.util.VitamRestUtils;
import fr.gouv.vitamui.iam.internal.server.tenant.service.TenantInternalService;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@RestController
@RequestMapping(value={"/v1"})
@Api(tags={"logbooks"}, value="Logbooks Management", description="logbooks Management")
public class LogbookInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(LogbookInternalController.class);
    protected final InternalSecurityService securityService;
    private final LogbookService logbookService;
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";
    private final TenantInternalService tenantInternalService;

    @Autowired
    public LogbookInternalController(LogbookService logbookService, InternalSecurityService securityService, TenantInternalService tenantInternalService) {
        this.logbookService = logbookService;
        this.securityService = securityService;
        this.tenantInternalService = tenantInternalService;
    }

    @ApiOperation(value="Get log book operation by json select")
    @Secured(value={"ROLE_LOGBOOKS"})
    @PostMapping(value={"/logbooks/operations"})
    public LogbookOperationsResponseDto findOperations(@RequestHeader(required=true, value="X-Tenant-Id") Integer tenantId, @RequestBody JsonNode select, @RequestParam(required=false) Integer vitamTenantIdentifier) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeJson((JsonNode)select);
        SanityChecker.sanitizeCriteria((Object)select);
        VitamContext vitamContext = this.getRequestedVitamContext(tenantId, vitamTenantIdentifier);
        return (LogbookOperationsResponseDto)VitamRestUtils.responseMapping((JsonNode)this.logbookService.selectOperations(select, vitamContext).toJsonNode(), LogbookOperationsResponseDto.class);
    }

    @ApiOperation(value="Get log book operation by id")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/operations/{id}"})
    public LogbookOperationsResponseDto findOperationById(@RequestHeader(required=true, value="X-Tenant-Id") Integer tenantId, @RequestHeader(required=true, value="X-Access-Contract-Id") String accessContractId, @PathVariable String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, accessContractId});
        LOGGER.debug("Get log book operation by id : {} ", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        return (LogbookOperationsResponseDto)VitamRestUtils.responseMapping((JsonNode)this.logbookService.selectOperationbyId(id, vitamContext).toJsonNode(), LogbookOperationsResponseDto.class);
    }

    @ApiOperation(value="Get unit lifecycle by id")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/unitlifecycles/{id}"})
    public LogbookLifeCycleResponseDto findUnitLifeCyclesByUnitId(@RequestHeader(required=true, value="X-Tenant-Id") Integer tenantId, @RequestHeader(required=true, value="X-Access-Contract-Id") String accessContractId, @PathVariable String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, accessContractId});
        LOGGER.debug("Get unit lifecycle by id : {} ", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        return (LogbookLifeCycleResponseDto)VitamRestUtils.responseMapping((JsonNode)this.logbookService.findUnitLifeCyclesByUnitId(id, vitamContext).toJsonNode(), LogbookLifeCycleResponseDto.class);
    }

    @ApiOperation(value="Get object lifecycle by id")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/objectslifecycles/{id}"})
    public LogbookLifeCycleResponseDto findObjectGroupLifeCyclesByUnitId(@RequestHeader(required=true, value="X-Tenant-Id") Integer tenantId, @RequestHeader(required=true, value="X-Access-Contract-Id") String accessContractId, @PathVariable String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, accessContractId});
        LOGGER.debug("Get object lifecycle by id : {} ", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        return (LogbookLifeCycleResponseDto)VitamRestUtils.responseMapping((JsonNode)this.logbookService.findObjectGroupLifeCyclesByUnitId(id, vitamContext).toJsonNode(), LogbookLifeCycleResponseDto.class);
    }

    @ApiOperation(value="Download the manifest for a given operation")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/operations/{id}/download/manifest"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadManifest(@PathVariable String id, HttpServletResponse response, @RequestHeader(value="X-Tenant-Id", required=true) Integer tenantIdentifier) throws IOException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download the manifest for the following Vitam operation : {}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantIdentifier);
        try (Response vitamResponse = this.logbookService.downloadManifest(id, vitamContext);){
            VitamRestUtils.writeFileResponse((Response)vitamResponse, (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="Download the ATR for a given operation")
    @Secured(value={"ROLE_LOGBOOKS"})
    @GetMapping(value={"/logbooks/operations/{id}/download/atr"})
    @ResponseStatus(value=HttpStatus.OK)
    public void downloadAtr(@PathVariable String id, HttpServletResponse response, @RequestHeader(value="X-Tenant-Id", required=true) Integer tenantIdentifier) throws IOException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Download the ATR file for the following Vitam operation : {}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantIdentifier);
        try (Response vitamResponse = this.logbookService.downloadAtr(id, vitamContext);){
            VitamRestUtils.writeFileResponse((Response)vitamResponse, (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="Download the report file for a given operation")
    @GetMapping(value={"/logbooks/operations/{id}/download/{downloadType}"}, produces={"application/octet-stream"})
    @Secured(value={"ROLE_LOGBOOKS"})
    @ResponseStatus(value=HttpStatus.OK)
    public Mono<ResponseEntity<Resource>> downloadReport(@RequestHeader(required=true, value="X-Tenant-Id") Integer tenantId, @RequestHeader(required=true, value="X-Access-Contract-Id") String accessContractId, @PathVariable String id, @PathVariable String downloadType, HttpServletResponse response) throws VitamClientException, IOException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, downloadType, accessContractId});
        LOGGER.debug("Download the report file for the Vitam operation : {} with download type : {}", (Object)id, (Object)downloadType);
        LOGGER.debug("Access Contract {} ", (Object)accessContractId);
        ParameterChecker.checkParameter((String)"The identifier, the accessContract Id  are mandatory parameters: ", (String[])new String[]{id, accessContractId});
        VitamContext vitamContext = this.getVitamContext(tenantId, accessContractId);
        Mono resourceMono = Mono.fromCallable(() -> {
            Response vitamResponse = this.logbookService.downloadReport(id, downloadType, vitamContext);
            return new InputStreamResource((InputStream)vitamResponse.getEntity());
        });
        return resourceMono.subscribeOn(Schedulers.boundedElastic()).flatMap(resource -> Mono.just((Object)((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noCache())).body(resource)));
    }

    private VitamContext getVitamContext(Integer tenantId, String accessContractId) {
        VitamContext vitamContext = accessContractId != null ? this.securityService.buildVitamContext(tenantId, accessContractId) : this.securityService.buildVitamContext(tenantId);
        return vitamContext;
    }

    private VitamContext getRequestedVitamContext(Integer headerTenantIdentifier, Integer requestedVitamTenantIdentifier) {
        if (Objects.nonNull(requestedVitamTenantIdentifier)) {
            TenantDto requestedTenant = this.tenantInternalService.findByIdentifier(requestedVitamTenantIdentifier);
            if (Objects.isNull(requestedTenant)) {
                throw new BadRequestException(String.format("Tenant not found with identifier : '%d'", requestedVitamTenantIdentifier));
            }
            return this.securityService.buildVitamContext(requestedVitamTenantIdentifier);
        }
        return this.securityService.buildVitamContext(headerTenantIdentifier);
    }
}

