/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.iam.common.dto.IdentityProviderDto;
import fr.gouv.vitamui.iam.common.dto.common.ProviderEmbeddedOptions;
import fr.gouv.vitamui.iam.internal.server.idp.service.IdentityProviderInternalService;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/providers"})
@Api(tags={"identityproviders"}, value="Identity Providers Management", description="Identity Providers Management")
public class IdentityProviderInternalController
implements CrudController<IdentityProviderDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IdentityProviderInternalController.class);
    @Autowired
    private IdentityProviderInternalService internalIdentityProviderService;

    @GetMapping
    public List<IdentityProviderDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        LOGGER.debug("Get all criteria={}, embedded={}", criteria, embedded);
        EnumUtils.checkValidEnum(ProviderEmbeddedOptions.class, embedded);
        return this.internalIdentityProviderService.getAll(criteria, embedded);
    }

    @GetMapping(value={"/{id}"})
    public IdentityProviderDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria, @RequestParam Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(ProviderEmbeddedOptions.class, embedded);
        LOGGER.debug("Get {} criteria={} embedded={}", new Object[]{id, criteria, embedded});
        return this.internalIdentityProviderService.getOne(id, criteria, embedded);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(String criteria) {
        throw new UnsupportedOperationException("checkExist not implemented");
    }

    @PostMapping
    public IdentityProviderDto create(@Valid @RequestBody IdentityProviderDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Create {}", (Object)dto);
        return this.internalIdentityProviderService.create(dto);
    }

    public IdentityProviderDto update(@PathVariable(value="id") String id, @Valid @RequestBody IdentityProviderDto dto) {
        throw new UnsupportedOperationException("update not implemented");
    }

    @PatchMapping(value={"/{id}"})
    public IdentityProviderDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Patch {}", (Object)id, partialDto);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.internalIdentityProviderService.patch(partialDto);
    }

    @Generated
    public IdentityProviderInternalService getInternalIdentityProviderService() {
        return this.internalIdentityProviderService;
    }

    @Generated
    public void setInternalIdentityProviderService(IdentityProviderInternalService internalIdentityProviderService) {
        this.internalIdentityProviderService = internalIdentityProviderService;
    }
}

