/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParamProfileDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.internal.server.externalparamprofile.service.ExternalParamProfileInternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/externalparamprofile"})
@Api(tags={"externalparamprofile"}, value="Access Contract External Parameters Profile")
public class ExternalParamProfileInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ExternalParamProfileInternalController.class);
    private final ExternalParamProfileInternalService externalParamProfileInternalService;

    @Autowired
    public ExternalParamProfileInternalController(ExternalParamProfileInternalService externalParamProfileInternalService) {
        this.externalParamProfileInternalService = externalParamProfileInternalService;
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<ExternalParamProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction, @RequestParam(required=false) Optional<String> embedded) throws InvalidParseOperationException, PreconditionFailedException {
        String orderByValue = orderBy.orElse(null);
        DirectionDto directionValue = direction.orElse(null);
        String criteriaValue = criteria.orElse(null);
        LOGGER.debug("getAllPaginated page={}, size={}, criteria={}, orderBy={}, ascendant={}, embedded = {}", new Object[]{page, size, criteriaValue, orderByValue, directionValue});
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(size), String.valueOf(page)});
        return this.externalParamProfileInternalService.getAllPaginated(page, size, criteriaValue, orderByValue, directionValue);
    }

    @GetMapping(value={"/{id}"})
    public ExternalParamProfileDto getOne(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("GetMyExternalParameters");
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.externalParamProfileInternalService.getOne(id);
    }

    @ApiOperation(value="Create external parameter profile")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public ExternalParamProfileDto create(@RequestBody ExternalParamProfileDto entityDto) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.sanitizeCriteria((Object)entityDto);
        LOGGER.debug("create class={}", (Object)entityDto.getClass().getName());
        return this.externalParamProfileInternalService.create(entityDto);
    }

    @ApiOperation(value="get history by external parameter profile profile's id")
    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for external parameter profile with id :{}", (Object)id);
        return this.externalParamProfileInternalService.findHistoryById(id);
    }

    @PatchMapping(value={"/{id}"})
    public ExternalParamProfileDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) throws InvalidParseOperationException, PreconditionFailedException, BadRequestException {
        ParameterChecker.checkParameter((String)"Identifier is mandatory : ", (String[])new String[]{id});
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria(partialDto);
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        return this.externalParamProfileInternalService.patch(partialDto);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        ParameterChecker.checkParameter((String)"criteria is mandatory : ", (String[])new String[]{criteria});
        LOGGER.debug("checkExist criteria={}", (Object)criteria);
        boolean exist = this.externalParamProfileInternalService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }
}

