/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.CrudController;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.common.dto.CustomerCreationFormData;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.CustomerPatchFormData;
import fr.gouv.vitamui.iam.common.utils.CustomerDtoEditor;
import fr.gouv.vitamui.iam.common.utils.MapEditor;
import fr.gouv.vitamui.iam.internal.server.customer.service.CustomerInternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/customers"})
@Api(tags={"customers"}, value="Customers Management", description="Customers Management")
public class CustomerInternalController
implements CrudController<CustomerDto> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CustomerInternalController.class);
    private CustomerInternalService internalCustomerService;

    @Autowired
    public CustomerInternalController(CustomerInternalService internalCustomerService) {
        this.internalCustomerService = internalCustomerService;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(CustomerDto.class, (PropertyEditor)new CustomerDtoEditor());
        binder.registerCustomEditor(Map.class, (PropertyEditor)new MapEditor());
    }

    @GetMapping
    public Collection<CustomerDto> getAll(Optional<String> criteria) {
        LOGGER.debug("Get all with criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        return this.internalCustomerService.getAll(criteria);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<CustomerDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, orderBy, direction});
        SanityChecker.sanitizeCriteria(criteria);
        if (direction.isPresent()) {
            SanityChecker.sanitizeCriteria((Object)direction.get());
        }
        SanityChecker.checkSecureParameter((String[])new String[]{String.valueOf(page), String.valueOf(size)});
        return this.internalCustomerService.getAllPaginated(page, size, criteria, orderBy, direction);
    }

    @GetMapping(value={"/{id}"})
    public CustomerDto getOne(@PathVariable(value="id") String id, @RequestParam Optional<String> criteria) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Get One {}, criteria={}", (Object)id, criteria);
        ParameterChecker.checkParameter((String)"The identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.sanitizeCriteria(criteria);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return (CustomerDto)this.internalCustomerService.getOne(id, criteria);
    }

    @RequestMapping(path={"/check"}, method={RequestMethod.HEAD})
    public ResponseEntity<Void> checkExist(@RequestParam String criteria) {
        LOGGER.debug("check exist criteria={}", (Object)criteria);
        SanityChecker.sanitizeCriteria(Optional.of(criteria));
        boolean exist = this.internalCustomerService.checkExist(criteria);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @GetMapping(path={"/me"})
    public CustomerDto getMyCustomer() {
        LOGGER.debug("Get MyCustomer");
        return this.internalCustomerService.getMyCustomer();
    }

    @PutMapping(value={"/{id}"})
    public CustomerDto update(@PathVariable(value="id") String id, @Valid @RequestBody CustomerDto dto) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Update {} with {}", (Object)id, (Object)dto);
        ParameterChecker.checkParameter((String)"The identifier is mandatory : ", (String[])new String[]{id});
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)dto.getId()), (String)"The DTO identifier must match the path identifier for update.");
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)dto);
        return this.internalCustomerService.update(dto);
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public CustomerDto create(@ModelAttribute CustomerCreationFormData customerData) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Create {}", (Object)customerData);
        SanityChecker.sanitizeCriteria((Object)customerData);
        return this.internalCustomerService.create(customerData);
    }

    @PatchMapping(value={"/{id}"})
    public CustomerDto patch(@PathVariable(value="id") String id, @ModelAttribute CustomerPatchFormData customerData) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Patch customer {}", (Object)customerData);
        ParameterChecker.checkParameter((String)"The identifier is mandatory : ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        SanityChecker.sanitizeCriteria((Object)customerData.getPartialCustomerDto());
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)customerData.getPartialCustomerDto().get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.internalCustomerService.patch(customerData);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException, InvalidParseOperationException {
        LOGGER.debug("get logbook for customer with id :{}", (Object)id);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.internalCustomerService.findHistoryById(id);
    }

    public CustomerDto create(@Valid @RequestBody CustomerDto dto) {
        throw new NotImplementedException("Method is not implemented");
    }

    @ApiOperation(value="Get entity logo")
    @GetMapping(value={"/{id}/logo"})
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Resource> getLogo(@PathVariable String id, @RequestParam(value="type") AttachmentType type) throws InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("get logo for customer with id :{}, type : {}", (Object)id, (Object)type);
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        return this.internalCustomerService.getLogo(id, type);
    }

    @GetMapping(path={"/gdpr-status"})
    public boolean getGdprSettingStatus() {
        LOGGER.debug("Get Gdpr Setting Status");
        return this.internalCustomerService.getGdprSettingStatus();
    }

    @Generated
    public CustomerInternalService getInternalCustomerService() {
        return this.internalCustomerService;
    }

    @Generated
    public void setInternalCustomerService(CustomerInternalService internalCustomerService) {
        this.internalCustomerService = internalCustomerService;
    }
}

