/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.UserDto;
import fr.gouv.vitamui.commons.api.enums.UserStatusEnum;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.exception.TooManyRequestsException;
import fr.gouv.vitamui.commons.api.exception.UnAuthorizedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.SubrogationDto;
import fr.gouv.vitamui.iam.common.dto.cas.LoginRequestDto;
import fr.gouv.vitamui.iam.internal.server.cas.service.CasInternalService;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.user.domain.User;
import fr.gouv.vitamui.iam.internal.server.user.service.UserInternalService;
import io.swagger.annotations.Api;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/cas"})
@Api(tags={"cas"}, value="User authentication management for CAS", description="User authentication management for CAS")
public class CasInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CasInternalController.class);
    @Value(value="${login.attempts.maximum.failures}")
    @NotNull
    private Integer maximumFailuresForLoginAttempts;
    @Autowired
    private IamLogbookService iamLogbookService;
    private final CasInternalService casService;
    private final PasswordEncoder passwordEncoder;
    private final UserInternalService internalUserService;

    @Autowired
    public CasInternalController(CasInternalService casService, PasswordEncoder passwordEncoder, UserInternalService internalUserService) {
        this.casService = casService;
        this.passwordEncoder = passwordEncoder;
        this.internalUserService = internalUserService;
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<UserDto> login(@Valid @RequestBody LoginRequestDto dto) {
        boolean passwordMatch;
        String username = dto.getLoginEmail();
        User user = this.casService.findUserByEmailAndCustomerId(dto.getLoginEmail(), dto.getLoginCustomerId());
        UserStatusEnum oldStatus = user.getStatus();
        String password = user.getPassword();
        int nbFailedAttemps = user.getNbFailedAttempts();
        OffsetDateTime lastConnection = user.getLastConnection();
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime nowLess20Minutes = now.plusMinutes(-this.casService.getTimeIntervalForLoginAttempts().intValue());
        if (lastConnection != null && lastConnection.isBefore(nowLess20Minutes)) {
            LOGGER.debug("reset nbFailedAttemps");
            nbFailedAttemps = 0;
        }
        if (!(passwordMatch = this.passwordEncoder.matches((CharSequence)dto.getPassword(), password))) {
            ++nbFailedAttemps;
        } else if (nbFailedAttemps < this.maximumFailuresForLoginAttempts) {
            nbFailedAttemps = 0;
        }
        user.setNbFailedAttempts(nbFailedAttemps);
        user.setLastConnection(now);
        if (nbFailedAttemps >= this.maximumFailuresForLoginAttempts) {
            user.setStatus(UserStatusEnum.BLOCKED);
        } else if (user.getStatus() == UserStatusEnum.BLOCKED) {
            user.setStatus(UserStatusEnum.ENABLED);
        }
        this.casService.updateNbFailedAttempsPlusLastConnectionAndStatus(user, nbFailedAttemps, oldStatus);
        LOGGER.debug("username: {} -> passwordMatch: {} / nbFailedAttemps: {}", new Object[]{username, passwordMatch, nbFailedAttemps});
        if (nbFailedAttemps >= this.maximumFailuresForLoginAttempts) {
            String message = "Too many login attempts for username: " + username;
            this.iamLogbookService.loginEvent(user, this.findSurrogateDescriptionStringForLogging(dto), dto.getIp(), message);
            throw new TooManyRequestsException(message);
        }
        if (passwordMatch) {
            UserDto userDto = this.internalUserService.internalConvertFromEntityToDto(user);
            this.iamLogbookService.loginEvent(user, this.findSurrogateDescriptionStringForLogging(dto), dto.getIp(), null);
            return new ResponseEntity((Object)userDto, HttpStatus.OK);
        }
        String message = "Bad credentials for username: " + username;
        this.iamLogbookService.loginEvent(user, this.findSurrogateDescriptionStringForLogging(dto), dto.getIp(), message);
        throw new UnAuthorizedException(message);
    }

    private String findSurrogateDescriptionStringForLogging(LoginRequestDto loginRequest) {
        String surrogate = loginRequest.getSurrogateEmail();
        String surrogateCustomerId = loginRequest.getSurrogateCustomerId();
        if (surrogate != null) {
            try {
                return this.internalUserService.findUserByEmailAndCustomerId(surrogate, surrogateCustomerId).getIdentifier();
            }
            catch (NotFoundException e) {
                return "User not found: " + surrogate + " and customerId " + surrogateCustomerId;
            }
        }
        return null;
    }

    @PostMapping(value={"/password/change"})
    @ResponseBody
    public String changePassword(@RequestHeader(defaultValue="") String username, @RequestHeader(defaultValue="") String password, @RequestHeader(defaultValue="") String customerId) {
        LOGGER.debug("changePassword for username: {} / password_exists? {}, customerId {} ", new Object[]{username, StringUtils.isNotBlank((CharSequence)password), customerId});
        this.casService.updatePassword(username, password, customerId);
        return "true";
    }

    @GetMapping(value={"/users"}, params={"email"})
    public List<UserDto> getUsersByEmail(@RequestParam String email, @RequestParam(required=false) String embedded) {
        LOGGER.debug("getUserByEmail: {}", (Object)email);
        ParameterChecker.checkParameter((String)"user email is mandatory : ", (String[])new String[]{email});
        return this.casService.getUsersByEmail(email, embedded);
    }

    @GetMapping(value={"/users/provisioning"}, params={"loginEmail", "loginCustomerId"})
    public UserDto getUser(@RequestParam String loginEmail, @RequestParam String loginCustomerId, @RequestParam String idp, @RequestParam(required=false) String userIdentifier, @RequestParam(required=false) String embedded) throws InvalidParseOperationException {
        SanityChecker.checkSecureParameter((String[])new String[]{idp, loginEmail, loginCustomerId});
        if (userIdentifier != null) {
            SanityChecker.checkSecureParameter((String[])new String[]{userIdentifier});
        }
        LOGGER.debug("getUser - email : {}, customerId : {}, idp : {}, userIdentifier : {}, embedded options : {}", new Object[]{loginEmail, loginCustomerId, idp, userIdentifier, embedded});
        return this.casService.getUser(loginEmail, loginCustomerId, idp, userIdentifier, embedded);
    }

    @GetMapping(value={"/users"}, params={"id"})
    public UserDto getUserById(@RequestParam String id) {
        LOGGER.debug("getUserById: {}", (Object)id);
        return this.casService.getUserProfileById(id);
    }

    @GetMapping(value={"/subrogations"}, params={"superUserEmail", "superUserCustomerId"})
    public List<SubrogationDto> getSubrogationsBySuperUserEmailAndCustomerId(@RequestParam String superUserEmail, @RequestParam String superUserCustomerId) {
        LOGGER.debug("getMySubrogationAsSuperuser: {} / {}", (Object)superUserEmail, (Object)superUserCustomerId);
        ParameterChecker.checkParameter((String)"super user email is mandatory : ", (String[])new String[]{superUserEmail});
        ParameterChecker.checkParameter((String)"super user customerId is mandatory : ", (String[])new String[]{superUserCustomerId});
        return this.casService.getSubrogationsBySuperUser(superUserEmail, superUserCustomerId);
    }

    @GetMapping(value={"/subrogations"}, params={"superUserId"})
    public List<SubrogationDto> getSubrogationsBySuperUserId(@RequestParam String superUserId) {
        LOGGER.debug("findBySuperUserId: {}", (Object)superUserId);
        ParameterChecker.checkParameter((String)"super user identifier is mandatory : ", (String[])new String[]{superUserId});
        UserDto user = (UserDto)this.internalUserService.getOne(superUserId, Optional.empty());
        if (user != null && user.getStatus() == UserStatusEnum.ENABLED) {
            String email = user.getEmail();
            String customerId = user.getCustomerId();
            LOGGER.debug("-> email: {}, customerId: {}", (Object)email, (Object)customerId);
            return this.casService.getSubrogationsBySuperUser(email, customerId);
        }
        return new ArrayList<SubrogationDto>();
    }

    @GetMapping(value={"/customers"})
    public List<CustomerDto> getCustomersByIds(@RequestParam List<String> customerIds) {
        LOGGER.debug("getUserByEmail: {}", customerIds);
        ParameterChecker.checkParameter((String)"CustomerIds are mandatory : ", (Object[])new Object[]{customerIds});
        return this.casService.getCustomersByIds(customerIds);
    }

    @GetMapping(value={"/logout"})
    @ResponseStatus(value=HttpStatus.OK)
    public void logout(@RequestParam String authToken, @RequestParam String superUser, @RequestParam String superUserCustomerId) {
        LOGGER.debug("logout: authToken={}, superUser={}, superUserCustomerId={}", new Object[]{authToken, superUser, superUserCustomerId});
        ParameterChecker.checkParameter((String)"The arguments authToken is mandatory : ", (String[])new String[]{authToken});
        CasInternalService.PrincipalFromToken principal = this.casService.removeTokenAndGetPrincipal(authToken);
        if (null != principal && StringUtils.isNotBlank((CharSequence)superUser)) {
            this.casService.deleteSubrogationBySuperUserAndSurrogate(superUser, superUserCustomerId, principal.getEmail(), principal.getCustomerId());
        }
    }

    @Generated
    public void setMaximumFailuresForLoginAttempts(Integer maximumFailuresForLoginAttempts) {
        this.maximumFailuresForLoginAttempts = maximumFailuresForLoginAttempts;
    }

    @Generated
    public void setIamLogbookService(IamLogbookService iamLogbookService) {
        this.iamLogbookService = iamLogbookService;
    }
}

