/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.ApplicationDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.EnumUtils;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.internal.server.application.service.ApplicationInternalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iam/v1/applications"})
@Api(tags={"applications"}, value="Applications Management", description="Applications Management")
public class ApplicationInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ApplicationInternalController.class);
    private ApplicationInternalService internalApplicationService;

    @Autowired
    public ApplicationInternalController(ApplicationInternalService internalApplicationService) {
        this.internalApplicationService = internalApplicationService;
    }

    @GetMapping
    public Collection<ApplicationDto> getAll(Optional<String> criteria, @RequestParam Optional<String> embedded) {
        LOGGER.debug("Get all with criteria={}, embedded={}", criteria, embedded);
        SanityChecker.sanitizeCriteria(criteria);
        EnumUtils.checkValidEnum(EmbeddedOptions.class, embedded);
        return this.internalApplicationService.getAll(criteria, embedded);
    }

    @GetMapping(path={"/{identifier}/externalid"})
    @ApiOperation(value="Check if an application can have an external identifier")
    public boolean isApplicationExternalIdentifierEnabled(@PathVariable(value="identifier") String applicationId) {
        return this.internalApplicationService.isApplicationExternalIdentifierEnabled(applicationId);
    }

    @Generated
    public ApplicationInternalService getInternalApplicationService() {
        return this.internalApplicationService;
    }

    @Generated
    public void setInternalApplicationService(ApplicationInternalService internalApplicationService) {
        this.internalApplicationService = internalApplicationService;
    }
}

