/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.domain.AccessContractsDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.administration.AccessContractService;
import fr.gouv.vitamui.iam.common.dto.AccessContractsResponseDto;
import fr.gouv.vitamui.iam.common.dto.AccessContractsVitamDto;
import fr.gouv.vitamui.iam.internal.server.common.converter.AccessContractConverter;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import io.swagger.annotations.Api;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
@Api(tags={"accesscontracts"}, value="Access contacts", description="Access contracts Management")
public class AccessContractInternalController {
    static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AccessContractInternalController.class);
    protected final InternalSecurityService securityService;
    private final AccessContractService accessContractService;
    private final ObjectMapper objectMapper;
    private final AccessContractConverter converter;

    @Autowired
    public AccessContractInternalController(InternalSecurityService securityService, AccessContractService accessContractService, AccessContractConverter converter, ObjectMapper objectMapper) {
        this.securityService = securityService;
        this.accessContractService = accessContractService;
        this.objectMapper = objectMapper;
        this.converter = converter;
    }

    @GetMapping(value={"/accesscontracts"})
    public List<AccessContractsDto> getAll() {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        try {
            RequestResponse requestResponse = this.accessContractService.findAccessContracts(vitamContext, (JsonNode)new Select().getFinalSelect());
            AccessContractsResponseDto accessContractResponseDto = (AccessContractsResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractsResponseDto.class);
            return this.converter.convertVitamsToDtos(accessContractResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Access Contrats", e);
        }
    }

    @GetMapping(path={"/accesscontracts/{identifier:.+}"})
    public AccessContractsDto getAccessContractById(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get accessContract identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        try {
            LOGGER.info("Access Contract EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.accessContractService.findAccessContractById(vitamContext, identifier);
            AccessContractsResponseDto accessContractResponseDto = (AccessContractsResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AccessContractsResponseDto.class);
            if (accessContractResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((AccessContractsVitamDto)accessContractResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Access Contrat", e);
        }
    }
}

