/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.profile.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.BaseIdDocument;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.domain.Role;
import fr.gouv.vitamui.commons.api.domain.ServicesData;
import fr.gouv.vitamui.commons.api.exception.NotFoundException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.api.utils.CastUtils;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.mongo.IdDocument;
import fr.gouv.vitamui.commons.mongo.service.SequenceGeneratorService;
import fr.gouv.vitamui.commons.mongo.service.VitamUICrudService;
import fr.gouv.vitamui.commons.mongo.utils.MongoUtils;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.iam.common.dto.common.EmbeddedOptions;
import fr.gouv.vitamui.iam.internal.server.customer.config.CustomerInitConfig;
import fr.gouv.vitamui.iam.internal.server.customer.dao.CustomerRepository;
import fr.gouv.vitamui.iam.internal.server.customer.domain.Customer;
import fr.gouv.vitamui.iam.internal.server.group.dao.GroupRepository;
import fr.gouv.vitamui.iam.internal.server.group.domain.Group;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.profile.converter.ProfileConverter;
import fr.gouv.vitamui.iam.internal.server.profile.dao.ProfileRepository;
import fr.gouv.vitamui.iam.internal.server.profile.domain.Profile;
import fr.gouv.vitamui.iam.internal.server.tenant.dao.TenantRepository;
import fr.gouv.vitamui.iam.internal.server.tenant.domain.Tenant;
import fr.gouv.vitamui.iam.internal.server.user.dao.UserRepository;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class ProfileInternalService
extends VitamUICrudService<ProfileDto, Profile> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProfileInternalService.class);
    private final ProfileRepository profileRepository;
    private final CustomerRepository customerRepository;
    private final GroupRepository groupRepository;
    private final TenantRepository tenantRepository;
    private final UserRepository userRepository;
    private final InternalSecurityService internalSecurityService;
    private final IamLogbookService iamLogbookService;
    private final ProfileConverter profileConverter;
    private LogbookService logbookService;

    @Autowired
    public ProfileInternalService(SequenceGeneratorService sequenceGeneratorService, ProfileRepository profileRepository, CustomerRepository customerRepository, GroupRepository groupRepository, TenantRepository tenantRepository, UserRepository userRepository, InternalSecurityService internalSecurityService, IamLogbookService iamLogbookService, ProfileConverter profileConverter, LogbookService logbookService) {
        super(sequenceGeneratorService);
        this.profileRepository = profileRepository;
        this.customerRepository = customerRepository;
        this.groupRepository = groupRepository;
        this.tenantRepository = tenantRepository;
        this.userRepository = userRepository;
        this.internalSecurityService = internalSecurityService;
        this.iamLogbookService = iamLogbookService;
        this.profileConverter = profileConverter;
        this.logbookService = logbookService;
    }

    public List<ProfileDto> getAll(Optional<String> criteria, Optional<String> embedded) {
        return super.getAll(criteria, embedded);
    }

    public PaginatedValuesDto<ProfileDto> getAllPaginated(Integer page, Integer size, Optional<String> criteriaJsonString, Optional<String> orderBy, Optional<DirectionDto> direction, Optional<String> embedded) {
        return super.getAllPaginated(page, size, criteriaJsonString, orderBy, direction, embedded);
    }

    public ProfileDto getOne(String id, Optional<String> criteria, Optional<String> embedded) {
        return (ProfileDto)super.getOne(id, criteria, embedded);
    }

    protected void loadExtraInformation(ProfileDto dto, Optional<String> optEmbedded) {
        if (optEmbedded.isPresent()) {
            String embedded = optEmbedded.get();
            if (EmbeddedOptions.ALL.toString().equalsIgnoreCase(embedded)) {
                Tenant tenant = Optional.ofNullable(this.tenantRepository.findByIdentifier(dto.getTenantIdentifier())).orElseThrow(() -> new NotFoundException("Unable to find the following tenant: " + dto.getTenantIdentifier()));
                dto.setTenantName(tenant.getName());
                Collection groups = this.getGroupsByProfileIds(dto.getId());
                List groupIds = groups.stream().map(IdDocument::getId).collect(Collectors.toList());
                long usersCount = this.userRepository.countByGroupIdIn(groupIds);
                dto.setUsersCount(Long.valueOf(usersCount));
                dto.setGroupsCount(Long.valueOf(groups.size()));
            }
        }
    }

    protected void beforeCreate(ProfileDto dto) {
        String message = "Unable to create profile " + dto.getName();
        this.checkSetReadonly(dto.isReadonly(), message);
        this.checkCustomer(dto.getCustomerId(), message);
        this.checkName(dto.getName(), dto.getTenantIdentifier(), dto.getLevel(), dto.getApplicationName(), message);
        this.checkLevel(dto.getLevel(), message);
        this.checkTenant(dto.getTenantIdentifier(), message);
        this.checkRoles(dto.getRoles(), dto.getLevel(), message);
        super.checkIdentifier(dto.getIdentifier(), message);
        dto.setId(this.generateSuperId());
        dto.setIdentifier(this.getNextSequenceId("profileIdentifier"));
    }

    @Transactional
    public ProfileDto create(ProfileDto dto) {
        ProfileDto createdProfile = (ProfileDto)super.create((IdDto)dto);
        if (dto != null && createdProfile != null) {
            createdProfile.setExternalParamId(dto.getExternalParamId());
            createdProfile.setExternalParamIdentifier(dto.getExternalParamIdentifier());
        }
        this.iamLogbookService.createProfileEvent(createdProfile);
        return createdProfile;
    }

    protected void beforeUpdate(ProfileDto dto) {
    }

    protected Profile beforePatch(Map<String, Object> partialDto) {
        Boolean enabled;
        String name;
        List roleEntries;
        Boolean readonly;
        String id = CastUtils.toString((Object)partialDto.get("id"));
        String message = "Unable to patch profile " + id;
        Assert.isTrue((!this.checkMapContainsOnlyFieldsUnmodifiable(partialDto, Arrays.asList("id", "readonly", "identifier", "customerId", "applicationName", "tenantIdentifier")) ? 1 : 0) != 0, (String)message);
        ProfileDto profileDto = this.getOne(id, Optional.empty(), Optional.empty());
        String customerId = CastUtils.toString((Object)partialDto.get("customerId"));
        Integer tenantIdentifier = CastUtils.toInteger((Object)partialDto.get("tenantIdentifier"));
        Profile profile = this.find(id, customerId, tenantIdentifier, message);
        this.checkCustomer(profile.getCustomerId(), message);
        this.checkLevel(profile.getLevel(), message);
        this.checkIsReadonly(profile.isReadonly(), message);
        String level = CastUtils.toString((Object)partialDto.get("level"));
        if (level != null) {
            this.checkLevel(level, message);
            this.checkModifyLevel(profile, level, message);
        }
        if ((readonly = CastUtils.toBoolean((Object)partialDto.get("readonly"))) != null) {
            this.checkSetReadonly(readonly.booleanValue(), message);
        }
        if ((roleEntries = CastUtils.toList((Object)partialDto.get("roles"))) != null) {
            String checkedLevel = StringUtils.isEmpty((CharSequence)level) ? profileDto.getLevel() : level;
            List roles = roleEntries.stream().map(arg_0 -> this.convertToRole(arg_0)).collect(Collectors.toList());
            this.checkRoles(roles, checkedLevel, message);
        }
        if ((name = CastUtils.toString((Object)partialDto.get("name"))) != null || level != null) {
            name = name == null ? profile.getName() : name;
            level = level == null ? profile.getLevel() : level;
            this.checkName(name, profile.getTenantIdentifier(), level, profile.getApplicationName(), message);
        }
        if ((enabled = CastUtils.toBoolean((Object)partialDto.get("enabled"))) != null) {
            this.checkEnabled(profile.getId(), enabled.booleanValue(), message);
        }
        return profile;
    }

    protected void processPatch(Profile profile, Map<String, Object> partialDto) {
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        block23: for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            switch (entry.getKey()) {
                case "id": 
                case "customerId": 
                case "readonly": 
                case "applicationName": 
                case "tenantIdentifier": 
                case "identifier": {
                    continue block23;
                }
                case "name": {
                    logbooks.add(new EventDiffDto("Nom", (Object)profile.getName(), entry.getValue()));
                    profile.setName(CastUtils.toString((Object)entry.getValue()));
                    continue block23;
                }
                case "description": {
                    logbooks.add(new EventDiffDto("Description", (Object)profile.getDescription(), entry.getValue()));
                    profile.setDescription(CastUtils.toString((Object)entry.getValue()));
                    continue block23;
                }
                case "enabled": {
                    logbooks.add(new EventDiffDto("Activ\u00e9", (Object)profile.isEnabled(), entry.getValue()));
                    profile.setEnabled(CastUtils.toBoolean((Object)entry.getValue()).booleanValue());
                    continue block23;
                }
                case "level": {
                    logbooks.add(new EventDiffDto("Niveau", (Object)profile.getDescription(), entry.getValue()));
                    profile.setLevel(CastUtils.toString((Object)entry.getValue()));
                    continue block23;
                }
                case "roles": {
                    List roleEntries = CastUtils.toList((Object)entry.getValue());
                    List roles = roleEntries.stream().map(arg_0 -> this.convertToRole(arg_0)).collect(Collectors.toList());
                    logbooks.add(new EventDiffDto("Liste des r\u00f4les", (Object)this.profileConverter.convertRoleToLogbook((Collection)profile.getRoles()), (Object)this.profileConverter.convertRoleToLogbook(roles)));
                    profile.setRoles(roles);
                    continue block23;
                }
                case "externalParamId": {
                    profile.setExternalParamId(CastUtils.toString((Object)entry.getValue()));
                    continue block23;
                }
            }
            throw new IllegalArgumentException("Unable to patch profile " + profile.getId() + ": key " + entry.getKey() + " is not allowed");
        }
        this.iamLogbookService.updateProfileEvent(profile, logbooks);
    }

    @Transactional
    public ProfileDto patch(Map<String, Object> partialDto) {
        LOGGER.info("Patch {} with {}", (Object)this.getObjectName(), partialDto);
        ProfileDto profileDto = (ProfileDto)super.patch(partialDto);
        this.loadExtraInformation(profileDto, Optional.of(EmbeddedOptions.ALL.toString()));
        return profileDto;
    }

    protected Role convertToRole(Map<String, Object> patchEntry) {
        if (!patchEntry.containsKey("name")) {
            throw new IllegalArgumentException("No property 'name' has been found for the role : " + patchEntry.toString());
        }
        Role role = new Role();
        role.setName(patchEntry.get("name").toString());
        return role;
    }

    private Profile find(String id, String customerId, Integer tenantIdentifier, String message) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)id), (String)(message + ": no id"));
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)customerId), (String)(message + ": no customerId"));
        Assert.isTrue((tenantIdentifier != null ? 1 : 0) != 0, (String)(message + ": no tenant Identifier"));
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)customerId, (CharSequence)this.getInternalSecurityService().getCustomerId()), (String)(message + ": customerId " + customerId + " is not allowed"));
        return (Profile)this.getRepository().findByIdAndCustomerIdAndTenantIdentifier(id, customerId, tenantIdentifier).orElseThrow(() -> new IllegalArgumentException(message + ": no profile found for id " + id + " - customerId : " + customerId + " - tenantIdentifier : " + tenantIdentifier));
    }

    private void checkEnabled(String profileId, boolean dtoEnable, String message) {
        if (!dtoEnable) {
            long count = this.countGroupsByProfileIds(profileId);
            Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)(message + ": the profile is referenced by " + count + " groups"));
        }
    }

    private void checkModifyLevel(Profile profile, String dtoLevel, String message) {
        if (!StringUtils.equals((CharSequence)profile.getLevel(), (CharSequence)dtoLevel)) {
            long count = this.countGroupsByProfileIds(profile.getId());
            Assert.isTrue((count == 0L ? 1 : 0) != 0, (String)(message + ": the profile is referenced by " + count + " groups"));
        }
    }

    private void checkLevel(String level, String message) {
        Assert.isTrue((boolean)Pattern.matches("(^[A-Z0-9]+(.[A-Z0-9]+)*$)|^$", level), (String)("level : " + level + " format is not allowed"));
        Assert.isTrue((boolean)this.internalSecurityService.isLevelAllowed(level), (String)(message + ": level " + level + " is not allowed"));
    }

    private void checkSetReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly must be set to false"));
    }

    private void checkIsReadonly(boolean readonly, String message) {
        Assert.isTrue((!readonly ? 1 : 0) != 0, (String)(message + ": readonly profile"));
    }

    private void checkCustomer(String customerId, String message) {
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)customerId, (CharSequence)this.getInternalSecurityService().getCustomerId()), (String)(message + ": customerId " + customerId + " is not allowed"));
        Optional customer = this.customerRepository.findById((Object)customerId);
        Assert.isTrue((boolean)customer.isPresent(), (String)(message + ": customer does not exist"));
        Assert.isTrue((boolean)((Customer)customer.get()).isEnabled(), (String)(message + ": customer must be enabled"));
    }

    private void checkName(String name, Integer tenantIdentifier, String level, String appName, String message) {
        LOGGER.debug("name : {} , level : {}", (Object)name, (Object)level);
        Criteria criteria = MongoUtils.buildCriteriaEquals((String)"name", (String)name, (boolean)true).and("level").is((Object)level).and("applicationName").is((Object)appName).and("tenantIdentifier").is((Object)tenantIdentifier);
        Assert.isTrue((!this.getRepository().exists(new CriteriaDefinition[]{criteria}) ? 1 : 0) != 0, (String)(message + ": profile already exists"));
    }

    private void checkTenant(Integer tenantIdentifier, String message) {
        Tenant tenant = this.tenantRepository.findByIdentifier(tenantIdentifier);
        Assert.isTrue((tenant != null ? 1 : 0) != 0, (String)(message + ": The tenant " + tenantIdentifier + " does not exist"));
    }

    private void checkRoles(List<Role> roles, String level, String message) {
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(roles), (String)(message + ": no roles"));
        Integer tenantIdentifier = this.internalSecurityService.getTenantIdentifier();
        List allRoles = CustomerInitConfig.getAllRoles();
        List myRoles = InternalSecurityService.getRoles((AuthUserDto)this.internalSecurityService.getUser(), (Integer)tenantIdentifier);
        List subRoles = this.getSubRoles(level, tenantIdentifier);
        List adminVitamUIRoles = ServicesData.getAdminVitamUIRoles();
        for (Role role : roles) {
            Assert.isTrue((boolean)allRoles.contains(role), (String)(message + ": role " + role.getName() + " does not exist"));
            boolean allow = myRoles.contains(role) || subRoles.contains(role) || this.internalSecurityService.userIsRootLevel() && !adminVitamUIRoles.contains(role);
            Assert.isTrue((boolean)allow, (String)(message + ": role " + role + " is not allowed"));
        }
    }

    private long countGroupsByProfileIds(String profileId) {
        return this.groupRepository.countByProfileIds(profileId);
    }

    private Collection<Group> getGroupsByProfileIds(String profileId) {
        return this.groupRepository.findByProfileIds(profileId);
    }

    private List<Role> getSubRoles(String level, Integer tenantIdentifier) {
        Assert.isTrue((tenantIdentifier != null ? 1 : 0) != 0, (String)"Unable to getSubRoles: tenantIdentifier must be not null");
        ArrayList<Criteria> criterias = new ArrayList<Criteria>();
        criterias.add(Criteria.where((String)"tenantIdentifier").is((Object)tenantIdentifier));
        criterias.add(Criteria.where((String)"enabled").is((Object)true));
        if (!level.isEmpty()) {
            criterias.add(Criteria.where((String)"level").regex("^" + level + "\\..+$"));
        }
        return this.getRepository().findAll(criterias).stream().flatMap(p -> p.getRoles().stream()).collect(Collectors.toList());
    }

    public List<String> getSubLevels(String level, String customerId) {
        ArrayList<Criteria> criterias = new ArrayList<Criteria>();
        criterias.add(Criteria.where((String)"customerId").in(new Object[]{customerId}));
        criterias.add(Criteria.where((String)"enabled").is((Object)true));
        if (!level.isEmpty()) {
            criterias.add(Criteria.where((String)"level").regex("^" + level + "\\..+$"));
        }
        return this.getRepository().findAll(criterias).stream().map(Profile::getLevel).collect(Collectors.toList());
    }

    public void addDataAccessRestrictions(Collection<CriteriaDefinition> criteria) {
        super.addDataAccessRestrictions(criteria);
    }

    public Profile internalConvertFromDtoToEntity(ProfileDto dto) {
        return (Profile)super.internalConvertFromDtoToEntity((IdDto)dto);
    }

    public ProfileDto internalConvertFromEntityToDto(Profile profile) {
        return (ProfileDto)super.internalConvertFromEntityToDto((BaseIdDocument)profile);
    }

    public boolean checkExist(String criteria) {
        return super.checkExist(criteria);
    }

    public List<ProfileDto> getMany(List<String> ids, Optional<String> embedded) {
        return super.getMany(ids, embedded);
    }

    protected Class<Profile> getEntityClass() {
        return Profile.class;
    }

    protected ProfileRepository getRepository() {
        return this.profileRepository;
    }

    protected Converter<ProfileDto, Profile> getConverter() {
        return this.profileConverter;
    }

    public JsonNode findHistoryById(String id) throws VitamClientException {
        Integer tenantIdentifier = this.internalSecurityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.internalSecurityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.internalSecurityService.getApplicationId());
        LOGGER.debug("Find History Access Contract By ID {}, EvIdAppSession : {}", (Object)id, (Object)vitamContext.getApplicationSessionId());
        Optional profile = this.getRepository().findById((Object)id);
        profile.orElseThrow(() -> new NotFoundException(String.format("No user found with id : %s", id)));
        LOGGER.debug("findHistoryById : events.obId {}, events.obIdReq {}, VitamContext {}", new Object[]{((Profile)profile.get()).getIdentifier(), "profiles", vitamContext});
        return this.logbookService.findEventsByIdentifierAndCollectionNames(((Profile)profile.get()).getIdentifier(), "profiles", vitamContext).toJsonNode();
    }

    public List<String> getLevels(Optional<String> criteriaJsonString) {
        Document document = this.groupFields(criteriaJsonString, new String[]{"level"});
        LOGGER.debug("getLevels : {}", (Object)document);
        if (document == null) {
            return new ArrayList<String>();
        }
        return (List)document.get((Object)"level");
    }

    @Generated
    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }

    @Generated
    public CustomerRepository getCustomerRepository() {
        return this.customerRepository;
    }

    @Generated
    public GroupRepository getGroupRepository() {
        return this.groupRepository;
    }

    @Generated
    public TenantRepository getTenantRepository() {
        return this.tenantRepository;
    }

    @Generated
    public UserRepository getUserRepository() {
        return this.userRepository;
    }

    @Generated
    public InternalSecurityService getInternalSecurityService() {
        return this.internalSecurityService;
    }

    @Generated
    public IamLogbookService getIamLogbookService() {
        return this.iamLogbookService;
    }

    @Generated
    public ProfileConverter getProfileConverter() {
        return this.profileConverter;
    }

    @Generated
    public LogbookService getLogbookService() {
        return this.logbookService;
    }

    @Generated
    public void setLogbookService(LogbookService logbookService) {
        this.logbookService = logbookService;
    }
}

