/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.group.converter;

import fr.gouv.vitamui.commons.api.converter.Converter;
import fr.gouv.vitamui.commons.api.domain.GroupDto;
import fr.gouv.vitamui.commons.api.utils.ApiUtils;
import fr.gouv.vitamui.commons.logbook.util.LogbookUtils;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.iam.internal.server.group.domain.Group;
import fr.gouv.vitamui.iam.internal.server.profile.dao.ProfileRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;

public class GroupConverter
implements Converter<GroupDto, Group> {
    public static final String ENABLED_KEY = "Activ\u00e9";
    public static final String NAME_KEY = "Nom";
    public static final String LEVEL_KEY = "Niveau";
    public static final String DESCRIPTION_KEY = "Description";
    public static final String PROFILE_IDS_KEY = "Liste des profils";
    public static final String UNITS_KEY = "Liste des unit\u00e9s d'appartenance";
    private final ProfileRepository profileRepository;

    public GroupConverter(ProfileRepository profileRepository) {
        this.profileRepository = profileRepository;
    }

    public String convertToLogbook(GroupDto dto) {
        LinkedHashMap<String, String> logbookData = new LinkedHashMap<String, String>();
        logbookData.put(NAME_KEY, LogbookUtils.getValue((Object)dto.getName()));
        logbookData.put(DESCRIPTION_KEY, LogbookUtils.getValue((Object)dto.getDescription()));
        logbookData.put(LEVEL_KEY, LogbookUtils.getValue((Object)dto.getLevel()));
        logbookData.put(ENABLED_KEY, LogbookUtils.getValue((Object)dto.isEnabled()));
        logbookData.put(PROFILE_IDS_KEY, this.convertProfileIdsToLogbook((Collection)dto.getProfileIds()));
        logbookData.put(UNITS_KEY, this.convertUnitsToLogbook(dto.getUnits()));
        return ApiUtils.toJson(logbookData);
    }

    public Group convertDtoToEntity(GroupDto dto) {
        return (Group)VitamUIUtils.copyProperties((Object)dto, (Object)new Group());
    }

    public GroupDto convertEntityToDto(Group entity) {
        return (GroupDto)VitamUIUtils.copyProperties((Object)entity, (Object)new GroupDto());
    }

    public String convertProfileIdsToLogbook(Collection<String> profileIds) {
        Iterable profiles = this.profileRepository.findAllById(profileIds);
        List ids = StreamSupport.stream(profiles.spliterator(), false).map(p -> Integer.parseInt(p.getIdentifier())).collect(Collectors.toList());
        ids.sort(Comparator.naturalOrder());
        return ids.toString();
    }

    public String convertUnitsToLogbook(Set<String> units) {
        return units != null ? units.toString() : Collections.emptySet().toString();
    }

    @Generated
    public ProfileRepository getProfileRepository() {
        return this.profileRepository;
    }
}

