/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.server.externalparamprofile.service;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.commons.api.domain.CriterionOperator;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParamProfileDto;
import fr.gouv.vitamui.commons.api.domain.ExternalParametersDto;
import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.ParameterDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.domain.QueryDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.logbook.dto.EventDiffDto;
import fr.gouv.vitamui.commons.security.client.dto.AuthUserDto;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.iam.internal.server.common.builder.ExternalParamDtoBuilder;
import fr.gouv.vitamui.iam.internal.server.common.builder.ProfileDtoBuilder;
import fr.gouv.vitamui.iam.internal.server.externalParameters.service.ExternalParametersInternalService;
import fr.gouv.vitamui.iam.internal.server.externalparamprofile.dao.ExternalParamProfileRepository;
import fr.gouv.vitamui.iam.internal.server.logbook.service.IamLogbookService;
import fr.gouv.vitamui.iam.internal.server.profile.converter.ProfileConverter;
import fr.gouv.vitamui.iam.internal.server.profile.service.ProfileInternalService;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class ExternalParamProfileInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ExternalParamProfileInternalService.class);
    public static final String PARAM_ACCESS_CONTRACT_NAME = "PARAM_ACCESS_CONTRACT";
    public static final String PARAM_BULK_OPERATIONS_THRESHOLD_NAME = "PARAM_BULK_OPERATIONS_THRESHOLD";
    private final InternalSecurityService internalSecurityService;
    private final ProfileInternalService profileInternalService;
    private final ExternalParametersInternalService externalParametersInternalService;
    private final IamLogbookService iamLogbookService;
    private final ExternalParamProfileRepository externalParamProfileRepository;
    private final LogbookService logbookService;
    private final ProfileConverter profileConverter;
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String ENABLED = "enabled";
    private static final String ACCESS_CONTRACT = "accessContract";
    private static final String USE_PLATFORM_BULK_OPERATIONS_THRESHOLD = "usePlatformThreshold";
    private static final String BULK_OPERATIONS_THRESHOLD = "bulkOperationsThreshold";
    private static final String ID_PROFILE = "idProfile";
    private static final String ID_EXTERNAL_PARAM = "idExternalParam";
    private static final String EXTERNAL_PARAM_PROFILE = "externalparamprofile";

    @Autowired
    public ExternalParamProfileInternalService(ExternalParametersInternalService externalParametersInternalService, ProfileInternalService profileInternalService, InternalSecurityService internalSecurityService, IamLogbookService iamLogbookService, ExternalParamProfileRepository externalParamProfileRepository, LogbookService logbookService, ProfileConverter profileConverter) {
        this.externalParametersInternalService = externalParametersInternalService;
        this.internalSecurityService = internalSecurityService;
        this.profileInternalService = profileInternalService;
        this.iamLogbookService = iamLogbookService;
        this.externalParamProfileRepository = externalParamProfileRepository;
        this.logbookService = logbookService;
        this.profileConverter = profileConverter;
    }

    public PaginatedValuesDto<ExternalParamProfileDto> getAllPaginated(Integer page, Integer size, String criteria, String orderBy, DirectionDto direction) {
        Integer tenantIdentifier = this.internalSecurityService.getTenantIdentifier();
        QueryDto queryDto = QueryDto.fromJson((String)criteria);
        queryDto.addQuery(QueryDto.andQuery().addCriterion("tenantIdentifier", (Object)tenantIdentifier, CriterionOperator.EQUALS));
        return this.externalParamProfileRepository.getAllPaginated(page, size, queryDto.toJson(), orderBy, direction);
    }

    @Transactional
    public ExternalParamProfileDto create(ExternalParamProfileDto entityDto) {
        LOGGER.debug("create access external parameter profile");
        LOGGER.debug("create {}, {}, {} ", new Object[]{entityDto.getName(), entityDto.getDescription(), entityDto.getAccessContract()});
        Integer tenantIdentifier = this.internalSecurityService.getTenantIdentifier();
        AuthUserDto authUserDto = this.internalSecurityService.getUser();
        String externalParamIdentifier = this.externalParametersInternalService.getExternalParametersRepository().generateSuperId();
        ExternalParametersDto savedExternalParametersDto = this.externalParametersInternalService.create(ExternalParamDtoBuilder.build((ExternalParamProfileDto)entityDto, (String)externalParamIdentifier));
        ProfileDto profileDto = ProfileDtoBuilder.build((String)entityDto.getName(), (String)entityDto.getDescription(), (boolean)entityDto.isEnabled(), (boolean)false, (String)"", (Integer)tenantIdentifier, (String)"EXTERNAL_PARAMS", List.of("ROLE_CREATE_EXTERNAL_PARAM_PROFILE", "ROLE_EDIT_EXTERNAL_PARAM_PROFILE", "ROLE_SEARCH_EXTERNAL_PARAM_PROFILE", "ROLE_GET_EXTERNAL_PARAMS"), (String)authUserDto.getCustomerId(), (String)savedExternalParametersDto.getId());
        ProfileDto savedProfileDto = this.profileInternalService.create(profileDto);
        entityDto.setExternalParamIdentifier(savedExternalParametersDto.getIdentifier());
        entityDto.setProfileIdentifier(savedProfileDto.getIdentifier());
        entityDto.setDateTime(OffsetDateTime.now());
        entityDto.setIdExternalParam(savedExternalParametersDto.getId());
        entityDto.setIdProfile(savedProfileDto.getId());
        entityDto.setId(savedProfileDto.getId());
        LOGGER.debug("savedProfileDto = {}", (Object)savedProfileDto);
        this.iamLogbookService.createExternalParamProfileEvent(entityDto);
        return entityDto;
    }

    public ExternalParamProfileDto getOne(String id) {
        LOGGER.debug("get one with id : {}", (Object)id);
        return this.externalParamProfileRepository.findByIdProfile(id);
    }

    public JsonNode findHistoryById(String id) throws VitamClientException {
        Integer tenantIdentifier = this.internalSecurityService.getTenantIdentifier();
        VitamContext vitamContext = new VitamContext(tenantIdentifier).setAccessContract(this.internalSecurityService.getTenant(tenantIdentifier).getAccessContractLogbookIdentifier()).setApplicationSessionId(this.internalSecurityService.getApplicationId());
        LOGGER.debug("Find History of external parameter profile by id {}, EvIdAppSession : {}", (Object)id, (Object)vitamContext.getApplicationSessionId());
        LOGGER.debug("findHistoryById : events.obId {}, events.obIdReq {}, VitamContext {}", new Object[]{id, EXTERNAL_PARAM_PROFILE, vitamContext});
        return this.logbookService.findEventsByIdentifierAndCollectionNames(id, EXTERNAL_PARAM_PROFILE, vitamContext).toJsonNode();
    }

    @Transactional
    public ExternalParamProfileDto patch(Map<String, Object> partialDto) throws BadRequestException {
        LOGGER.debug("Patch with {}", partialDto);
        ArrayList<EventDiffDto> externalParamProfileLogbooks = new ArrayList<EventDiffDto>();
        String idProfile = (String)partialDto.get(ID_PROFILE);
        ProfileDto profileDto = (ProfileDto)this.profileInternalService.getOne(idProfile);
        ExternalParamProfileDto externalParamProfileDto = this.externalParamProfileRepository.findByIdProfile(idProfile);
        this.patchProfile(profileDto, externalParamProfileDto, partialDto, externalParamProfileLogbooks);
        String idExternalParam = (String)partialDto.get(ID_EXTERNAL_PARAM);
        ExternalParametersDto externalParametersDto = (ExternalParametersDto)this.externalParametersInternalService.getOne(idExternalParam);
        ArrayList<EventDiffDto> externalParametersLogbooks = new ArrayList<EventDiffDto>();
        Map parametersMaps = Optional.ofNullable(externalParametersDto.getParameters()).orElse(Collections.emptyList()).stream().collect(Collectors.toMap(ParameterDto::getKey, Function.identity()));
        if (partialDto.get(NAME) != null) {
            externalParametersDto.setName((String)partialDto.get(NAME));
        }
        if (partialDto.get(ACCESS_CONTRACT) != null) {
            String accessContract = (String)partialDto.get(ACCESS_CONTRACT);
            externalParamProfileLogbooks.add(new EventDiffDto(ACCESS_CONTRACT, (Object)externalParamProfileDto.getAccessContract(), (Object)accessContract));
            externalParametersLogbooks.add(new EventDiffDto(ACCESS_CONTRACT, (Object)externalParamProfileDto.getAccessContract(), (Object)accessContract));
            parametersMaps.put(PARAM_ACCESS_CONTRACT_NAME, new ParameterDto(PARAM_ACCESS_CONTRACT_NAME, accessContract));
        }
        if (partialDto.get(USE_PLATFORM_BULK_OPERATIONS_THRESHOLD) != null || partialDto.get(BULK_OPERATIONS_THRESHOLD) != null) {
            if (partialDto.get(USE_PLATFORM_BULK_OPERATIONS_THRESHOLD) != null) {
                boolean updateBulkOperationThresholdFlag = (Boolean)partialDto.get(USE_PLATFORM_BULK_OPERATIONS_THRESHOLD);
                if (!updateBulkOperationThresholdFlag) {
                    Object bulkOperationThreshold = partialDto.get(BULK_OPERATIONS_THRESHOLD);
                    Integer thresholdValue = this.extractValidNumber(bulkOperationThreshold);
                    parametersMaps.put(PARAM_BULK_OPERATIONS_THRESHOLD_NAME, new ParameterDto(PARAM_BULK_OPERATIONS_THRESHOLD_NAME, thresholdValue.toString()));
                    externalParamProfileLogbooks.add(new EventDiffDto(PARAM_BULK_OPERATIONS_THRESHOLD_NAME, (Object)externalParamProfileDto.getBulkOperationsThreshold(), bulkOperationThreshold));
                } else {
                    parametersMaps.remove(PARAM_BULK_OPERATIONS_THRESHOLD_NAME);
                    externalParamProfileLogbooks.add(new EventDiffDto(PARAM_BULK_OPERATIONS_THRESHOLD_NAME, (Object)externalParamProfileDto.getBulkOperationsThreshold(), null));
                }
            } else {
                Object bulkOperationThreshold = partialDto.get(BULK_OPERATIONS_THRESHOLD);
                Integer thresholdValue = this.extractValidNumber(bulkOperationThreshold);
                parametersMaps.put(PARAM_BULK_OPERATIONS_THRESHOLD_NAME, new ParameterDto(PARAM_BULK_OPERATIONS_THRESHOLD_NAME, thresholdValue.toString()));
                externalParamProfileLogbooks.add(new EventDiffDto(PARAM_BULK_OPERATIONS_THRESHOLD_NAME, (Object)externalParamProfileDto.getBulkOperationsThreshold(), bulkOperationThreshold));
            }
        }
        externalParametersDto.setParameters(parametersMaps.values().stream().collect(Collectors.toList()));
        this.externalParametersInternalService.update(externalParametersDto, externalParametersLogbooks);
        this.iamLogbookService.updateExternalParamProfileEvent(externalParamProfileDto, externalParamProfileLogbooks);
        this.externalParametersInternalService.update(externalParametersDto, externalParametersLogbooks);
        return this.externalParamProfileRepository.findByIdProfile(idProfile);
    }

    private Integer extractValidNumber(Object bulkOperationThreshold) throws BadRequestException {
        Integer extractedNumber;
        if (bulkOperationThreshold != null) {
            try {
                extractedNumber = (Integer)bulkOperationThreshold;
            }
            catch (NumberFormatException nfe) {
                LOGGER.debug("The threshold is not a valid number {} ", bulkOperationThreshold);
                throw new BadRequestException("The threshold is not a valid number " + bulkOperationThreshold);
            }
        } else {
            LOGGER.debug("The threshold should be mandatory valid number ");
            throw new BadRequestException("The threshold should be mandatory valid number ");
        }
        return extractedNumber;
    }

    private void patchProfile(ProfileDto profileDto, ExternalParamProfileDto oldDto, Map<String, Object> partialDto, Collection<EventDiffDto> externalParamProfileLogbooks) {
        ArrayList<EventDiffDto> logbooks = new ArrayList<EventDiffDto>();
        for (Map.Entry<String, Object> entry : partialDto.entrySet()) {
            switch (entry.getKey()) {
                case "description": {
                    String description = (String)entry.getValue();
                    profileDto.setDescription(description);
                    logbooks.add(new EventDiffDto("Description", (Object)oldDto.getDescription(), (Object)description));
                    externalParamProfileLogbooks.add(new EventDiffDto(DESCRIPTION, (Object)oldDto.getDescription(), (Object)description));
                    break;
                }
                case "name": {
                    String name = (String)entry.getValue();
                    profileDto.setName(name);
                    logbooks.add(new EventDiffDto("Nom", (Object)oldDto.getName(), (Object)name));
                    externalParamProfileLogbooks.add(new EventDiffDto("nom", (Object)oldDto.getName(), (Object)name));
                    break;
                }
                case "enabled": {
                    Boolean enabled = (Boolean)entry.getValue();
                    profileDto.setEnabled(enabled.booleanValue());
                    logbooks.add(new EventDiffDto("Activ\u00e9", (Object)oldDto.isEnabled(), (Object)enabled));
                    externalParamProfileLogbooks.add(new EventDiffDto("activ\u00e9", (Object)oldDto.isEnabled(), (Object)enabled));
                    break;
                }
            }
        }
        if (partialDto.get(DESCRIPTION) != null || partialDto.get(NAME) != null || partialDto.get(ENABLED) != null) {
            this.profileInternalService.update((IdDto)profileDto);
            this.iamLogbookService.updateProfileEvent(this.profileConverter.convertDtoToEntity(profileDto), logbooks);
        }
    }

    public boolean checkExist(String criteria) {
        LOGGER.debug("criteria : {}", (Object)criteria);
        return this.profileInternalService.checkExist(criteria);
    }

    public static void extractFieldsFromExternalParameters(ExternalParamProfileDto externalParamProfileDto) {
        if (externalParamProfileDto != null && externalParamProfileDto.getParameters() != null && externalParamProfileDto.getParameters().length > 0) {
            for (ParameterDto parameterDto : externalParamProfileDto.getParameters()) {
                if (parameterDto.getKey().equals(PARAM_BULK_OPERATIONS_THRESHOLD_NAME)) {
                    try {
                        externalParamProfileDto.setBulkOperationsThreshold(Long.valueOf(parameterDto.getValue()));
                        externalParamProfileDto.setUsePlatformThreshold(false);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("The field bulkOperationsThreshold parameter contains wrong number value");
                    }
                }
                if (!parameterDto.getKey().equals(PARAM_ACCESS_CONTRACT_NAME)) continue;
                externalParamProfileDto.setAccessContract(parameterDto.getValue());
            }
        }
    }
}

