/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.external.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.UserInfoDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class UserInfoExternalRestClient
extends BasePaginatingAndSortingRestClient<UserInfoDto, ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UserInfoExternalRestClient.class);

    public UserInfoExternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public UserInfoDto getMe(ExternalHttpContext context) {
        LOGGER.debug("GetMe");
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        URIBuilder uriBuilder = this.getUriBuilderFromPath("/me");
        URI uri = this.buildUriBuilder(uriBuilder);
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.GET, request, this.getDtoClass());
        this.checkResponse(response, new Integer[0]);
        return (UserInfoDto)response.getBody();
    }

    public UserInfoDto patchMe(ExternalHttpContext context, Map<String, Object> partialDto) {
        LOGGER.debug("Patch me partialDto={}");
        URIBuilder uriBuilder = this.getUriBuilderFromPath("/me");
        MultiValueMap headers = this.buildHeaders((AbstractHttpContext)context);
        URI uri = this.buildUriBuilder(uriBuilder);
        HttpEntity request = new HttpEntity(partialDto, headers);
        ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.PATCH, request, this.getDtoClass());
        this.checkResponse(response, new Integer[0]);
        return (UserInfoDto)response.getBody();
    }

    public String getPathUrl() {
        return "/iam/v1/userinfos";
    }

    protected Class<UserInfoDto> getDtoClass() {
        return UserInfoDto.class;
    }

    protected ParameterizedTypeReference<List<UserInfoDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<UserInfoDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<UserInfoDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<UserInfoDto>>(){};
    }
}

