/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.client;

import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.domain.ProfileDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class ProfileInternalRestClient
extends BasePaginatingAndSortingRestClient<ProfileDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(ProfileInternalRestClient.class);

    public ProfileInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    private ParameterizedTypeReference<List<String>> getStringListClass() {
        return new ParameterizedTypeReference<List<String>>(){};
    }

    public List<String> getLevels(InternalHttpContext context, Optional<String> criteria) {
        LOGGER.debug("GetLevels criteria={}", criteria);
        URIBuilder builder = this.getUriBuilderFromPath("/levels");
        criteria.ifPresent(o -> builder.addParameter("criteria", o));
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, this.getStringListClass());
        this.checkResponse(response, new Integer[0]);
        return (List)response.getBody();
    }

    public String getPathUrl() {
        return "/iam/v1/profiles";
    }

    protected Class<ProfileDto> getDtoClass() {
        return ProfileDto.class;
    }

    protected ParameterizedTypeReference<List<ProfileDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<ProfileDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<ProfileDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<ProfileDto>>(){};
    }
}

