/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.client;

import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BaseWebClient;
import fr.gouv.vitamui.commons.rest.client.ExternalHttpContext;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.iam.common.dto.CustomerCreationFormData;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import fr.gouv.vitamui.iam.common.dto.CustomerPatchFormData;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

public class CustomerInternalWebClient
extends BaseWebClient<ExternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CustomerInternalWebClient.class);

    public CustomerInternalWebClient(WebClient webClient, String baseUrl) {
        super(webClient, baseUrl);
    }

    public CustomerDto create(InternalHttpContext context, CustomerCreationFormData customerCreationFormData) {
        LOGGER.debug("Create {}", (Object)customerCreationFormData);
        if (customerCreationFormData == null) {
            throw new BadRequestException("Customer data not found.");
        }
        return (CustomerDto)this.multiparts(this.getUrl(), HttpMethod.POST, (AbstractHttpContext)context, Map.of("customerDto", customerCreationFormData.getCustomerDto(), "tenantName", customerCreationFormData.getTenantName()), customerCreationFormData.getHeader().isPresent() ? Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("header", (MultipartFile)customerCreationFormData.getHeader().get())) : Optional.empty(), customerCreationFormData.getFooter().isPresent() ? Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("footer", (MultipartFile)customerCreationFormData.getFooter().get())) : Optional.empty(), customerCreationFormData.getPortal().isPresent() ? Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("portal", (MultipartFile)customerCreationFormData.getPortal().get())) : Optional.empty(), CustomerDto.class);
    }

    public CustomerDto create(InternalHttpContext context, CustomerDto dto, Optional<Path> multipartFile) {
        if (multipartFile.isPresent()) {
            return (CustomerDto)this.multipartDataFromFile(this.getUrl(), HttpMethod.POST, (AbstractHttpContext)context, Collections.singletonMap("customerDto", dto), Optional.of(new AbstractMap.SimpleEntry<String, Path>("logo", multipartFile.get())), CustomerDto.class);
        }
        return (CustomerDto)this.multipartDataFromFile(this.getUrl(), HttpMethod.POST, (AbstractHttpContext)context, Collections.singletonMap("customerDto", dto), Optional.empty(), CustomerDto.class);
    }

    public CustomerDto patch(InternalHttpContext context, CustomerPatchFormData customerPatchFormData) {
        LOGGER.debug("Patch {}", (Object)customerPatchFormData);
        return (CustomerDto)this.multiparts(this.getUrl() + "/" + customerPatchFormData.getPartialCustomerDto().get("id"), HttpMethod.PATCH, (AbstractHttpContext)context, Collections.singletonMap("partialCustomerDto", customerPatchFormData.getPartialCustomerDto()), customerPatchFormData.getHeader().isPresent() ? Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("header", (MultipartFile)customerPatchFormData.getHeader().get())) : Optional.empty(), customerPatchFormData.getFooter().isPresent() ? Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("footer", (MultipartFile)customerPatchFormData.getFooter().get())) : Optional.empty(), customerPatchFormData.getPortal().isPresent() ? Optional.of(new AbstractMap.SimpleEntry<String, MultipartFile>("portal", (MultipartFile)customerPatchFormData.getPortal().get())) : Optional.empty(), CustomerDto.class);
    }

    public String getPathUrl() {
        return "/iam/v1/customers";
    }
}

