/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.client;

import fr.gouv.vitamui.commons.api.domain.IdDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.enums.AttachmentType;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import fr.gouv.vitamui.iam.common.dto.CustomerDto;
import java.util.List;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class CustomerInternalRestClient
extends BasePaginatingAndSortingRestClient<CustomerDto, InternalHttpContext> {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(CustomerInternalRestClient.class);

    public CustomerInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public CustomerDto getMyCustomer(InternalHttpContext context) {
        LOGGER.debug("GetMyCustomer");
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/me"));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, CustomerDto.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (CustomerDto)response.getBody();
    }

    public CustomerDto getByCode(InternalHttpContext context, String code) {
        LOGGER.debug("GetByCode {}", (Object)code);
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)this.getUrl());
        uriBuilder.queryParam("code", new Object[]{code});
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, this.getDtoClass(), new Object[]{code});
        this.checkResponse(response, new Integer[0]);
        return (CustomerDto)response.getBody();
    }

    @Deprecated
    public CustomerDto create(InternalHttpContext context, CustomerDto dto) {
        return (CustomerDto)super.create((AbstractHttpContext)context, (IdDto)dto);
    }

    public String getPathUrl() {
        return "/iam/v1/customers";
    }

    protected Class<CustomerDto> getDtoClass() {
        return CustomerDto.class;
    }

    protected ParameterizedTypeReference<List<CustomerDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<CustomerDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<CustomerDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<CustomerDto>>(){};
    }

    public ResponseEntity<Resource> getLogo(InternalHttpContext context, String id, AttachmentType type) {
        LOGGER.debug("Get logo for customer with id {}, type: {}", (Object)id, (Object)type);
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        URIBuilder builder = this.getUriBuilderFromPath("/" + id + "/logo?type=" + type);
        ResponseEntity response = this.restTemplate.exchange(this.buildUriBuilder(builder), HttpMethod.GET, request, Resource.class);
        this.checkResponse(response, new Integer[]{200, 204});
        return response;
    }

    public boolean getGdprSettingStatus(InternalHttpContext context) {
        LOGGER.debug("get Gdpr Setting Status");
        HttpEntity request = new HttpEntity(this.buildHeaders((AbstractHttpContext)context));
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + "/gdpr-status"));
        ResponseEntity response = this.restTemplate.exchange(uriBuilder.toUriString(), HttpMethod.GET, request, Boolean.class, new Object[0]);
        this.checkResponse(response, new Integer[0]);
        return (Boolean)response.getBody();
    }
}

