/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.iam.internal.client;

import fr.gouv.vitamui.commons.api.domain.ApplicationDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.rest.client.AbstractHttpContext;
import fr.gouv.vitamui.commons.rest.client.BasePaginatingAndSortingRestClient;
import fr.gouv.vitamui.commons.rest.client.InternalHttpContext;
import java.net.URI;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ApplicationInternalRestClient
extends BasePaginatingAndSortingRestClient<ApplicationDto, InternalHttpContext> {
    private static final String IDENTIFIER_EXTERNAL_PATH = "/{identifier}/externalid";

    public ApplicationInternalRestClient(RestTemplate restTemplate, String baseUrl) {
        super(restTemplate, baseUrl);
    }

    public String getPathUrl() {
        return "/iam/v1/applications";
    }

    protected Class<ApplicationDto> getDtoClass() {
        return ApplicationDto.class;
    }

    protected ParameterizedTypeReference<List<ApplicationDto>> getDtoListClass() {
        return new ParameterizedTypeReference<List<ApplicationDto>>(){};
    }

    protected ParameterizedTypeReference<PaginatedValuesDto<ApplicationDto>> getDtoPaginatedClass() {
        return new ParameterizedTypeReference<PaginatedValuesDto<ApplicationDto>>(){};
    }

    public ResponseEntity<Boolean> isApplicationExternalIdentifierEnabled(InternalHttpContext context, String applicationId) {
        URI uri = UriComponentsBuilder.fromHttpUrl((String)(this.getUrl() + IDENTIFIER_EXTERNAL_PATH)).build(new Object[]{applicationId});
        return this.restTemplate.exchange(uri, HttpMethod.GET, new HttpEntity(this.buildHeaders((AbstractHttpContext)context)), Boolean.class);
    }
}

