/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import fr.gouv.vitam.common.model.administration.ContextStatus;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.administration.RuleType;
import fr.gouv.vitamui.commons.api.dtos.ErrorImportFile;
import fr.gouv.vitamui.commons.api.enums.ErrorImportFileMessage;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.utils.JsonUtils;
import fr.gouv.vitamui.referential.internal.server.utils.CheckParentLink;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class ImportCSVUtils {
    private static final long MAX_OCTET_FILE_SIZE = 2000000L;

    protected static void checkImportFile(MultipartFile file, List<ColumnDetails> expectedColumns) {
        ImportCSVUtils.checkFileSize(file);
        List<String[]> contracts = ImportCSVUtils.parseFileToContracts(file);
        ImportCSVUtils.checkHeaders(contracts.remove(0), expectedColumns);
        ImportCSVUtils.checkIfEmptyFile(contracts);
        ArrayList<ErrorImportFile> lineErrors = new ArrayList<ErrorImportFile>();
        int line = 2;
        for (String[] contract : contracts) {
            ImportCSVUtils.checkLine(contract, line, expectedColumns, lineErrors);
            ++line;
        }
        if (!lineErrors.isEmpty()) {
            throw new BadRequestException("Errors in rows found", null, lineErrors.stream().map(ImportCSVUtils::errorToJson).collect(Collectors.toList()));
        }
    }

    private static void checkFileSize(MultipartFile file) {
        if (file.getSize() == 0L) {
            throw new BadRequestException("The file is empty", null, List.of(ImportCSVUtils.errorToJson(ErrorImportFile.builder().error(ErrorImportFileMessage.FILE_IS_EMPTY).build())));
        }
        if (file.getSize() > 2000000L) {
            throw new BadRequestException("The size of the file is too big be imported", null, List.of(ImportCSVUtils.errorToJson(ErrorImportFile.builder().error(ErrorImportFileMessage.FILE_SIZE_TOO_BIG).build())));
        }
    }

    private static List<String[]> parseFileToContracts(MultipartFile file) {
        List list;
        InputStreamReader fileReader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
        try {
            CSVParser parser = new CSVParserBuilder().withSeparator(';').build();
            CSVReader csvReader = new CSVReaderBuilder((Reader)fileReader).withCSVParser((ICSVParser)parser).build();
            list = csvReader.readAll();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)fileReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (CsvException | IOException e) {
                throw new BadRequestException("Unable to read the CSV file " + file.getOriginalFilename(), e);
            }
        }
        ((Reader)fileReader).close();
        return list;
    }

    private static void checkHeaders(String[] headersLine, List<ColumnDetails> expectedColumns) {
        ImportCSVUtils.checkHeadersLength(headersLine, expectedColumns);
        ImportCSVUtils.checkHeadersName(headersLine, expectedColumns);
    }

    private static void checkHeadersLength(String[] headersLine, List<ColumnDetails> expectedColumns) {
        if (headersLine.length == 1) {
            throw new BadRequestException("Only one header found in the file", null, List.of(ImportCSVUtils.errorToJson(ErrorImportFile.builder().error(ErrorImportFileMessage.ONLY_ONE_HEADER_INCORRECT_SEPARATOR).data(headersLine[0]).build())));
        }
        if (headersLine.length != expectedColumns.size()) {
            throw new BadRequestException("The headers length in the file does not match with the expected", null, List.of(ImportCSVUtils.errorToJson(ErrorImportFile.builder().error(ErrorImportFileMessage.FILE_MUST_RESPECT_COLUMNS_LENGTH).build())));
        }
    }

    private static void checkHeadersName(String[] headersLine, List<ColumnDetails> expectedColumns) {
        ArrayList headersNameErrors = new ArrayList();
        AtomicInteger headerIndex = new AtomicInteger(0);
        while (headerIndex.intValue() < headersLine.length) {
            expectedColumns.stream().filter(expectedColumn -> expectedColumn.getIndex() == headerIndex.intValue()).findFirst().ifPresentOrElse(columnDetails -> {
                if (!columnDetails.getColumnName().equals(headersLine[headerIndex.intValue()])) {
                    headersNameErrors.add(ErrorImportFile.builder().column(Character.valueOf(ImportCSVUtils.numberToLetter(headerIndex.intValue()))).line(Integer.valueOf(1)).data(columnDetails.getColumnName()).error(ErrorImportFileMessage.FILE_MUST_RESPECT_COLUMN_NAME).build());
                }
            }, () -> {
                throw new InternalServerException("The header at " + headerIndex.intValue() + " position in the import file does not match with the expected columns!");
            });
            headerIndex.incrementAndGet();
        }
        if (!headersNameErrors.isEmpty()) {
            throw new BadRequestException("The headers names in the file does not match with the expected", null, headersNameErrors.stream().map(ImportCSVUtils::errorToJson).collect(Collectors.toList()));
        }
    }

    private static void checkIfEmptyFile(List<String[]> contracts) {
        if (contracts.isEmpty()) {
            throw new BadRequestException("No contract to import in the import file", null, List.of(ImportCSVUtils.errorToJson(ErrorImportFile.builder().error(ErrorImportFileMessage.AT_LEAST_ONE_LINE).build())));
        }
    }

    private static void checkLine(String[] line, int lineNumber, List<ColumnDetails> expectedColumns, List<ErrorImportFile> lineErrors) {
        if (line.length != expectedColumns.size()) {
            lineErrors.add(ErrorImportFile.builder().line(Integer.valueOf(lineNumber)).error(ErrorImportFileMessage.BAD_ROWS_LENGTH_IN_LINE).build());
            return;
        }
        for (int rowNumber = 0; rowNumber < line.length; ++rowNumber) {
            ImportCSVUtils.checkRow(lineNumber, rowNumber, line[rowNumber], expectedColumns, lineErrors);
        }
    }

    private static void checkRow(int lineNumber, int rowNumber, String value, List<ColumnDetails> expectedColumns, List<ErrorImportFile> lineErrors) {
        ColumnDetails columnDetails;
        if (!StandardCharsets.ISO_8859_1.newEncoder().canEncode(value)) {
            lineErrors.add(ErrorImportFile.builder().column(Character.valueOf(ImportCSVUtils.numberToLetter(rowNumber))).line(Integer.valueOf(lineNumber)).data(value).error(ErrorImportFileMessage.ISO_8859_1_ONLY).build());
        }
        if ((columnDetails = expectedColumns.stream().filter(expectedColumn -> expectedColumn.getIndex() == rowNumber).findFirst().orElseThrow(() -> new InternalServerException("The row " + rowNumber + " in the import file does not match with the expected columns!"))).isMandatory() && StringUtils.isBlank((CharSequence)value)) {
            lineErrors.add(ErrorImportFile.builder().column(Character.valueOf(ImportCSVUtils.numberToLetter(rowNumber))).line(Integer.valueOf(lineNumber)).error(ErrorImportFileMessage.MANDATORY_VALUE).build());
        }
        if (!StringUtils.isBlank((CharSequence)value) && columnDetails.getColumnType().equals((Object)ColumnType.CONTEXT_STATUS) && !EnumUtils.isValidEnum(ContextStatus.class, (String)value)) {
            lineErrors.add(ErrorImportFile.builder().column(Character.valueOf(ImportCSVUtils.numberToLetter(rowNumber))).line(Integer.valueOf(lineNumber)).data(value).error(ErrorImportFileMessage.NOT_ALLOWED_VALUE).build());
        }
        if (!StringUtils.isBlank((CharSequence)value) && columnDetails.getColumnType().equals((Object)ColumnType.A_BOOLEAN) && !"true".equals(value) && !"false".equals(value)) {
            lineErrors.add(ErrorImportFile.builder().column(Character.valueOf(ImportCSVUtils.numberToLetter(rowNumber))).line(Integer.valueOf(lineNumber)).data(value).error(ErrorImportFileMessage.NOT_ALLOWED_VALUE).build());
        }
        if (!StringUtils.isBlank((CharSequence)value) && columnDetails.getColumnType().equals((Object)ColumnType.DATA_OBJECT_VERSION_TYPE)) {
            Arrays.stream(value.split("\\|")).filter(dataObjectVersion -> DataObjectVersionType.fromName((String)dataObjectVersion.trim()) == null).forEach(dataObjectVersion -> lineErrors.add(ErrorImportFile.builder().column(Character.valueOf(ImportCSVUtils.numberToLetter(rowNumber))).line(Integer.valueOf(lineNumber)).data(dataObjectVersion.trim()).error(ErrorImportFileMessage.NOT_ALLOWED_VALUE).build()));
        }
        if (!StringUtils.isBlank((CharSequence)value) && columnDetails.getColumnType().equals((Object)ColumnType.RULE_TYPE)) {
            Arrays.stream(value.split("\\|")).filter(ruleType -> RuleType.getEnumFromName((String)ruleType.trim()) == null).forEach(ruleType -> lineErrors.add(ErrorImportFile.builder().column(Character.valueOf(ImportCSVUtils.numberToLetter(rowNumber))).line(Integer.valueOf(lineNumber)).data(ruleType.trim()).error(ErrorImportFileMessage.NOT_ALLOWED_VALUE).build()));
        }
        if (!StringUtils.isBlank((CharSequence)value) && columnDetails.getColumnType().equals((Object)ColumnType.CHECK_PARENT_LINK_TYPE) && !EnumUtils.isValidEnum(CheckParentLink.class, (String)value)) {
            lineErrors.add(ErrorImportFile.builder().column(Character.valueOf(ImportCSVUtils.numberToLetter(rowNumber))).line(Integer.valueOf(lineNumber)).data(value).error(ErrorImportFileMessage.NOT_ALLOWED_VALUE).build());
        }
    }

    private static char numberToLetter(int i) {
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        if (i >= 0 && i <= 25) {
            return alphabet.substring(i, i + 1).charAt(0);
        }
        return '?';
    }

    public static String errorToJson(ErrorImportFile errorImportFile) {
        try {
            return JsonUtils.toJson((Object)errorImportFile);
        }
        catch (JsonProcessingException e) {
            throw new InternalServerException("The object " + errorImportFile + " could not have been parsed into a JSON String");
        }
    }

    protected static enum ColumnType {
        STRING,
        CONTEXT_STATUS,
        A_BOOLEAN,
        RULE_TYPE,
        DATA_OBJECT_VERSION_TYPE,
        CHECK_PARENT_LINK_TYPE;

    }

    protected static class ColumnDetails {
        private int index;
        private String columnName;
        private boolean mandatory;
        private ColumnType columnType;

        @Generated
        ColumnDetails(int index, String columnName, boolean mandatory, ColumnType columnType) {
            this.index = index;
            this.columnName = columnName;
            this.mandatory = mandatory;
            this.columnType = columnType;
        }

        @Generated
        public static ColumnDetailsBuilder builder() {
            return new ColumnDetailsBuilder();
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Generated
        public ColumnType getColumnType() {
            return this.columnType;
        }

        @Generated
        public void setIndex(int index) {
            this.index = index;
        }

        @Generated
        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Generated
        public void setMandatory(boolean mandatory) {
            this.mandatory = mandatory;
        }

        @Generated
        public void setColumnType(ColumnType columnType) {
            this.columnType = columnType;
        }

        @Generated
        public static class ColumnDetailsBuilder {
            @Generated
            private int index;
            @Generated
            private String columnName;
            @Generated
            private boolean mandatory;
            @Generated
            private ColumnType columnType;

            @Generated
            ColumnDetailsBuilder() {
            }

            @Generated
            public ColumnDetailsBuilder index(int index) {
                this.index = index;
                return this;
            }

            @Generated
            public ColumnDetailsBuilder columnName(String columnName) {
                this.columnName = columnName;
                return this;
            }

            @Generated
            public ColumnDetailsBuilder mandatory(boolean mandatory) {
                this.mandatory = mandatory;
                return this;
            }

            @Generated
            public ColumnDetailsBuilder columnType(ColumnType columnType) {
                this.columnType = columnType;
                return this;
            }

            @Generated
            public ColumnDetails build() {
                return new ColumnDetails(this.index, this.columnName, this.mandatory, this.columnType);
            }

            @Generated
            public String toString() {
                return "ImportCSVUtils.ColumnDetails.ColumnDetailsBuilder(index=" + this.index + ", columnName=" + this.columnName + ", mandatory=" + this.mandatory + ", columnType=" + this.columnType + ")";
            }
        }
    }
}

