/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.schema;

import com.fasterxml.jackson.databind.util.StdConverter;
import fr.gouv.vitam.common.model.administration.schema.SchemaResponse;
import fr.gouv.vitam.common.model.administration.schema.SchemaStringSizeType;
import fr.gouv.vitam.common.model.administration.schema.SchemaType;
import fr.gouv.vitamui.referential.common.dto.SchemaElementDto;
import fr.gouv.vitamui.referential.common.model.Cardinality;
import fr.gouv.vitamui.referential.common.model.Collection;
import fr.gouv.vitamui.referential.common.model.DataType;
import java.util.Objects;
import java.util.Optional;

public class SchemaModelToSchemaElementDtoConverter
extends StdConverter<SchemaResponse, SchemaElementDto> {
    public SchemaElementDto convert(SchemaResponse schemaModel) {
        SchemaStringSizeType stringTypeSize = schemaModel.getStringSize();
        return (SchemaElementDto)new SchemaElementDto().setPath(schemaModel.getPath()).setStringSize((String)Optional.ofNullable(stringTypeSize).map(SchemaStringSizeType::value).orElse(null)).setCardinality(Cardinality.of((String)schemaModel.getCardinality().value())).setFieldName(schemaModel.getFieldName()).setShortName(schemaModel.getShortName()).setDescription(schemaModel.getDescription()).setSedaField(schemaModel.getSedaField()).setApiField(schemaModel.getApiField()).setType(schemaModel.getType()).setOrigin(schemaModel.getOrigin()).setCollection(this.mapCollections(schemaModel)).setSedaVersions(schemaModel.getSedaVersions()).setCategory(schemaModel.getCategory()).setApiPath(Optional.ofNullable(schemaModel.getApiPath()).orElse(schemaModel.getPath())).setDataType(this.convertFromIndexationType(schemaModel.getType()));
    }

    private DataType convertFromIndexationType(SchemaType indexationType) {
        switch (indexationType) {
            case KEYWORD: 
            case ENUM: 
            case TEXT: {
                return DataType.STRING;
            }
            case DATE: {
                return DataType.DATETIME;
            }
            case OBJECT: 
            case LONG: 
            case DOUBLE: 
            case BOOLEAN: {
                return DataType.valueOf((String)indexationType.getType());
            }
        }
        return null;
    }

    private Collection mapCollections(SchemaResponse schemaResponse) {
        if (Objects.isNull(schemaResponse.getCollection())) {
            return null;
        }
        if (Objects.equals(schemaResponse.getCollection(), "Unit")) {
            return Collection.ARCHIVE_UNIT;
        }
        return Collection.valueOf((String)schemaResponse.getCollection());
    }
}

