/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUISearchResponseDto;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.internal.server.service.ExternalParametersService;
import fr.gouv.vitamui.referential.internal.server.unit.UnitInternalService;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/units"})
public class UnitInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(UnitInternalController.class);
    @Autowired
    private UnitInternalService unitInternalService;
    @Autowired
    private ExternalParametersService externalParametersService;
    @Autowired
    private InternalSecurityService securityService;
    @Autowired
    private ObjectMapper objectMapper;

    @GetMapping(value={"/{id}"})
    public JsonNode findUnitById(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @PathVariable String id) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        VitamContext vitamContext = this.externalParametersService.buildVitamContextFromExternalParam();
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        JsonNode queryForUnitById = this.unitInternalService.createQueryForUnitById(id);
        return this.unitInternalService.searchUnits(queryForUnitById, vitamContext);
    }

    @PostMapping(value={"/dsl", "/dsl/{id}"})
    public JsonNode findByDsl(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @RequestHeader(value="X-Access-Contract-Id") String accessContractId, @PathVariable Optional<String> id, @RequestBody JsonNode dsl) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        SanityChecker.sanitizeJson((JsonNode)dsl);
        SanityChecker.checkSecureParameter((String[])new String[]{accessContractId});
        return this.unitInternalService.searchUnitsWithErrors(id, dsl, vitamContext);
    }

    @PostMapping(value={"/{id}/objects"})
    public JsonNode findObjectMetadataById(@RequestHeader(value="X-Tenant-Id") Integer tenantId, @RequestHeader(value="X-Access-Contract-Id") String accessContractId, @PathVariable String id, @RequestBody JsonNode dsl) throws VitamClientException, InvalidParseOperationException, PreconditionFailedException {
        VitamContext vitamContext = this.securityService.buildVitamContext(tenantId, accessContractId);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.sanitizeJson((JsonNode)dsl);
        SanityChecker.checkSecureParameter((String[])new String[]{accessContractId, id});
        return this.unitInternalService.findObjectMetadataById(id, dsl, vitamContext);
    }

    @GetMapping(value={"/filingplan"})
    public VitamUISearchResponseDto getFilingAndHoldingUnits(@RequestHeader(value="X-Tenant-Id") Integer tenantId) throws VitamClientException, IOException, InvalidParseOperationException, PreconditionFailedException {
        LOGGER.debug("Get filing and holding units with projections on needed fields ONLY!");
        VitamContext vitamContext = this.externalParametersService.buildVitamContextFromExternalParam();
        JsonNode fillingOrHoldingQuery = this.unitInternalService.createQueryForFillingOrHoldingUnit();
        return (VitamUISearchResponseDto)this.objectMapper.treeToValue((TreeNode)this.unitInternalService.searchUnits(fillingOrHoldingQuery, vitamContext), VitamUISearchResponseDto.class);
    }

    @Generated
    public UnitInternalService getUnitInternalService() {
        return this.unitInternalService;
    }

    @Generated
    public ExternalParametersService getExternalParametersService() {
        return this.externalParametersService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Generated
    public void setUnitInternalService(UnitInternalService unitInternalService) {
        this.unitInternalService = unitInternalService;
    }

    @Generated
    public void setExternalParametersService(ExternalParametersService externalParametersService) {
        this.externalParametersService = externalParametersService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }

    @Generated
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

