/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.SecurityProfileDto;
import fr.gouv.vitamui.referential.internal.server.securityprofile.SecurityProfileInternalService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/security-profile"})
public class SecurityProfileInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(SecurityProfileInternalController.class);
    @Autowired
    private SecurityProfileInternalService securityProfileInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @GetMapping
    public Collection<SecurityProfileDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("get all customer criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.securityProfileInternalService.getAll(vitamContext);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<SecurityProfileDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.securityProfileInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @GetMapping(path={"/{identifier:.+}"})
    public SecurityProfileDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get security profile identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{identifier});
        return this.securityProfileInternalService.getOne(vitamContext, URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @PostMapping(value={"/check"})
    public ResponseEntity<Void> checkExist(@RequestBody SecurityProfileDto accessContractDto) {
        LOGGER.debug("check exist accessContract={}", (Object)accessContractDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        boolean exist = this.securityProfileInternalService.check(vitamContext, accessContractDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    public SecurityProfileDto create(@Valid @RequestBody SecurityProfileDto accessContractDto) {
        LOGGER.debug("create accessContract={}", (Object)accessContractDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.securityProfileInternalService.create(vitamContext, accessContractDto);
    }

    @PatchMapping(value={"/{id}"})
    public SecurityProfileDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) {
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.securityProfileInternalService.patch(vitamContext, partialDto);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") String id) {
        LOGGER.debug("Delete {}", (Object)id);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        this.securityProfileInternalService.delete(vitamContext, id);
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("get logbook for accessContract with id :{}", (Object)id);
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        return this.securityProfileInternalService.findHistoryByIdentifier(vitamContext, id);
    }

    @Generated
    public SecurityProfileInternalService getSecurityProfileInternalService() {
        return this.securityProfileInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setSecurityProfileInternalService(SecurityProfileInternalService securityProfileInternalService) {
        this.securityProfileInternalService = securityProfileInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

