/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationDto;
import fr.gouv.vitamui.referential.common.dto.ReportType;
import fr.gouv.vitamui.referential.internal.server.operation.OperationInternalService;
import fr.gouv.vitamui.referential.internal.server.probativevalue.ProbativeValueInternalService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/operations"})
public class OperationInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OperationInternalController.class);
    @Autowired
    private OperationInternalService operationInternalService;
    @Autowired
    private ProbativeValueInternalService probativeValueInternalService;
    @Autowired
    private InternalSecurityService securityService;
    private static final String MANDATORY_IDENTIFIER = "The Identifier is a mandatory parameter: ";

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.operationInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @PostMapping
    public void create(@Valid @RequestBody AuditOptions auditOptions, @RequestHeader(value="X-Tenant-Id") Integer tenant, @RequestHeader(value="X-Access-Contract-Id") String accessContractId) {
        LOGGER.debug("run audit ={}", (Object)auditOptions);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier(), accessContractId);
        this.operationInternalService.runAudit(vitamContext, auditOptions);
    }

    @GetMapping(value={"/{id}/download/{type}"})
    public ResponseEntity<Resource> exportEventById(@PathVariable(value="id") String id, @PathVariable(value="type") ReportType type, @RequestHeader(value="X-Access-Contract-Id") String accessContractId) {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier(), accessContractId);
        LOGGER.debug("export logbook for operation with id :{}", (Object)id);
        Response response = this.operationInternalService.export(vitamContext, id, type);
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            InputStreamResource resource = new InputStreamResource((InputStream)entity);
            return new ResponseEntity((Object)resource, HttpStatus.OK);
        }
        return null;
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("get logbook for operation with id :{}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.operationInternalService.findHistoryByIdentifier(vitamContext, id);
    }

    @GetMapping(value={"/check/{id}"})
    public JsonNode checkTraceabilityOperation(@PathVariable String id, @RequestHeader(value="X-Access-Contract-Id") String accessContractId) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id, accessContractId});
        LOGGER.debug("Launch check traceability operation with id = {}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier(), accessContractId);
        return this.operationInternalService.checkTraceabilityOperation(vitamContext, id);
    }

    @PostMapping(value={"/probativeValue"})
    public void runProbativeValue(@Valid @RequestBody ProbativeValueRequest probativeValueRequest, @RequestHeader(value="X-Tenant-Id") Integer tenant, @RequestHeader(value="X-Access-Contract-Id") String accessContractId) throws InvalidParseOperationException, PreconditionFailedException {
        SanityChecker.checkSecureParameter((String[])new String[]{accessContractId});
        LOGGER.debug("run probative value ={}", (Object)probativeValueRequest);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier(), accessContractId);
        this.operationInternalService.runProbativeValue(vitamContext, probativeValueRequest);
    }

    @GetMapping(value={"/probativeValue/{id}"})
    public ResponseEntity<Resource> exportProbativeValue(@PathVariable(value="id") String operationId, @RequestHeader(value="X-Access-Contract-Id") String accessContractId) throws InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)MANDATORY_IDENTIFIER, (String[])new String[]{operationId});
        SafeFileChecker.checkSafeFilePath((String)operationId);
        SanityChecker.isValidFileName((String)operationId);
        SanityChecker.checkSecureParameter((String[])new String[]{operationId, accessContractId});
        LOGGER.debug("Export probative with operationId : ", (Object)operationId);
        LOGGER.debug("Export probative accessContractId : ", (Object)accessContractId);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier(), accessContractId);
        String tempFolder = "/tmp/" + operationId + ".zip";
        File zip = new File(tempFolder);
        try {
            FileOutputStream zipOutputStream = new FileOutputStream(zip);
            this.probativeValueInternalService.exportReport(vitamContext, operationId, "/tmp", zipOutputStream);
            InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(zip.getAbsoluteFile()));
            return new ResponseEntity((Object)resource, HttpStatus.OK);
        }
        catch (FileNotFoundException e) {
            throw new InternalServerException("Error while generating probative value ZIP", (Throwable)e);
        }
    }

    @Generated
    public OperationInternalService getOperationInternalService() {
        return this.operationInternalService;
    }

    @Generated
    public ProbativeValueInternalService getProbativeValueInternalService() {
        return this.probativeValueInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setOperationInternalService(OperationInternalService operationInternalService) {
        this.operationInternalService = operationInternalService;
    }

    @Generated
    public void setProbativeValueInternalService(ProbativeValueInternalService probativeValueInternalService) {
        this.probativeValueInternalService = probativeValueInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

