/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.exception.PreconditionFailedException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.dto.ProcessDetailDto;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.internal.server.logbookmanagement.LogbookManagementOperationInternalService;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/referential/v1/logbook-management-operation"})
public class LogbookManagementOperationInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(LogbookManagementOperationInternalController.class);
    @Autowired
    private LogbookManagementOperationInternalService logbookManagementOperationInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @PostMapping(value={"/operations"})
    public ProcessDetailDto listOperationsDetails(@RequestBody ProcessQuery processQuery) throws VitamClientException, JsonProcessingException {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("Operations details by criteria={}", (Object)processQuery);
        LOGGER.debug("EvIdAppSession VitamContext={}", (Object)vitamContext.getApplicationSessionId());
        return this.logbookManagementOperationInternalService.searchOperationsDetails(vitamContext, processQuery);
    }

    @PostMapping(value={"/operations/cancel/{id}"})
    public ProcessDetailDto cancelOperationProcessExecution(@PathVariable(value="id") String operationId) throws VitamClientException, JsonProcessingException, InvalidParseOperationException, PreconditionFailedException {
        ParameterChecker.checkParameter((String)"The operation Id  is a mandatory paramater", (String[])new String[]{operationId});
        SanityChecker.checkSecureParameter((String[])new String[]{operationId});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.info("EvIdAppSession=  {}", (Object)vitamContext.getApplicationSessionId());
        LOGGER.info("Cancel the operation Id=  {}", (Object)operationId);
        return this.logbookManagementOperationInternalService.cancelOperationProcessExecution(vitamContext, operationId);
    }

    @PostMapping(value={"/operations/update/{id}"})
    public ProcessDetailDto updateOperationActionProcess(@PathVariable(value="id") String operationId, @RequestBody String actionId) throws VitamClientException, JsonProcessingException, InterruptedException, InvalidParseOperationException, PreconditionFailedException {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        ParameterChecker.checkParameter((String)"OperationId and actionId are mandatories : ", (String[])new String[]{operationId, actionId});
        SanityChecker.checkSecureParameter((String[])new String[]{actionId, operationId});
        LOGGER.info("EvIdAppSession=  {}", (Object)vitamContext.getApplicationSessionId());
        LOGGER.info("Update the operation Id=  {}", (Object)operationId);
        return this.logbookManagementOperationInternalService.updateOperationActionProcess(vitamContext, actionId, operationId);
    }

    @Generated
    public LogbookManagementOperationInternalService getLogbookManagementOperationInternalService() {
        return this.logbookManagementOperationInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setLogbookManagementOperationInternalService(LogbookManagementOperationInternalService logbookManagementOperationInternalService) {
        this.logbookManagementOperationInternalService = logbookManagementOperationInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

