/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.FileFormatDto;
import fr.gouv.vitamui.referential.internal.server.fileformat.FileFormatInternalService;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/fileformats"})
public class FileFormatInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(FileFormatInternalController.class);
    @Autowired
    private FileFormatInternalService fileFormatInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @GetMapping
    public Collection<FileFormatDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("get all file formats criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("context={}", (Object)vitamContext);
        return this.fileFormatInternalService.getAll(vitamContext);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<FileFormatDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.fileFormatInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET})
    public Object getByIdOrHistory(HttpServletRequest request) throws UnsupportedEncodingException, VitamClientException {
        LOGGER.debug("getByIdOrHistory ");
        String requestURL = request.getRequestURL().toString();
        String path = StringUtils.substringAfter((String)requestURL, (String)"/referential/v1/fileformats/");
        if (StringUtils.endsWith((CharSequence)path, (CharSequence)"/history")) {
            return this.findHistoryById(StringUtils.substringBefore((String)path, (String)"/history"));
        }
        return this.getOne(StringUtils.removeEndIgnoreCase((String)path, (String)"/"));
    }

    private FileFormatDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get file format identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.fileFormatInternalService.getOne(vitamContext, URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @PostMapping(value={"/check"})
    public ResponseEntity<Void> checkExist(@RequestBody FileFormatDto fileFormat, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("check exist file format={}", (Object)fileFormat);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        boolean exist = this.fileFormatInternalService.check(vitamContext, fileFormat);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    public FileFormatDto create(@Valid @RequestBody FileFormatDto fileFormat, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("create file format={}", (Object)fileFormat);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.fileFormatInternalService.create(vitamContext, fileFormat);
    }

    @PatchMapping(value={"/{id}"})
    public FileFormatDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) {
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.fileFormatInternalService.patch(vitamContext, partialDto);
    }

    @DeleteMapping(value={"/{id}"})
    public void delete(@PathVariable(value="id") String id) {
        LOGGER.debug("Delete {}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        this.fileFormatInternalService.delete(vitamContext, id);
    }

    @GetMapping(value={"/export"})
    public ResponseEntity<Resource> export() {
        LOGGER.debug("Export File Formats");
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Response response = this.fileFormatInternalService.export(vitamContext);
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            InputStreamResource resource = new InputStreamResource((InputStream)entity);
            return new ResponseEntity((Object)resource, HttpStatus.OK);
        }
        return null;
    }

    private JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("get logbook for file format with id :{}", (Object)id);
        return this.fileFormatInternalService.findHistoryByIdentifier(vitamContext, id);
    }

    @PostMapping(value={"/import"})
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    public JsonNode importFileFormats(@RequestParam(value="fileName") String fileName, @RequestParam(value="file") MultipartFile file) {
        SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
        SanityChecker.isValidFileName((String)fileName);
        SafeFileChecker.checkSafeFilePath((String)fileName);
        LOGGER.debug("import file format file {}", (Object)fileName);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.fileFormatInternalService.importFileFormats(vitamContext, fileName, file);
    }

    @Generated
    public FileFormatInternalService getFileFormatInternalService() {
        return this.fileFormatInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setFileFormatInternalService(FileFormatInternalService fileFormatInternalService) {
        this.fileFormatInternalService = fileFormatInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

