/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.common.security.SafeFileChecker;
import fr.gouv.vitamui.common.security.SanityChecker;
import fr.gouv.vitamui.commons.api.ParameterChecker;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.rest.util.RestUtils;
import fr.gouv.vitamui.iam.security.service.InternalSecurityService;
import fr.gouv.vitamui.referential.common.dto.AgencyDto;
import fr.gouv.vitamui.referential.internal.server.agency.AgencyInternalService;
import fr.gouv.vitamui.referential.internal.server.utils.ExportCSVUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.core.Response;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/referential/v1/agency"})
public class AgencyInternalController {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AgencyInternalController.class);
    @Autowired
    private AgencyInternalService agencyInternalService;
    @Autowired
    private InternalSecurityService securityService;

    @GetMapping
    public Collection<AgencyDto> getAll(@RequestParam Optional<String> criteria) {
        LOGGER.debug("get all customer criteria={}", criteria);
        SanityChecker.sanitizeCriteria(criteria);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.agencyInternalService.getAll(vitamContext);
    }

    @GetMapping(params={"page", "size"})
    public PaginatedValuesDto<AgencyDto> getAllPaginated(@RequestParam Integer page, @RequestParam Integer size, @RequestParam(required=false) Optional<String> criteria, @RequestParam(required=false) Optional<String> orderBy, @RequestParam(required=false) Optional<DirectionDto> direction) {
        LOGGER.debug("getPaginateEntities page={}, size={}, criteria={}, orderBy={}, ascendant={}", new Object[]{page, size, criteria, orderBy, direction});
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.agencyInternalService.getAllPaginated(page, size, orderBy, direction, vitamContext, criteria);
    }

    @GetMapping(path={"/{identifier:.+}"})
    public AgencyDto getOne(@PathVariable(value="identifier") String identifier) throws UnsupportedEncodingException {
        LOGGER.debug("get agency identifier={} / {}", (Object)identifier, (Object)URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return this.agencyInternalService.getOne(vitamContext, URLDecoder.decode(identifier, StandardCharsets.UTF_8.toString()));
    }

    @PostMapping(value={"/check"})
    public ResponseEntity<Void> checkExist(@RequestBody AgencyDto accessContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("check exist accessContract={}", (Object)accessContractDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        accessContractDto.setTenant(tenant);
        boolean exist = this.agencyInternalService.check(vitamContext, accessContractDto);
        return RestUtils.buildBooleanResponse((boolean)exist);
    }

    @PostMapping
    public AgencyDto create(@Valid @RequestBody AgencyDto accessContractDto, @RequestHeader(value="X-Tenant-Id") Integer tenant) {
        LOGGER.debug("create accessContract={}", (Object)accessContractDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        accessContractDto.setTenant(tenant);
        return this.agencyInternalService.create(vitamContext, accessContractDto);
    }

    @PatchMapping(value={"/{id}"})
    public AgencyDto patch(@PathVariable(value="id") String id, @RequestBody Map<String, Object> partialDto) {
        LOGGER.debug("Patch {} with {}", (Object)id, partialDto);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Assert.isTrue((boolean)StringUtils.equals((CharSequence)id, (CharSequence)((String)partialDto.get("id"))), (String)"The DTO identifier must match the path identifier for update.");
        return this.agencyInternalService.patch(vitamContext, partialDto);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> delete(@PathVariable(value="id") String id) {
        ParameterChecker.checkParameter((String)"The Identifier is a mandatory parameter: ", (String[])new String[]{id});
        SanityChecker.checkSecureParameter((String[])new String[]{id});
        LOGGER.debug("Delete {}", (Object)id);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        return RestUtils.buildBooleanResponse((boolean)this.agencyInternalService.delete(vitamContext, id));
    }

    @GetMapping(value={"/export"})
    public ResponseEntity<Resource> export() {
        LOGGER.debug("Export Agencies");
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        Response response = this.agencyInternalService.export(vitamContext);
        Object entity = response.getEntity();
        if (entity instanceof InputStream) {
            SequenceInputStream mergedBomCsvInputStream = new SequenceInputStream(new ByteArrayInputStream(ExportCSVUtils.BOM), (InputStream)entity);
            InputStreamResource resource = new InputStreamResource((InputStream)mergedBomCsvInputStream);
            return new ResponseEntity((Object)resource, HttpStatus.OK);
        }
        return null;
    }

    @GetMapping(value={"/{id}/history"})
    public JsonNode findHistoryById(@PathVariable(value="id") String id) throws VitamClientException {
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        LOGGER.debug("get logbook for agency with id :{}", (Object)id);
        return this.agencyInternalService.findHistoryByIdentifier(vitamContext, id);
    }

    @PostMapping(value={"/import"})
    public ResponseEntity importAgencies(@RequestParam(value="fileName") String fileName, @RequestParam(value="file") MultipartFile file) {
        if (file != null) {
            SafeFileChecker.checkSafeFilePath((String)file.getOriginalFilename());
            SanityChecker.isValidFileName((String)file.getOriginalFilename());
        }
        SanityChecker.isValidFileName((String)fileName);
        SafeFileChecker.checkSafeFilePath((String)fileName);
        LOGGER.debug("import agency file {}", (Object)fileName);
        VitamContext vitamContext = this.securityService.buildVitamContext(this.securityService.getTenantIdentifier());
        RequestResponse requestResponse = this.agencyInternalService.importAgencies(vitamContext, fileName, file);
        return new ResponseEntity((Object)requestResponse.toJsonNode(), HttpStatus.valueOf((int)requestResponse.getHttpCode()));
    }

    @Generated
    public AgencyInternalService getAgencyInternalService() {
        return this.agencyInternalService;
    }

    @Generated
    public InternalSecurityService getSecurityService() {
        return this.securityService;
    }

    @Generated
    public void setAgencyInternalService(AgencyInternalService agencyInternalService) {
        this.agencyInternalService = agencyInternalService;
    }

    @Generated
    public void setSecurityService(InternalSecurityService securityService) {
        this.securityService = securityService;
    }
}

