/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.operation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientServerException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationDto;
import fr.gouv.vitamui.referential.common.dto.LogbookOperationsResponseDto;
import fr.gouv.vitamui.referential.common.dto.ReportType;
import fr.gouv.vitamui.referential.common.service.OperationService;
import fr.gouv.vitamui.referential.internal.server.operation.OperationConverter;
import fr.gouv.vitamui.referential.internal.server.service.ExternalParametersService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(OperationInternalService.class);
    private final OperationService operationService;
    private final LogbookService logbookService;
    private final ExternalParametersService externalParametersService;
    private final String AUDIT_FILE_CONSISTENCY = "AUDIT_FILE_CONSISTENCY";
    private final String AUDIT_FILE_RECTIFICATION = "AUDIT_FILE_RECTIFICATION";
    private final String AUDIT_FILE_INTEGRITY = "AUDIT_FILE_INTEGRITY";
    private final String AUDIT_FILE_EXISTING = "AUDIT_FILE_EXISTING";
    private final List<String> AUDITS_WITHOUT_PROJECTION = List.of("AUDIT_FILE_INTEGRITY", "AUDIT_FILE_EXISTING");
    public static final String DSL_QUERY_PROJECTION = "$projection";
    public static final String DSL_QUERY_FILTER = "$filter";
    public static final String DSL_QUERY_FACETS = "$facets";
    private final ObjectMapper objectMapper;

    @Autowired
    OperationInternalService(OperationService operationService, LogbookService logbookService, ObjectMapper objectMapper, ExternalParametersService externalParametersService) {
        this.operationService = operationService;
        this.logbookService = logbookService;
        this.objectMapper = objectMapper;
        this.externalParametersService = externalParametersService;
    }

    public PaginatedValuesDto<LogbookOperationDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        Map vitamCriteria = new HashMap();
        LOGGER.info("All Operations EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find LogbookOperations with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        LogbookOperationsResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<LogbookOperationDto> valuesDto = OperationConverter.convertVitamsToDtos(results.getResults());
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    private LogbookOperationsResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            LOGGER.info("All Operations EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.logbookService.selectOperations(query, vitamContext);
            LogbookOperationsResponseDto logbookOperationsResponseDto = (LogbookOperationsResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), LogbookOperationsResponseDto.class);
            return logbookOperationsResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find LogbookOperations", e);
        }
    }

    public void runAudit(VitamContext context, AuditOptions auditOptions) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            Optional<Long> thresholdOpt = this.externalParametersService.retrieveProfilThreshold();
            LOGGER.info("All Operations Audit EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            this.updateAuditDslQuery(auditOptions, thresholdOpt);
            auditOptions.setAuditType("dsl");
            if ("AUDIT_FILE_CONSISTENCY".equals(auditOptions.getAuditActions())) {
                this.operationService.lauchEvidenceAudit(context, auditOptions.getQuery());
            } else if ("AUDIT_FILE_RECTIFICATION".equals(auditOptions.getAuditActions())) {
                this.operationService.launchRectificationAudit(context, auditOptions.getAuditType());
            } else {
                this.operationService.runAudit(context, mapper.valueToTree((Object)auditOptions));
            }
        }
        catch (AccessExternalClientServerException | VitamClientException | BadRequestException e) {
            throw new InternalServerException("Unable to run audit", e);
        }
    }

    public void updateAuditDslQuery(AuditOptions auditOptions, Optional<Long> thresholdOpt) {
        SelectMultiQuery multiQuery = new SelectMultiQuery();
        try {
            if (!List.of("originatingagency", "tenant", "dsl").contains(auditOptions.getAuditType()) || null == thresholdOpt) {
                throw new InvalidCreateOperationException("Invalid audit query");
            }
            if ("originatingagency".equals(auditOptions.getAuditType())) {
                multiQuery.setQuery((Query)QueryHelper.eq((String)"#originating_agency", (String)auditOptions.getObjectId()));
                auditOptions.setQuery((JsonNode)multiQuery.getFinalSelect());
            } else if ("tenant".equals(auditOptions.getAuditType())) {
                multiQuery.setQuery((Query)QueryHelper.eq((String)"#tenant", (String)auditOptions.getObjectId()));
                auditOptions.setQuery((JsonNode)multiQuery.getFinalSelect());
            }
            if (thresholdOpt.isPresent()) {
                ObjectNode previousDslQuery = (ObjectNode)auditOptions.getQuery();
                previousDslQuery.put("$threshold", thresholdOpt.get());
                auditOptions.setQuery((JsonNode)previousDslQuery);
            }
            Arrays.stream(new String[]{DSL_QUERY_PROJECTION, DSL_QUERY_FILTER, DSL_QUERY_FACETS}).forEach(arg_0 -> ((ObjectNode)((ObjectNode)auditOptions.getQuery())).remove(arg_0));
            if (!this.AUDITS_WITHOUT_PROJECTION.contains(auditOptions.getAuditActions())) {
                ObjectNode dslQueryProjection = (ObjectNode)auditOptions.getQuery();
                dslQueryProjection.put(DSL_QUERY_PROJECTION, this.objectMapper.readTree("{}"));
                auditOptions.setQuery((JsonNode)dslQueryProjection);
            }
        }
        catch (InvalidCreateOperationException e) {
            LOGGER.error(e.getMessage());
            throw new BadRequestException(e.getMessage());
        }
        catch (JsonMappingException e) {
            LOGGER.error(e.getMessage());
            throw new BadRequestException(e.getMessage());
        }
        catch (JsonProcessingException e) {
            LOGGER.error(e.getMessage());
            throw new BadRequestException(e.getMessage());
        }
    }

    public Response export(VitamContext context, String id, ReportType type) {
        try {
            LOGGER.info("Export  Operations EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            switch (type) {
                case AUDIT: {
                    return this.operationService.exportAudit(context, id);
                }
                case TRACEABILITY: {
                    return this.operationService.exportTraceability(context, id);
                }
            }
            throw new InternalServerException("Unable to  export that kind of report: " + type);
        }
        catch (AccessExternalClientServerException | VitamClientException e) {
            throw new InternalServerException("Unable to export operation report", e);
        }
    }

    public JsonNode checkTraceabilityOperation(VitamContext vitamContext, String id) {
        Select select = new Select();
        try {
            BooleanQuery query = QueryHelper.and();
            query.add(new Query[]{QueryHelper.eq((String)"evIdProc", (String)id)});
            select.setQuery((Query)query);
            RequestResponse response = this.logbookService.checkTraceability(vitamContext, (JsonNode)select.getFinalSelect());
            return response.toJsonNode();
        }
        catch (AccessExternalClientServerException | InvalidCreateOperationException | AccessUnauthorizedException | InvalidParseOperationException e) {
            throw new InternalServerException("Unable to check traceability operation", e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) {
        try {
            LOGGER.info("Operation History EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
            RequestResponse requestResponse = this.logbookService.selectOperationbyId(id, vitamContext);
            return requestResponse.toJsonNode();
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    public void runProbativeValue(VitamContext context, ProbativeValueRequest probativeValueRequest) {
        try {
            LOGGER.info("All Operations Probative Value EvIdAppSession : {} ", (Object)context.getApplicationSessionId());
            this.operationService.runProbativeValue(context, probativeValueRequest);
        }
        catch (VitamClientException e) {
            throw new InternalServerException("Unable to generate Probative value", (Throwable)e);
        }
    }
}

