/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.logbookmanagement;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitamui.commons.api.enums.OperationActionStatus;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.administration.VitamOperationService;
import fr.gouv.vitamui.commons.vitam.api.dto.ProcessDetailDto;
import fr.gouv.vitamui.commons.vitam.api.dto.VitamUIProcessDetailResponseDto;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogbookManagementOperationInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(LogbookManagementOperationInternalService.class);
    private static final String START_MAX_DATE = "30/12/2999";
    private static final String START_MIN_DATE = "01/01/1900";
    private ObjectMapper objectMapper;
    private VitamOperationService vitamOperationService;

    @Autowired
    public LogbookManagementOperationInternalService(ObjectMapper objectMapper, VitamOperationService vitamOperationService) {
        this.objectMapper = objectMapper;
        this.vitamOperationService = vitamOperationService;
    }

    public ProcessDetailDto searchOperationsDetails(VitamContext vitamContext, ProcessQuery processQuery) throws VitamClientException, JsonProcessingException {
        LOGGER.info("Get Operations Details with processQuery = {}", (Object)processQuery);
        if (processQuery.getStartDateMax() == null) {
            processQuery.setStartDateMax(START_MAX_DATE);
        }
        if (processQuery.getStartDateMin() == null) {
            processQuery.setStartDateMin(START_MIN_DATE);
        }
        JsonNode response = this.vitamOperationService.listOperationsDetails(vitamContext, processQuery).toJsonNode();
        VitamUIProcessDetailResponseDto processDetailResponse = (VitamUIProcessDetailResponseDto)this.objectMapper.treeToValue((TreeNode)response, VitamUIProcessDetailResponseDto.class);
        VitamUIProcessDetailResponseDto responseFilled = new VitamUIProcessDetailResponseDto();
        responseFilled.setContext(processDetailResponse.getContext());
        responseFilled.setFacetResults(processDetailResponse.getFacetResults());
        responseFilled.setResults(processDetailResponse.getResults());
        responseFilled.setHits(processDetailResponse.getHits());
        return new ProcessDetailDto(responseFilled);
    }

    public ProcessDetailDto updateOperationActionProcess(VitamContext vitamContext, String actionId, String operationId) throws VitamClientException, JsonProcessingException, InterruptedException {
        LOGGER.info("Update operation Id= {} with the action Id= {}", (Object)operationId, (Object)actionId);
        if (!EnumUtils.isValidEnum(OperationActionStatus.class, (String)actionId)) {
            LOGGER.error("Cannot update  the operation, because the actionId= {} given is not correct ", (Object)actionId);
            throw new VitamClientException("Cannot update  the operation, because the actionId given is not correct");
        }
        this.vitamOperationService.updateOperationActionProcess(vitamContext, actionId, operationId);
        ProcessQuery processQuery = new ProcessQuery();
        processQuery.setId(operationId);
        ProcessDetailDto operation = this.searchOperationsDetails(vitamContext, processQuery);
        return operation;
    }

    public ProcessDetailDto cancelOperationProcessExecution(VitamContext vitamContext, String operationId) throws VitamClientException, JsonProcessingException {
        LOGGER.info("Cancel the operation Id=  {}", (Object)operationId);
        this.vitamOperationService.cancelOperationProcessExecution(vitamContext, operationId);
        ProcessQuery processQuery = new ProcessQuery();
        processQuery.setId(operationId);
        ProcessDetailDto operation = this.searchOperationsDetails(vitamContext, processQuery);
        return operation;
    }
}

