/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.ingestcontract;

import fr.gouv.vitam.common.model.administration.IngestContractCheckState;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.SignaturePolicy;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.referential.common.dto.IngestContractDto;
import fr.gouv.vitamui.referential.common.dto.SignaturePolicyDto;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class IngestContractConverter {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(IngestContractConverter.class);

    public IngestContractModel convertDtoToVitam(IngestContractDto dto) {
        IngestContractModel ingestContract = (IngestContractModel)VitamUIUtils.copyProperties((Object)dto, (Object)new IngestContractModel());
        if (dto.getCheckParentId() != null) {
            ingestContract.setCheckParentId(new HashSet(dto.getCheckParentId()));
        }
        if (dto.getCheckParentLink() != null) {
            ingestContract.setCheckParentLink(IngestContractCheckState.valueOf((String)dto.getCheckParentLink()));
        }
        ingestContract.setCreationdate(dto.getCreationDate());
        ingestContract.setLastupdate(dto.getLastUpdate());
        ingestContract.setActivationdate(dto.getActivationDate());
        ingestContract.setDeactivationdate(dto.getDeactivationDate());
        ingestContract.setComputeInheritedRulesAtIngest(dto.isComputeInheritedRulesAtIngest());
        ingestContract.setSignaturePolicy(this.convertDtoToVitam(dto.getSignaturePolicy()));
        return ingestContract;
    }

    public IngestContractDto convertVitamToDto(IngestContractModel ingestContract) {
        IngestContractDto dto = (IngestContractDto)VitamUIUtils.copyProperties((Object)ingestContract, (Object)new IngestContractDto());
        if (ingestContract.getCheckParentLink() != null) {
            dto.setCheckParentLink(ingestContract.getCheckParentLink().name());
        }
        dto.setMasterMandatory(ingestContract.isMasterMandatory());
        dto.setFormatUnidentifiedAuthorized(ingestContract.isFormatUnidentifiedAuthorized());
        dto.setEveryFormatType(ingestContract.isEveryFormatType());
        dto.setEveryDataObjectVersion(ingestContract.isEveryDataObjectVersion());
        dto.setComputeInheritedRulesAtIngest(ingestContract.isComputeInheritedRulesAtIngest());
        dto.setCreationDate(ingestContract.getCreationdate());
        dto.setLastUpdate(ingestContract.getLastupdate());
        dto.setActivationDate(ingestContract.getActivationdate());
        dto.setDeactivationDate(ingestContract.getDeactivationdate());
        dto.setSignaturePolicy(this.convertVitamToDto(ingestContract.getSignaturePolicy()));
        return dto;
    }

    public SignaturePolicyDto convertVitamToDto(SignaturePolicy vitam) {
        if (Objects.isNull(vitam)) {
            return null;
        }
        return new SignaturePolicyDto().setSignedDocument(vitam.getSignedDocument()).setDeclaredSignature(vitam.isDeclaredSignature()).setDeclaredTimestamp(vitam.isDeclaredTimestamp()).setDeclaredAdditionalProof(vitam.isDeclaredAdditionalProof());
    }

    public SignaturePolicy convertDtoToVitam(SignaturePolicyDto dto) {
        if (Objects.isNull(dto)) {
            return null;
        }
        SignaturePolicy signaturePolicy = new SignaturePolicy();
        signaturePolicy.setSignedDocument(dto.getSignedDocument());
        signaturePolicy.setDeclaredSignature(dto.getDeclaredSignature());
        signaturePolicy.setDeclaredTimestamp(dto.getDeclaredTimestamp());
        signaturePolicy.setDeclaredAdditionalProof(dto.getDeclaredAdditionalProof());
        return signaturePolicy;
    }

    public List<IngestContractModel> convertDtosToVitams(List<IngestContractDto> dtos) {
        return dtos.stream().map(this::convertDtoToVitam).collect(Collectors.toList());
    }

    public List<IngestContractDto> convertVitamsToDtos(List<IngestContractModel> ingestContracts) {
        return ingestContracts.stream().map(this::convertVitamToDto).collect(Collectors.toList());
    }
}

