/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.context;

import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.PermissionModel;
import fr.gouv.vitamui.commons.utils.VitamUIUtils;
import fr.gouv.vitamui.referential.common.dto.ContextDto;
import fr.gouv.vitamui.referential.common.dto.PermissionDto;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ContextConverter {
    public ContextModel convertDtoToVitam(ContextDto dto) {
        ContextModel context = (ContextModel)VitamUIUtils.copyProperties((Object)dto, (Object)new ContextModel());
        return context;
    }

    public ContextDto convertVitamToDto(ContextModel context) {
        ContextDto dto = (ContextDto)VitamUIUtils.copyProperties((Object)context, (Object)new ContextDto());
        if (context.getStatus() != null) {
            dto.setStatus(context.getStatus().toString());
        }
        dto.setCreationDate(context.getCreationdate());
        dto.setLastUpdate(context.getLastupdate());
        dto.setDeactivationDate(context.getDeactivationdate());
        dto.setActivationDate(context.getActivationdate());
        dto.setEnableControl(context.isEnablecontrol());
        dto.setSecurityProfile(context.getSecurityProfileIdentifier());
        HashSet<PermissionDto> permissions = new HashSet<PermissionDto>();
        for (PermissionModel permission : context.getPermissions()) {
            PermissionDto permissionDto = new PermissionDto();
            permissionDto.setTenant(permission.getTenant().toString());
            permissionDto.setAccessContracts(permission.getAccessContract());
            permissionDto.setIngestContracts(permission.getIngestContract());
            permissions.add(permissionDto);
        }
        dto.setPermissions(permissions);
        return dto;
    }

    public List<ContextModel> convertDtosToVitams(List<ContextDto> dtos) {
        return dtos.stream().map(this::convertDtoToVitam).collect(Collectors.toList());
    }

    public List<ContextDto> convertVitamsToDtos(List<ContextModel> contexts) {
        return contexts.stream().map(this::convertVitamToDto).collect(Collectors.toList());
    }
}

