/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitamui.referential.internal.server.agency;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.gouv.vitam.access.external.common.exception.AccessExternalClientException;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitamui.commons.api.domain.AgencyModelDto;
import fr.gouv.vitamui.commons.api.domain.DirectionDto;
import fr.gouv.vitamui.commons.api.domain.PaginatedValuesDto;
import fr.gouv.vitamui.commons.api.exception.BadRequestException;
import fr.gouv.vitamui.commons.api.exception.ConflictException;
import fr.gouv.vitamui.commons.api.exception.InternalServerException;
import fr.gouv.vitamui.commons.api.exception.VitamUIException;
import fr.gouv.vitamui.commons.api.logger.VitamUILogger;
import fr.gouv.vitamui.commons.api.logger.VitamUILoggerFactory;
import fr.gouv.vitamui.commons.vitam.api.access.LogbookService;
import fr.gouv.vitamui.commons.vitam.api.administration.AgencyService;
import fr.gouv.vitamui.referential.common.dsl.VitamQueryHelper;
import fr.gouv.vitamui.referential.common.dto.AgencyDto;
import fr.gouv.vitamui.referential.common.dto.AgencyResponseDto;
import fr.gouv.vitamui.referential.common.service.VitamAgencyService;
import fr.gouv.vitamui.referential.internal.server.agency.AgencyConverter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AgencyInternalService {
    private static final VitamUILogger LOGGER = VitamUILoggerFactory.getInstance(AgencyInternalService.class);
    private AgencyService agencyService;
    private ObjectMapper objectMapper;
    private AgencyConverter converter;
    private LogbookService logbookService;
    private VitamAgencyService vitamAgencyService;

    @Autowired
    public AgencyInternalService(AgencyService agencyService, ObjectMapper objectMapper, AgencyConverter converter, LogbookService logbookService, VitamAgencyService vitamAgencyService) {
        this.agencyService = agencyService;
        this.objectMapper = objectMapper;
        this.converter = converter;
        this.logbookService = logbookService;
        this.vitamAgencyService = vitamAgencyService;
    }

    public AgencyDto getOne(VitamContext vitamContext, String identifier) {
        try {
            RequestResponse requestResponse = this.agencyService.findAgencyById(vitamContext, identifier);
            AgencyResponseDto accessContractResponseDto = (AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class);
            if (accessContractResponseDto.getResults().size() == 0) {
                return null;
            }
            return this.converter.convertVitamToDto((AgencyModelDto)accessContractResponseDto.getResults().get(0));
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to get Agency", e);
        }
    }

    public List<AgencyDto> getAll(VitamContext vitamContext) {
        try {
            RequestResponse requestResponse = this.agencyService.findAgencies(vitamContext, (JsonNode)new Select().getFinalSelect());
            AgencyResponseDto agencyResponseDto = (AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class);
            return this.converter.convertVitamsToDtos(agencyResponseDto.getResults());
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find agencies", e);
        }
    }

    public PaginatedValuesDto<AgencyDto> getAllPaginated(Integer pageNumber, Integer size, Optional<String> orderBy, Optional<DirectionDto> direction, VitamContext vitamContext, Optional<String> criteria) {
        JsonNode query;
        if (vitamContext != null) {
            LOGGER.info("All Agencies EvIdAppSession : {} ", (Object)vitamContext.getApplicationSessionId());
        }
        Map vitamCriteria = new HashMap();
        try {
            if (criteria.isPresent()) {
                TypeReference<HashMap<String, Object>> typRef = new TypeReference<HashMap<String, Object>>(){};
                vitamCriteria = (Map)this.objectMapper.readValue(criteria.get(), (TypeReference)typRef);
            }
            query = VitamQueryHelper.createQueryDSL(vitamCriteria, (Integer)pageNumber, (Integer)size, orderBy, direction);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException ioe) {
            throw new InternalServerException("Unable to find agencies with pagination", ioe);
        }
        catch (IOException e) {
            throw new InternalServerException("Can't parse criteria as Vitam query", (Throwable)e);
        }
        AgencyResponseDto results = this.findAll(vitamContext, query);
        boolean hasMore = pageNumber * size + results.getHits().getSize() < results.getHits().getTotal();
        List<AgencyDto> valuesDto = this.converter.convertVitamsToDtos(results.getResults());
        return new PaginatedValuesDto(valuesDto, pageNumber.intValue(), results.getHits().getSize().intValue(), hasMore);
    }

    private AgencyResponseDto findAll(VitamContext vitamContext, JsonNode query) {
        try {
            RequestResponse requestResponse = this.agencyService.findAgencies(vitamContext, query);
            AgencyResponseDto agencyResponseDto = (AgencyResponseDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyResponseDto.class);
            return agencyResponseDto;
        }
        catch (JsonProcessingException | VitamClientException e) {
            throw new InternalServerException("Unable to find agencies", e);
        }
    }

    public Boolean check(VitamContext vitamContext, AgencyDto agencyDto) {
        try {
            Integer agencyCheckedTenant = this.vitamAgencyService.checkAbilityToCreateAgencyInVitam(this.converter.convertDtosToVitams(Arrays.asList(agencyDto)), vitamContext.getApplicationSessionId());
            return !vitamContext.getTenantId().equals(agencyCheckedTenant);
        }
        catch (ConflictException e) {
            return true;
        }
        catch (VitamUIException e) {
            throw new InternalServerException("Unable to check agency", (Throwable)e);
        }
    }

    public AgencyDto create(VitamContext vitamContext, AgencyDto accessContractDto) {
        try {
            RequestResponse requestResponse = this.vitamAgencyService.create(vitamContext, this.converter.convertDtoToVitam(accessContractDto));
            AgencyModelDto accessContractVitamDto = (AgencyModelDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyModelDto.class);
            return this.converter.convertVitamToDto(accessContractVitamDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to create agency", e);
        }
    }

    public AgencyDto patch(VitamContext vitamContext, Map<String, Object> partialDto) {
        AgencyDto accessContractDto = this.getOne(vitamContext, (String)partialDto.get("identifier"));
        partialDto.forEach((key, value) -> {
            if (!"id".equals(key)) {
                try {
                    BeanUtilsBean.getInstance().copyProperty((Object)accessContractDto, key, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        });
        AgencyModelDto accessContractVitam = this.converter.convertDtoToVitam(accessContractDto);
        try {
            RequestResponse requestResponse = this.vitamAgencyService.patchAgency(vitamContext, (String)partialDto.get("id"), accessContractVitam);
            AgencyModelDto accessContractVitamDto = (AgencyModelDto)this.objectMapper.treeToValue((TreeNode)requestResponse.toJsonNode(), AgencyModelDto.class);
            return this.converter.convertVitamToDto(accessContractVitamDto);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to patch agency", e);
        }
    }

    public boolean delete(VitamContext context, String id) {
        try {
            return this.vitamAgencyService.deleteAgency(context, id);
        }
        catch (BadRequestException e) {
            return false;
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            throw new InternalServerException("Unable to delete agency", e);
        }
    }

    public Response export(VitamContext context) {
        try {
            return this.vitamAgencyService.export(context);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | VitamClientException e) {
            throw new InternalServerException("Unable to export agencies", e);
        }
    }

    public JsonNode findHistoryByIdentifier(VitamContext vitamContext, String id) throws VitamClientException {
        try {
            return this.logbookService.selectOperations(VitamQueryHelper.buildOperationQuery((String)id), vitamContext).toJsonNode();
        }
        catch (InvalidCreateOperationException e) {
            throw new InternalServerException("Unable to fetch history", (Throwable)e);
        }
    }

    public RequestResponse importAgencies(VitamContext context, String fileName, MultipartFile file) {
        try {
            return this.vitamAgencyService.importAgencies(context, fileName, file);
        }
        catch (AccessExternalClientException | InvalidParseOperationException | VitamClientException | IOException e) {
            LOGGER.error("Unable to import agency file {}: {}", (Object)fileName, (Object)e.getMessage());
            throw new InternalServerException("Unable to import agency file " + fileName + " : ", e);
        }
    }
}

